/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.restapi;

import io.jenkins.plugins.coverage.metrics.restapi.LineCoverageType;
import java.util.Objects;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
class ModifiedLinesBlock
implements Comparable<ModifiedLinesBlock> {
    private final int startLine;
    private final int endLine;
    private final LineCoverageType type;

    ModifiedLinesBlock(int startLine, int endLine, LineCoverageType type) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.type = type;
    }

    @Exported
    public int getStartLine() {
        return this.startLine;
    }

    @Exported
    public int getEndLine() {
        return this.endLine;
    }

    @Exported
    public LineCoverageType getType() {
        return this.type;
    }

    @Override
    public int compareTo(ModifiedLinesBlock other) {
        return this.startLine - other.startLine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifiedLinesBlock that = (ModifiedLinesBlock)o;
        return this.getStartLine() == that.getStartLine() && this.getEndLine() == that.getEndLine() && this.getType() == that.getType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getStartLine(), this.getEndLine(), this.getType()});
    }
}

