/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.ContainerNode;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.Difference;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.MethodNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Mutation;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.util.XStream2;
import io.jenkins.plugins.util.AbstractXmlStream;
import io.jenkins.plugins.util.QualityGateResult;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.math.Fraction;

class CoverageXmlStream
extends AbstractXmlStream<Node> {
    private static final Collector<CharSequence, ?, String> ARRAY_JOINER = Collectors.joining(", ", "[", "]");

    private static String[] toArray(String value) {
        String cleanInput = Strings.CS.removeEnd(Strings.CS.removeStart(StringUtils.deleteWhitespace((String)value), (CharSequence)"["), (CharSequence)"]");
        return StringUtils.split((String)cleanInput, (String)",");
    }

    CoverageXmlStream() {
        super(Node.class);
    }

    @VisibleForTesting
    public XStream2 getStream() {
        return this.createStream();
    }

    protected void configureXStream(XStream2 xStream) {
        CoverageXmlStream.registerConverters(xStream);
        xStream.alias("container", ContainerNode.class);
        xStream.alias("module", ModuleNode.class);
        xStream.alias("package", PackageNode.class);
        xStream.alias("file", FileNode.class);
        xStream.alias("class", ClassNode.class);
        xStream.alias("method", MethodNode.class);
        xStream.alias("mutation", Mutation.class);
        xStream.registerLocalConverter(FileNode.class, "coveredPerLine", (Converter)new IntegerLineMapConverter());
        xStream.registerLocalConverter(FileNode.class, "missedPerLine", (Converter)new IntegerLineMapConverter());
        xStream.registerLocalConverter(FileNode.class, "indirectCoverageChanges", (Converter)new IntegerLineMapConverter());
        xStream.registerLocalConverter(FileNode.class, "changedLines", (Converter)new IntegerSetConverter());
        xStream.registerLocalConverter(FileNode.class, "coverageDelta", (Converter)new MetricFractionMapConverter());
    }

    static void registerConverters(XStream2 xStream) {
        xStream.alias("edu.hm.hafner.coverage.TestCount", Value.class);
        xStream.alias("loc", Value.class);
        xStream.alias("complexity", Value.class);
        xStream.alias("metric", Metric.class);
        xStream.alias("coverage", Coverage.class);
        xStream.alias("value", Value.class);
        xStream.alias("delta", Difference.class);
        xStream.addImmutableType(Coverage.class, false);
        xStream.addImmutableType(Value.class, false);
        xStream.alias("item", QualityGateResult.QualityGateResultItem.class);
        xStream.registerConverter((Converter)new FractionConverter());
        xStream.registerConverter(new SimpleConverter<Value>(Value.class, Value::serialize, Value::valueOf));
        xStream.registerConverter(new SimpleConverter<Metric>(Metric.class, Enum::name, Metric::valueOf));
    }

    protected Node createDefaultValue() {
        return new ModuleNode("Empty");
    }

    static final class IntegerLineMapConverter
    extends TreeMapConverter<Integer, Integer> {
        IntegerLineMapConverter() {
        }

        @Override
        protected Function<Map.Entry<Integer, Integer>, String> createMapEntry() {
            return e -> "%d: %d".formatted(e.getKey(), e.getValue());
        }

        @Override
        protected Map.Entry<Integer, Integer> createMapping(String key, String value) {
            return this.entry(Integer.valueOf(key), Integer.valueOf(value));
        }
    }

    static final class IntegerSetConverter
    implements Converter {
        IntegerSetConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            writer.setValue(source instanceof TreeSet ? this.marshal((TreeSet)source) : null);
        }

        String marshal(Set<Integer> lines) {
            return lines.stream().map(String::valueOf).collect(ARRAY_JOINER);
        }

        public NavigableSet<Integer> unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return this.unmarshal(reader.getValue());
        }

        NavigableSet<Integer> unmarshal(String value) {
            return Arrays.stream(CoverageXmlStream.toArray(value)).map(Integer::valueOf).collect(Collectors.toCollection(TreeSet::new));
        }

        public boolean canConvert(Class type) {
            return type == TreeSet.class;
        }
    }

    static final class MetricFractionMapConverter
    extends TreeMapConverter<Metric, Value> {
        MetricFractionMapConverter() {
        }

        @Override
        protected Function<Map.Entry<Metric, Value>, String> createMapEntry() {
            return e -> ((Value)e.getValue()).serialize();
        }

        @Override
        protected Map.Entry<Metric, Value> createMapping(String key, String value) {
            Metric metric = Metric.valueOf((String)key);
            Fraction deserialized = Fraction.getFraction((String)value);
            if (metric.isCoverage()) {
                deserialized = deserialized.multiplyBy(Fraction.getFraction((double)100.0));
            }
            return this.entry(metric, new Difference(metric, deserialized));
        }
    }

    static final class FractionConverter
    implements Converter {
        FractionConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            String string;
            if (source instanceof Fraction) {
                Fraction f = (Fraction)source;
                string = f.toProperString();
            } else {
                string = null;
            }
            writer.setValue(string);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return Fraction.getFraction((String)reader.getValue());
        }

        public boolean canConvert(Class type) {
            return type == Fraction.class;
        }
    }

    public static class SimpleConverter<T>
    implements Converter {
        private final Class<T> type;
        private final Function<T, String> marshaller;
        private final Function<String, Object> unmarshaller;

        protected SimpleConverter(Class<T> type, Function<T, String> marshaller, Function<String, Object> unmarshaller) {
            this.type = type;
            this.marshaller = marshaller;
            this.unmarshaller = unmarshaller;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            writer.setValue(this.type.isInstance(source) ? this.marshaller.apply(this.type.cast(source)) : null);
        }

        public final Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return this.unmarshaller.apply(reader.getValue());
        }

        public final boolean canConvert(Class clazz) {
            return this.type.isAssignableFrom(clazz);
        }
    }

    static abstract class TreeMapConverter<K extends Comparable<K>, V>
    implements Converter {
        TreeMapConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            writer.setValue(source instanceof NavigableMap ? this.marshal((NavigableMap)source) : null);
        }

        String marshal(SortedMap<K, V> source) {
            return source.entrySet().stream().map(this.createMapEntry()).collect(ARRAY_JOINER);
        }

        public boolean canConvert(Class type) {
            return type == TreeMap.class;
        }

        public NavigableMap<K, V> unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return this.unmarshal(reader.getValue());
        }

        NavigableMap<K, V> unmarshal(String value) {
            TreeMap<Comparable, V> map = new TreeMap<Comparable, V>();
            for (String marshalledValue : CoverageXmlStream.toArray(value)) {
                if (!Strings.CS.contains((CharSequence)marshalledValue, (CharSequence)":")) continue;
                try {
                    Map.Entry<K, V> entry = this.createMapping(StringUtils.substringBefore((String)marshalledValue, (int)58), StringUtils.substringAfter((String)marshalledValue, (int)58));
                    map.put((Comparable)entry.getKey(), entry.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return map;
        }

        protected abstract Function<Map.Entry<K, V>, String> createMapEntry();

        protected abstract Map.Entry<K, V> createMapping(String var1, String var2);

        protected AbstractMap.SimpleEntry<K, V> entry(K key, V value) {
            return new AbstractMap.SimpleEntry<K, V>(key, value);
        }
    }
}

