/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Percentage;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.echarts.LabeledTreeMapNode;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Api;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.bootstrap5.MessagesViewModel;
import io.jenkins.plugins.coverage.metrics.charts.TreeMapNodeConverter;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;
import io.jenkins.plugins.coverage.metrics.color.ColorProviderFactory;
import io.jenkins.plugins.coverage.metrics.color.CoverageColorJenkinsId;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.restapi.CoverageApi;
import io.jenkins.plugins.coverage.metrics.restapi.ModifiedLinesCoverageApiModel;
import io.jenkins.plugins.coverage.metrics.source.SourceCodeFacade;
import io.jenkins.plugins.coverage.metrics.source.SourceViewModel;
import io.jenkins.plugins.coverage.metrics.steps.CoverageTableModel;
import io.jenkins.plugins.coverage.metrics.steps.IndirectCoverageChangesTable;
import io.jenkins.plugins.coverage.metrics.steps.Messages;
import io.jenkins.plugins.coverage.metrics.steps.ModifiedLinesCoverageTableModel;
import io.jenkins.plugins.coverage.metrics.steps.TrendChartFactory;
import io.jenkins.plugins.datatables.DefaultAsyncTableContentProvider;
import io.jenkins.plugins.datatables.TableModel;
import io.jenkins.plugins.util.BuildResultNavigator;
import io.jenkins.plugins.util.QualityGateResult;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class CoverageViewModel
extends DefaultAsyncTableContentProvider
implements ModelObject {
    private static final TreeMapNodeConverter TREE_MAP_NODE_CONVERTER = new TreeMapNodeConverter();
    private static final BuildResultNavigator NAVIGATOR = new BuildResultNavigator();
    private static final SourceCodeFacade SOURCE_CODE_FACADE = new SourceCodeFacade();
    static final String ABSOLUTE_COVERAGE_TABLE_ID = "absolute-coverage-table";
    static final String MODIFIED_LINES_COVERAGE_TABLE_ID = "modified-lines-coverage-table";
    static final String INDIRECT_COVERAGE_TABLE_ID = "indirect-coverage-table";
    private static final String INLINE_SUFFIX = "-inline";
    private static final String INFO_MESSAGES_VIEW_URL = "info";
    private static final String MODIFIED_LINES_API_URL = "modified";
    private static final ElementFormatter FORMATTER = new ElementFormatter();
    private static final Set<Metric> TREE_METRICS = Set.of(Metric.LINE, Metric.BRANCH, Metric.MUTATION, Metric.TEST_STRENGTH, Metric.CYCLOMATIC_COMPLEXITY, Metric.TESTS, Metric.MCDC_PAIR, Metric.FUNCTION_CALL, Metric.COGNITIVE_COMPLEXITY, Metric.NCSS, Metric.NPATH_COMPLEXITY);
    private final Run<?, ?> owner;
    private final String displayName;
    private final CoverageStatistics statistics;
    private final QualityGateResult qualityGateResult;
    private final String referenceBuild;
    private final FilteredLog log;
    private final Node node;
    private final String id;
    private final Node modifiedLinesCoverageTreeRoot;
    private final Node indirectCoverageChangesTreeRoot;
    private final Function<String, String> trendChartFunction;
    private final Function<String, String> metricsTrendFunction;
    private ColorProvider colorProvider = ColorProviderFactory.createDefaultColorProvider();

    CoverageViewModel(Run<?, ?> owner, String id, String displayName, Node node, CoverageStatistics statistics, QualityGateResult qualityGateResult, String referenceBuild, FilteredLog log, Function<String, String> trendChartFunction, Function<String, String> metricsTrendFunction) {
        this.owner = owner;
        this.id = id;
        this.displayName = displayName;
        this.node = node;
        this.statistics = statistics;
        this.qualityGateResult = qualityGateResult;
        this.referenceBuild = referenceBuild;
        this.log = log;
        this.modifiedLinesCoverageTreeRoot = node.filterByModifiedLines();
        this.indirectCoverageChangesTreeRoot = node.filterByIndirectChanges();
        this.trendChartFunction = trendChartFunction;
        this.metricsTrendFunction = metricsTrendFunction;
    }

    @VisibleForTesting
    FilteredLog getLog() {
        return this.log;
    }

    public String getId() {
        return this.id;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public Node getNode() {
        return this.node;
    }

    public ElementFormatter getFormatter() {
        return FORMATTER;
    }

    public NavigableSet<Metric> getTreeMetrics() {
        NavigableSet valueMetrics = this.node.getValueMetrics();
        valueMetrics.retainAll(TREE_METRICS);
        return valueMetrics;
    }

    public List<Metric> getCoverageMetrics() {
        return this.node.aggregateValues().stream().map(Value::getMetric).filter(Metric::isCoverage).filter(m -> !TrendChartFactory.IGNORED_TREND_METRICS.contains(m)).toList();
    }

    public List<Metric> getSoftwareMetrics() {
        return this.node.aggregateValues().stream().map(Value::getMetric).filter(Predicate.not(Metric::isCoverage)).filter(m -> !TrendChartFactory.IGNORED_TREND_METRICS.contains(m)).toList();
    }

    public String getDisplayName() {
        if (StringUtils.isBlank((CharSequence)this.displayName)) {
            return Messages.Coverage_Link_Name();
        }
        return this.displayName;
    }

    public Api getApi() {
        return new Api((Object)new CoverageApi(this.statistics, this.qualityGateResult, this.referenceBuild));
    }

    @JavaScriptMethod
    public Set<String> getJenkinsColorIDs() {
        return CoverageColorJenkinsId.getAll();
    }

    @JavaScriptMethod
    public void setJenkinsColors(String colors) {
        this.colorProvider = this.createColorProvider(colors);
    }

    private ColorProvider createColorProvider(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map colorMapping = (Map)mapper.readValue(json, (TypeReference)new ColorMappingType());
            return ColorProviderFactory.createColorProvider(colorMapping);
        }
        catch (JsonProcessingException e) {
            return ColorProviderFactory.createDefaultColorProvider();
        }
    }

    @JavaScriptMethod
    public CoverageOverview getOverview() {
        return new CoverageOverview(this.node);
    }

    @JavaScriptMethod
    public String getTrendChart(String configuration) {
        return this.trendChartFunction.apply(configuration);
    }

    @JavaScriptMethod
    public String getMetricsTrendChart(String configuration) {
        return this.metricsTrendFunction.apply(configuration);
    }

    public boolean hasCoverage() {
        return this.node.aggregateValues().stream().map(Value::getMetric).anyMatch(Metric::isCoverage);
    }

    public boolean hasMetrics() {
        long metricValues = this.getNode().getValueMetrics().stream().filter(Predicate.not(Metric::isCoverage)).count();
        return metricValues > 1L;
    }

    @JavaScriptMethod
    public LabeledTreeMapNode getCoverageTree(String coverageMetric) {
        Metric metric = this.getCoverageMetricFromText(coverageMetric);
        return TREE_MAP_NODE_CONVERTER.toTreeChartModel(this.getNode(), metric, this.colorProvider);
    }

    private Metric getCoverageMetricFromText(String text) {
        for (Metric metric : Metric.values()) {
            if (!text.contains(metric.toTagName())) continue;
            return metric;
        }
        throw new IllegalArgumentException("Unknown coverage metric: " + text);
    }

    public TableModel getTableModel(String tableId) {
        String actualId;
        CoverageTableModel.RowRenderer renderer = this.createRenderer(tableId);
        return switch (actualId = tableId.replace(INLINE_SUFFIX, "")) {
            case ABSOLUTE_COVERAGE_TABLE_ID -> new CoverageTableModel(tableId, this.getNode(), renderer, this.colorProvider);
            case MODIFIED_LINES_COVERAGE_TABLE_ID -> new ModifiedLinesCoverageTableModel(tableId, this.getNode(), this.modifiedLinesCoverageTreeRoot, renderer, this.colorProvider);
            case INDIRECT_COVERAGE_TABLE_ID -> new IndirectCoverageChangesTable(tableId, this.getNode(), this.indirectCoverageChangesTreeRoot, renderer, this.colorProvider);
            default -> throw new NoSuchElementException("No such table with id " + actualId);
        };
    }

    private CoverageTableModel.RowRenderer createRenderer(String tableId) {
        CoverageTableModel.RowRenderer renderer = tableId.endsWith(INLINE_SUFFIX) && this.hasSourceCode() ? new CoverageTableModel.InlineRowRenderer() : new CoverageTableModel.LinkedRowRenderer(this.getOwner().getRootDir(), this.getId());
        return renderer;
    }

    @JavaScriptMethod
    public String getUrlForBuild(String selectedBuildDisplayName, String currentUrl) {
        return NAVIGATOR.getSameUrlForOtherBuild(this.owner, currentUrl, this.id, selectedBuildDisplayName).orElse("");
    }

    @JavaScriptMethod
    public String getSourceCode(String fileHash, String tableId) {
        Optional targetResult = this.getNode().findByHashCode(Metric.FILE, Integer.parseInt(fileHash));
        if (targetResult.isPresent()) {
            try {
                Node fileNode = (Node)targetResult.get();
                return this.readSourceCode((FileNode)fileNode, tableId);
            }
            catch (IOException | InterruptedException exception) {
                return ExceptionUtils.getStackTrace((Throwable)exception);
            }
        }
        return Messages.Coverage_Not_Available();
    }

    private String readSourceCode(FileNode sourceNode, String tableId) throws IOException, InterruptedException {
        String content = "";
        File rootDir = this.getOwner().getRootDir();
        if (this.isSourceFileAvailable(sourceNode)) {
            content = SOURCE_CODE_FACADE.read(rootDir, this.getId(), sourceNode.getRelativePath());
        }
        if (!content.isEmpty()) {
            String cleanTableId = Strings.CS.removeEnd(tableId, (CharSequence)INLINE_SUFFIX);
            if (MODIFIED_LINES_COVERAGE_TABLE_ID.equals(cleanTableId)) {
                return SOURCE_CODE_FACADE.calculateModifiedLinesCoverageSourceCode(content, sourceNode);
            }
            if (INDIRECT_COVERAGE_TABLE_ID.equals(cleanTableId)) {
                return SOURCE_CODE_FACADE.calculateIndirectCoverageChangesSourceCode(content, sourceNode);
            }
            return content;
        }
        return Messages.Coverage_Not_Available();
    }

    @JavaScriptMethod
    public boolean hasSourceCode() {
        return SOURCE_CODE_FACADE.hasStoredSourceCode(this.getOwner().getRootDir(), this.id);
    }

    public boolean hasModifiedLinesCoverage() {
        return !this.modifiedLinesCoverageTreeRoot.isEmpty();
    }

    public boolean hasIndirectCoverageChanges() {
        return !this.indirectCoverageChangesTreeRoot.isEmpty();
    }

    public boolean isSourceFileAvailable(FileNode coverageNode) {
        return SOURCE_CODE_FACADE.canRead(this.getOwner().getRootDir(), this.id, coverageNode.getRelativePath());
    }

    @CheckForNull
    public Object getDynamic(String link, StaplerRequest2 request, StaplerResponse2 response) {
        if (MODIFIED_LINES_API_URL.equals(link)) {
            return new ModifiedLinesCoverageApiModel(this.node);
        }
        if (INFO_MESSAGES_VIEW_URL.equals(link)) {
            return new MessagesViewModel(this.getOwner(), Messages.MessagesViewModel_Title(), this.log.getInfoMessages(), this.log.getErrorMessages());
        }
        if (StringUtils.isNotEmpty((CharSequence)link)) {
            try {
                Optional targetResult = this.getNode().findByHashCode(Metric.FILE, Integer.parseInt(link));
                if (targetResult.isPresent() && targetResult.get() instanceof FileNode) {
                    return new SourceViewModel(this.getOwner(), this.getId(), (FileNode)targetResult.get());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final class ColorMappingType
    extends TypeReference<HashMap<String, String>> {
        private ColorMappingType() {
        }
    }

    public static class CoverageOverview {
        private final Node coverage;
        private static final ElementFormatter ELEMENT_FORMATTER = new ElementFormatter();

        CoverageOverview(Node coverage) {
            this.coverage = coverage;
        }

        public List<String> getMetrics() {
            return this.sortCoverages().map(Value::getMetric).map(ELEMENT_FORMATTER::getLabel).collect(Collectors.toList());
        }

        private Stream<Coverage> sortCoverages() {
            return this.getSortedCoverageValues().filter(c -> c.getTotal() > 1);
        }

        private Stream<Coverage> getSortedCoverageValues() {
            return Metric.getCoverageMetrics().stream().map(m -> m.getValueFor(this.coverage)).flatMap(Optional::stream).filter(value -> value instanceof Coverage).map(Coverage.class::cast);
        }

        public List<Integer> getCovered() {
            return this.getCoverageCounter(Coverage::getCovered);
        }

        public List<Integer> getMissed() {
            return this.getCoverageCounter(Coverage::getMissed);
        }

        private List<Integer> getCoverageCounter(Function<Coverage, Integer> property) {
            return this.sortCoverages().map(property).collect(Collectors.toList());
        }

        public List<Double> getCoveredPercentages() {
            return this.getPercentages(Coverage::getCoveredPercentage);
        }

        public List<Double> getMissedPercentages() {
            return this.getPercentages(c -> Percentage.valueOf((int)c.getMissed(), (int)c.getTotal()));
        }

        private List<Double> getPercentages(Function<Coverage, Percentage> displayType) {
            return this.sortCoverages().map(displayType).map(Percentage::toDouble).collect(Collectors.toList());
        }
    }
}

