/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.color;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.coverage.metrics.color.ColorId;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;

public enum CoverageChangeLevel {
    INCREASE_5(5.0, ColorId.EXCELLENT),
    INCREASE_2(2.0, ColorId.VERY_GOOD),
    EQUALS(0.0, ColorId.AVERAGE),
    DECREASE_2(-2.0, ColorId.INADEQUATE),
    DECREASE_5(-5.0, ColorId.BAD),
    DECREASE_10(-10.0, ColorId.VERY_BAD),
    DECREASE_20(-20.0, ColorId.INSUFFICIENT),
    NA(-100.0, ColorId.WHITE);

    private final double change;
    private final ColorId colorizationId;

    private CoverageChangeLevel(double change, ColorId colorizationId) {
        this.change = change;
        this.colorizationId = colorizationId;
    }

    public static ColorProvider.DisplayColors getDisplayColorsOfCoverageChange(double coverageDifference, @NonNull ColorProvider colorProvider) {
        for (int i = 0; i < CoverageChangeLevel.values().length - 1; ++i) {
            CoverageChangeLevel level = CoverageChangeLevel.values()[i];
            if (!(coverageDifference >= level.change)) continue;
            if (i == 0) {
                return colorProvider.getDisplayColorsOf(level.colorizationId);
            }
            double distanceLevel = coverageDifference - level.change;
            if (distanceLevel == 0.0) {
                return colorProvider.getDisplayColorsOf(level.colorizationId);
            }
            CoverageChangeLevel upperLevel = CoverageChangeLevel.values()[i - 1];
            double distanceUpper = upperLevel.change - coverageDifference;
            return colorProvider.getBlendedDisplayColors(distanceLevel, distanceUpper, upperLevel.colorizationId, level.colorizationId);
        }
        return colorProvider.getDisplayColorsOf(CoverageChangeLevel.NA.colorizationId);
    }

    public double getChange() {
        return this.change;
    }

    public ColorId getColorizationId() {
        return this.colorizationId;
    }
}

