/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.MethodNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.hm.hafner.util.TreeString;
import java.io.Reader;
import java.nio.file.Path;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class MetricsParser
extends CoverageParser {
    private static final long serialVersionUID = -4461747681863455621L;
    private static final QName METRICS = new QName("metrics");
    private static final QName PACKAGE = new QName("package");
    private static final QName CLASS = new QName("class");
    private static final QName METHOD = new QName("method");
    private static final QName METRIC = new QName("metric");
    private static final QName FILE = new QName("file");
    private static final QName PROJECT_NAME = new QName("projectName");
    private static final QName NAME = new QName("name");
    private static final QName BEGIN_LINE = new QName("beginline");
    private static final QName VALUE = new QName("value");
    private static final PathUtil PATH_UTIL = new PathUtil();

    public MetricsParser() {
        this(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public MetricsParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        try {
            SecureXmlParserFactory factory = new SecureXmlParserFactory();
            XMLEventReader eventReader = factory.createXmlEventReader(reader);
            ModuleNode root = new ModuleNode("");
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement()) continue;
                StartElement startElement = event.asStartElement();
                QName tagName = startElement.getName();
                if (METRICS.equals(tagName)) {
                    root = new ModuleNode(MetricsParser.getOptionalValueOf(startElement, PROJECT_NAME).orElse(""));
                    continue;
                }
                if (!PACKAGE.equals(tagName)) continue;
                this.readPackage(eventReader, root, startElement, fileName);
            }
            if (root.hasChildren()) {
                return root;
            }
            this.handleEmptyResults(fileName, log);
            return new ModuleNode("empty");
        }
        catch (XMLStreamException exception) {
            throw new CoverageParser.ParsingException(exception);
        }
    }

    @CanIgnoreReturnValue
    private PackageNode readPackage(XMLEventReader reader, ModuleNode root, StartElement startElement, String fileName) throws XMLStreamException {
        String packageName = MetricsParser.getValueOf(startElement, NAME);
        PackageNode packageNode = root.findOrCreatePackageNode(packageName);
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (FILE.equals(nextElement.getName())) {
                    this.readSourceFile(reader, packageNode, nextElement, fileName);
                    continue;
                }
                if (!METRIC.equals(nextElement.getName())) continue;
                this.readValueCounter(packageNode, nextElement);
                continue;
            }
            if (!event.isEndElement() || !PACKAGE.equals((endElement = event.asEndElement()).getName())) continue;
            return packageNode;
        }
        throw MetricsParser.createEofException(fileName);
    }

    @CanIgnoreReturnValue
    private Node readClass(XMLEventReader reader, FileNode fileNode, StartElement startElement, String fileName, PackageNode packageNode) throws XMLStreamException {
        ClassNode classNode = fileNode.findOrCreateClassNode(packageNode.getName() + "." + MetricsParser.getValueOf(startElement, NAME));
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (METHOD.equals(nextElement.getName())) {
                    this.readMethod(reader, classNode, nextElement, fileName);
                    continue;
                }
                if (!METRIC.equals(nextElement.getName())) continue;
                this.readValueCounter(classNode, nextElement);
                continue;
            }
            if (!event.isEndElement() || !CLASS.equals((endElement = event.asEndElement()).getName())) continue;
            return classNode;
        }
        throw MetricsParser.createEofException(fileName);
    }

    private TreeString internPath(String filePath) {
        return this.getTreeStringBuilder().intern(PATH_UTIL.getRelativePath(Path.of(filePath, new String[0])));
    }

    @CanIgnoreReturnValue
    private Node readSourceFile(XMLEventReader reader, PackageNode packageNode, StartElement startElement, String fileName) throws XMLStreamException {
        String sourceFileName = this.getSourceFileName(startElement);
        FileNode fileNode = packageNode.findOrCreateFileNode(sourceFileName, this.internPath(MetricsParser.getValueOf(startElement, NAME)));
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (CLASS.equals(nextElement.getName())) {
                    this.readClass(reader, fileNode, nextElement, fileName, packageNode);
                    continue;
                }
                if (!METRIC.equals(nextElement.getName())) continue;
                this.readValueCounter(fileNode, nextElement);
                continue;
            }
            if (!event.isEndElement() || !FILE.equals((endElement = event.asEndElement()).getName())) continue;
            return fileNode;
        }
        throw MetricsParser.createEofException(fileName);
    }

    private String getSourceFileName(StartElement startSourceFileElement) {
        Path sourceFilePath = Path.of(MetricsParser.getValueOf(startSourceFileElement, NAME), new String[0]).getFileName();
        if (sourceFilePath == null) {
            return MetricsParser.getValueOf(startSourceFileElement, NAME);
        }
        return sourceFilePath.toString();
    }

    @CanIgnoreReturnValue
    private Node readMethod(XMLEventReader reader, ClassNode classNode, StartElement startElement, String fileName) throws XMLStreamException {
        String methodName = MetricsParser.getValueOf(startElement, NAME) + "#" + MetricsParser.getValueOf(startElement, BEGIN_LINE);
        MethodNode methodNode = this.createMethod(startElement, methodName);
        classNode.addChild(methodNode);
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (!METRIC.equals(nextElement.getName())) continue;
                this.readValueCounter(methodNode, nextElement);
                continue;
            }
            if (!event.isEndElement() || !METHOD.equals((endElement = event.asEndElement()).getName())) continue;
            return methodNode;
        }
        throw MetricsParser.createEofException(fileName);
    }

    private MethodNode createMethod(StartElement startElement, String methodName) {
        return new MethodNode(methodName, "", MetricsParser.parseInteger(MetricsParser.getValueOf(startElement, BEGIN_LINE)));
    }

    private void readValueCounter(Node node, StartElement startElement) {
        String currentType = MetricsParser.getValueOf(startElement, NAME);
        Metric metric = Metric.fromName(currentType);
        Value value = metric.parseValue(MetricsParser.getValueOf(startElement, VALUE));
        node.addValue(value);
    }
}

