/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.restapi;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Value;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.util.QualityGateResult;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class CoverageApi {
    private static final ElementFormatter FORMATTER = new ElementFormatter();
    private final CoverageStatistics statistics;
    private final QualityGateResult qualityGateResult;
    private final String referenceBuild;

    public CoverageApi(CoverageStatistics statistics, QualityGateResult qualityGateResult, String referenceBuild) {
        this.statistics = statistics;
        this.qualityGateResult = qualityGateResult;
        this.referenceBuild = referenceBuild;
    }

    @Exported(inline=true)
    public QualityGateResult.QualityGateResultApi getQualityGates() {
        return new QualityGateResult.QualityGateResultApi(this.qualityGateResult);
    }

    @Exported
    public String getReferenceBuild() {
        return this.referenceBuild;
    }

    @Exported(inline=true)
    public NavigableMap<String, String> getProjectStatistics() {
        return this.mapToStrings(Baseline.PROJECT);
    }

    @Exported(inline=true)
    public NavigableMap<String, String> getProjectDelta() {
        return this.mapToStrings(Baseline.PROJECT_DELTA);
    }

    @Exported(inline=true)
    public NavigableMap<String, String> getModifiedFilesStatistics() {
        return this.mapToStrings(Baseline.MODIFIED_FILES);
    }

    @Exported(inline=true)
    public NavigableMap<String, String> getModifiedFilesDelta() {
        return this.mapToStrings(Baseline.MODIFIED_FILES_DELTA);
    }

    @Exported(inline=true)
    public NavigableMap<String, String> getModifiedLinesStatistics() {
        return this.mapToStrings(Baseline.MODIFIED_LINES);
    }

    @Exported(inline=true)
    public NavigableMap<String, String> getModifiedLinesDelta() {
        return this.mapToStrings(Baseline.MODIFIED_LINES_DELTA);
    }

    private NavigableMap<String, String> mapToStrings(Baseline baseline) {
        TreeMap<String, String> values = new TreeMap<String, String>();
        for (Metric metric : Metric.values()) {
            this.statistics.getValue(baseline, metric).ifPresent(value -> values.put(metric.toTagName(), this.format(baseline, (Value)value)));
        }
        return values;
    }

    private String format(Baseline baseline, Value value) {
        return baseline.isDelta() ? this.formatDelta(value) : this.formatValue(value);
    }

    private String formatValue(Value value) {
        return FORMATTER.format(value, Locale.ENGLISH);
    }

    private String formatDelta(Value value) {
        return FORMATTER.formatDelta(value, Locale.ENGLISH);
    }
}

