/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.model;

import io.jenkins.plugins.coverage.metrics.color.ColorProvider;
import io.jenkins.plugins.coverage.metrics.color.CoverageChangeTendency;
import io.jenkins.plugins.coverage.metrics.color.CoverageLevel;
import io.jenkins.plugins.coverage.metrics.model.Messages;
import java.util.function.BiFunction;
import org.jvnet.localizer.Localizable;

public enum Baseline {
    PROJECT(Messages._Baseline_PROJECT(), "overview", CoverageLevel::getDisplayColorsOfCoverageLevel, false),
    PROJECT_DELTA(Messages._Baseline_PROJECT_DELTA(), "overview", CoverageChangeTendency::getDisplayColorsForTendency, true),
    MODIFIED_LINES(Messages._Baseline_MODIFIED_LINES(), "modifiedLinesCoverage", CoverageLevel::getDisplayColorsOfCoverageLevel, false),
    MODIFIED_LINES_DELTA(Messages._Baseline_MODIFIED_LINES_DELTA(), "modifiedLinesCoverage", CoverageChangeTendency::getDisplayColorsForTendency, true),
    MODIFIED_FILES(Messages._Baseline_MODIFIED_FILES(), "modifiedFilesCoverage", CoverageLevel::getDisplayColorsOfCoverageLevel, false),
    MODIFIED_FILES_DELTA(Messages._Baseline_MODIFIED_FILES_DELTA(), "modifiedFilesCoverage", CoverageChangeTendency::getDisplayColorsForTendency, true),
    INDIRECT(Messages._Baseline_INDIRECT(), "indirectCoverage", CoverageLevel::getDisplayColorsOfCoverageLevel, false);

    private final Localizable title;
    private final String url;
    private final BiFunction<Double, ColorProvider, ColorProvider.DisplayColors> colorMapper;
    private final boolean delta;

    private Baseline(Localizable title, String url, BiFunction<Double, ColorProvider, ColorProvider.DisplayColors> colorMapper, boolean delta) {
        this.title = title;
        this.url = url;
        this.colorMapper = colorMapper;
        this.delta = delta;
    }

    public String getTitle() {
        return this.title.toString();
    }

    public String getUrl() {
        return "#" + this.url;
    }

    public ColorProvider.DisplayColors getDisplayColors(double value, ColorProvider colorProvider) {
        return this.colorMapper.apply(value, colorProvider);
    }

    public boolean isDelta() {
        return this.delta;
    }
}

