/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.color;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.coverage.metrics.color.ColorId;
import java.awt.Color;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;

public class ColorProvider {
    public static final DisplayColors DEFAULT_COLOR = new DisplayColors(Color.black, Color.white);
    static final String BLEND_COLOR_ERROR_MESSAGE = "Color weights have to be greater or equal to zero";
    private final Map<ColorId, DisplayColors> availableColors;

    ColorProvider(Map<ColorId, DisplayColors> colorMapping) {
        this.availableColors = colorMapping.isEmpty() ? new EnumMap<ColorId, DisplayColors>(ColorId.class) : new EnumMap<ColorId, DisplayColors>(colorMapping);
    }

    public static Color blendColors(Color color1, Color color2) {
        return ColorProvider.blendWeightedColors(color1, color2, 1.0, 1.0);
    }

    public static Color blendWeightedColors(@NonNull Color color1, @NonNull Color color2, double weight1, double weight2) {
        if (weight1 >= 0.0 && weight2 >= 0.0) {
            double total = weight1 + weight2;
            int r = (int)(((double)color1.getRed() * weight1 + (double)color2.getRed() * weight2) / total);
            int g = (int)(((double)color1.getGreen() * weight1 + (double)color2.getGreen() * weight2) / total);
            int b = (int)(((double)color1.getBlue() * weight1 + (double)color2.getBlue() * weight2) / total);
            int a = (int)(((double)color1.getAlpha() * weight1 + (double)color2.getAlpha() * weight2) / total);
            return new Color(r, g, b, a);
        }
        throw new IllegalArgumentException(BLEND_COLOR_ERROR_MESSAGE);
    }

    public static String colorAsRGBAHex(Color color, int alpha) {
        return "#%02X%02X%02X%02X".formatted(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static String colorAsRGBHex(Color color) {
        return "#%02X%02X%02X".formatted(color.getRed(), color.getGreen(), color.getBlue());
    }

    public DisplayColors getDisplayColorsOf(ColorId colorId) {
        if (this.containsColorId(colorId)) {
            return this.availableColors.get((Object)colorId);
        }
        return DEFAULT_COLOR;
    }

    public boolean containsColorId(ColorId colorId) {
        return this.availableColors.containsKey((Object)colorId);
    }

    public DisplayColors getBlendedDisplayColors(double weightFirst, double weightSecond, ColorId first, ColorId second) {
        if (this.containsColorId(first) && this.containsColorId(second)) {
            DisplayColors firstColor = this.getDisplayColorsOf(first);
            DisplayColors secondColor = this.getDisplayColorsOf(second);
            Color lineColor = weightFirst > weightSecond ? firstColor.lineColor : secondColor.lineColor;
            Color fillColor = ColorProvider.blendWeightedColors(firstColor.fillColor, secondColor.fillColor, weightFirst, weightSecond);
            return new DisplayColors(lineColor, fillColor);
        }
        return DEFAULT_COLOR;
    }

    public static class DisplayColors {
        private final Color lineColor;
        private final Color fillColor;

        public DisplayColors(Color lineColor, Color fillColor) {
            this.lineColor = lineColor;
            this.fillColor = fillColor;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        public Color getFillColor() {
            return this.fillColor;
        }

        public String getFillColorAsRGBAHex(int alpha) {
            return ColorProvider.colorAsRGBAHex(this.fillColor, alpha);
        }

        public String getLineColorAsRGBHex() {
            return ColorProvider.colorAsRGBHex(this.lineColor);
        }

        public String getFillColorAsRGBHex() {
            return ColorProvider.colorAsRGBHex(this.fillColor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DisplayColors that = (DisplayColors)o;
            return Objects.equals(this.lineColor, that.lineColor) && Objects.equals(this.fillColor, that.fillColor);
        }

        public int hashCode() {
            return Objects.hash(this.lineColor, this.fillColor);
        }

        public String toString() {
            return "%s - %s".formatted(this.lineColor, this.fillColor);
        }
    }
}

