/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.source;

import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Run;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.coverage.metrics.source.CoverageSourcePrinter;
import io.jenkins.plugins.coverage.metrics.source.MutationSourcePrinter;
import io.jenkins.plugins.coverage.metrics.source.SourceCodeFacade;
import io.jenkins.plugins.coverage.metrics.source.VectorCastSourcePrinter;
import io.jenkins.plugins.prism.SourceCodeRetention;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;

public class SourceCodePainter {
    private final Run<?, ?> build;
    private final FilePath workspace;
    private final String id;

    public SourceCodePainter(@NonNull Run<?, ?> build, @NonNull FilePath workspace, String id) {
        this.build = build;
        this.workspace = workspace;
        this.id = id;
    }

    public void processSourceCodePainting(Node rootNode, List<FileNode> files, String sourceCodeEncoding, SourceCodeRetention sourceCodeRetention, FilteredLog log) throws InterruptedException {
        SourceCodeFacade sourceCodeFacade = new SourceCodeFacade();
        if (sourceCodeRetention != SourceCodeRetention.NEVER) {
            List paintedFiles = files.stream().map(f -> this.createFileModel(rootNode, (FileNode)f)).collect(Collectors.toList());
            log.logInfo("Painting %d source files on agent", new Object[]{paintedFiles.size()});
            this.paintFilesOnAgent(paintedFiles, sourceCodeEncoding, log);
            log.logInfo("Copying painted sources from agent to build folder");
            sourceCodeFacade.copySourcesToBuildFolder(this.build, this.workspace, log);
        }
        sourceCodeRetention.cleanup(this.build, sourceCodeFacade.getCoverageSourcesDirectory(), log);
    }

    private CoverageSourcePrinter createFileModel(Node rootNode, FileNode fileNode) {
        if (rootNode.getValue(Metric.MUTATION).isPresent()) {
            return new MutationSourcePrinter(fileNode);
        }
        if (rootNode.getValue(Metric.MCDC_PAIR).isPresent() || rootNode.getValue(Metric.FUNCTION_CALL).isPresent()) {
            return new VectorCastSourcePrinter(fileNode);
        }
        return new CoverageSourcePrinter(fileNode);
    }

    private void paintFilesOnAgent(List<? extends CoverageSourcePrinter> paintedFiles, String sourceCodeEncoding, FilteredLog log) throws InterruptedException {
        try {
            AgentCoveragePainter painter = new AgentCoveragePainter(paintedFiles, sourceCodeEncoding, this.id);
            FilteredLog agentLog = (FilteredLog)this.workspace.act((FilePath.FileCallable)painter);
            log.merge(agentLog);
        }
        catch (IOException exception) {
            log.logException((Exception)exception, "Can't paint and zip sources on the agent", new Object[0]);
        }
    }

    static class AgentCoveragePainter
    extends MasterToSlaveFileCallable<FilteredLog> {
        private static final long serialVersionUID = 3966282357309568323L;
        private final List<? extends CoverageSourcePrinter> paintedFiles;
        private final String sourceCodeEncoding;
        private final String directory;

        AgentCoveragePainter(List<? extends CoverageSourcePrinter> files, String sourceCodeEncoding, String directory) {
            this.paintedFiles = files;
            this.sourceCodeEncoding = sourceCodeEncoding;
            this.directory = directory;
        }

        public FilteredLog invoke(File workspaceFile, VirtualChannel channel) {
            FilteredLog log = new FilteredLog("Errors during source code painting:");
            FilePath workspace = new FilePath(workspaceFile);
            try {
                FilePath outputFolder = workspace.child(this.directory);
                outputFolder.mkdirs();
                Path temporaryFolder = Files.createTempDirectory(this.directory, new FileAttribute[0]);
                int count = this.paintedFiles.parallelStream().mapToInt(file -> this.paintSource((CoverageSourcePrinter)file, workspace, temporaryFolder, log)).sum();
                if (count == this.paintedFiles.size()) {
                    log.logInfo("-> finished painting successfully");
                } else {
                    log.logInfo("-> finished painting (%d files have been painted, %d files failed)", new Object[]{count, this.paintedFiles.size() - count});
                }
                FilePath zipFile = workspace.child("coverage-sources.zip");
                outputFolder.zip(zipFile);
                log.logInfo("-> zipping sources from folder '%s' as '%s'", new Object[]{outputFolder, zipFile});
                this.deleteFolder(temporaryFolder.toFile(), log);
            }
            catch (IOException exception) {
                log.logException((Exception)exception, "Cannot create temporary directory in folder '%s' for the painted source files", new Object[]{workspace});
            }
            catch (InterruptedException exception) {
                log.logException((Exception)exception, "Processing has been interrupted: skipping zipping of source files", new Object[]{workspace});
            }
            return log;
        }

        private Charset getCharset() {
            return new ValidationUtilities().getCharset(this.sourceCodeEncoding);
        }

        private int paintSource(CoverageSourcePrinter fileNode, FilePath workspace, Path temporaryFolder, FilteredLog log) {
            String relativePathIdentifier = fileNode.getPath();
            FilePath paintedFilesDirectory = workspace.child(this.directory);
            return this.findSourceFile(workspace, relativePathIdentifier, log).map(resolvedPath -> this.paint(fileNode, relativePathIdentifier, (FilePath)resolvedPath, paintedFilesDirectory, temporaryFolder, this.getCharset(), log)).orElse(0);
        }

        private int paint(CoverageSourcePrinter paint, String relativePathIdentifier, FilePath resolvedPath, FilePath paintedFilesDirectory, Path temporaryFolder, Charset charset, FilteredLog log) {
            String sanitizedFileName = SourceCodeFacade.sanitizeFilename(relativePathIdentifier);
            FilePath zipOutputPath = paintedFilesDirectory.child(sanitizedFileName + ".zip");
            try {
                Path paintedFilesFolder = Files.createTempDirectory(temporaryFolder, this.directory, new FileAttribute[0]);
                Path fullSourcePath = paintedFilesFolder.resolve(sanitizedFileName);
                try (BufferedWriter output = Files.newBufferedWriter(fullSourcePath, new OpenOption[0]);){
                    List<String> lines = Files.readAllLines(Path.of(resolvedPath.getRemote(), new String[0]), charset);
                    output.write(paint.getColumnHeader());
                    for (int line = 0; line < lines.size(); ++line) {
                        output.write(paint.renderLine(line + 1, lines.get(line)));
                    }
                }
                new FilePath(fullSourcePath.toFile()).zip(zipOutputPath);
                FileUtils.deleteDirectory((File)paintedFilesFolder.toFile());
                return 1;
            }
            catch (IOException | InterruptedException exception) {
                log.logException(exception, "Can't write coverage paint of '%s' to zipped source file '%s'", new Object[]{relativePathIdentifier, zipOutputPath});
                return 0;
            }
        }

        private Optional<FilePath> findSourceFile(FilePath workspace, String fileName, FilteredLog log) {
            try {
                FilePath absolutePath = new FilePath(new File(fileName));
                if (absolutePath.exists()) {
                    return Optional.of(absolutePath);
                }
                FilePath relativePath = workspace.child(fileName);
                if (relativePath.exists()) {
                    return Optional.of(relativePath);
                }
            }
            catch (IOException | InterruptedException | InvalidPathException exception) {
                log.logException(exception, "No valid path in coverage node: '%s'", new Object[]{fileName});
            }
            return Optional.empty();
        }

        private void deleteFolder(File folder, FilteredLog log) {
            if (folder.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)folder);
                }
                catch (IOException e) {
                    log.logError("The folder '%s' could not be deleted", new Object[]{folder.getAbsolutePath()});
                }
            }
        }
    }
}

