/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.MethodNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.SecureXmlParserFactory;
import edu.hm.hafner.util.TreeString;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.Strings;

public class JacocoParser
extends CoverageParser {
    private static final long serialVersionUID = -6021749565311262221L;
    private static final QName REPORT = new QName("report");
    private static final QName PACKAGE = new QName("package");
    private static final QName GROUP = new QName("group");
    private static final QName CLASS = new QName("class");
    private static final QName METHOD = new QName("method");
    private static final QName COUNTER = new QName("counter");
    private static final QName SOURCE_FILE = new QName("sourcefile");
    private static final QName NAME = new QName("name");
    private static final QName SIGNATURE = new QName("desc");
    private static final QName TYPE = new QName("type");
    private static final QName MISSED = new QName("missed");
    private static final QName COVERED = new QName("covered");
    private static final QName LINE_NUMBER = new QName("nr");
    private static final QName SOURCE_FILE_NAME = new QName("sourcefilename");
    private static final QName LINE = new QName("line");
    private static final QName COVERED_INSTRUCTIONS = new QName("ci");
    private static final QName MISSED_BRANCHES = new QName("mb");
    private static final QName COVERED_BRANCHED = new QName("cb");
    private static final PathUtil PATH_UTIL = new PathUtil();
    private static final String VALUE_BRANCH = "BRANCH";
    private static final String VALUE_INSTRUCTION = "INSTRUCTION";
    private static final String VALUE_LINE = "LINE";

    public JacocoParser() {
        this(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public JacocoParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        try {
            SecureXmlParserFactory factory = new SecureXmlParserFactory();
            XMLEventReader eventReader = factory.createXmlEventReader(reader);
            while (eventReader.hasNext()) {
                StartElement startElement;
                QName tagName;
                XMLEvent event = eventReader.nextEvent();
                if (!event.isStartElement() || !REPORT.equals(tagName = (startElement = event.asStartElement()).getName())) continue;
                ModuleNode root = new ModuleNode(JacocoParser.getValueOf(startElement, NAME));
                this.readModule(eventReader, root, fileName);
                return root;
            }
            this.handleEmptyResults(fileName, log);
            return new ModuleNode("empty");
        }
        catch (XMLStreamException exception) {
            throw new CoverageParser.ParsingException(exception);
        }
    }

    @CanIgnoreReturnValue
    private ModuleNode readModule(XMLEventReader reader, ModuleNode module, String fileName) throws XMLStreamException {
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement startElement = event.asStartElement();
                if (PACKAGE.equals(startElement.getName())) {
                    this.readPackage(reader, module, startElement, fileName);
                    continue;
                }
                if (GROUP.equals(startElement.getName())) {
                    ModuleNode subModule = new ModuleNode(JacocoParser.getValueOf(startElement, NAME));
                    this.readModule(reader, subModule, fileName);
                    module.addChild(subModule);
                    continue;
                }
                if (!COUNTER.equals(startElement.getName())) continue;
                this.readValueCounter(module, startElement);
                continue;
            }
            if (!event.isEndElement() || !this.isModuleEnd(endElement = event.asEndElement())) continue;
            return module;
        }
        throw JacocoParser.createEofException(fileName);
    }

    private boolean isModuleEnd(EndElement endElement) {
        return REPORT.equals(endElement.getName()) || GROUP.equals(endElement.getName());
    }

    @CanIgnoreReturnValue
    private PackageNode readPackage(XMLEventReader reader, ModuleNode root, StartElement startElement, String fileName) throws XMLStreamException {
        String packageName = JacocoParser.getValueOf(startElement, NAME);
        PackageNode packageNode = root.findOrCreatePackageNode(packageName);
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (CLASS.equals(nextElement.getName())) {
                    this.readClass(reader, packageNode, packageName, nextElement, fileName);
                    continue;
                }
                if (SOURCE_FILE.equals(nextElement.getName())) {
                    this.readSourceFile(reader, packageNode, packageName, nextElement, fileName);
                    continue;
                }
                if (!COUNTER.equals(startElement.getName())) continue;
                this.readValueCounter(packageNode, startElement);
                continue;
            }
            if (!event.isEndElement() || !PACKAGE.equals((endElement = event.asEndElement()).getName())) continue;
            return packageNode;
        }
        throw JacocoParser.createEofException(fileName);
    }

    @CanIgnoreReturnValue
    private Node readClass(XMLEventReader reader, PackageNode packageNode, String packageName, StartElement startElement, String fileName) throws XMLStreamException {
        ClassNode classNode;
        Optional<String> possibleFileName = JacocoParser.getOptionalValueOf(startElement, SOURCE_FILE_NAME);
        if (possibleFileName.isPresent()) {
            String classFileName = possibleFileName.get();
            FileNode fileNode = packageNode.findOrCreateFileNode(classFileName, this.internPath(packageName, classFileName));
            classNode = fileNode.findOrCreateClassNode(JacocoParser.getValueOf(startElement, NAME));
        } else {
            classNode = packageNode.findOrCreateClassNode(JacocoParser.getValueOf(startElement, NAME));
        }
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (METHOD.equals(nextElement.getName())) {
                    this.readMethod(reader, classNode, nextElement, fileName);
                    continue;
                }
                if (!COUNTER.equals(nextElement.getName())) continue;
                this.readValueCounter(classNode, nextElement);
                continue;
            }
            if (!event.isEndElement() || !CLASS.equals((endElement = event.asEndElement()).getName())) continue;
            return classNode;
        }
        throw JacocoParser.createEofException(fileName);
    }

    private TreeString internPath(String packageName, String fileName) {
        return this.getTreeStringBuilder().intern(PATH_UTIL.getRelativePath(Path.of(packageName, fileName)));
    }

    @CanIgnoreReturnValue
    private Node readSourceFile(XMLEventReader reader, PackageNode packageNode, String packageName, StartElement startElement, String fileName) throws XMLStreamException {
        String sourceFilefileName = JacocoParser.getValueOf(startElement, NAME);
        FileNode fileNode = packageNode.findOrCreateFileNode(sourceFilefileName, this.internPath(packageName, sourceFilefileName));
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (LINE.equals(nextElement.getName())) {
                    this.readLine(fileNode, nextElement);
                    continue;
                }
                if (!COUNTER.equals(nextElement.getName())) continue;
                this.readValueCounter(fileNode, nextElement);
                continue;
            }
            if (!event.isEndElement() || !SOURCE_FILE.equals((endElement = event.asEndElement()).getName())) continue;
            return fileNode;
        }
        throw JacocoParser.createEofException(fileName);
    }

    private void readLine(FileNode fileNode, StartElement startElement) {
        int missed;
        int covered;
        int lineNumber = JacocoParser.getIntegerValueOf(startElement, LINE_NUMBER);
        int coveredInstructions = JacocoParser.getIntegerValueOf(startElement, COVERED_INSTRUCTIONS);
        int coveredBranches = JacocoParser.getIntegerValueOf(startElement, COVERED_BRANCHED);
        int missedBranches = JacocoParser.getIntegerValueOf(startElement, MISSED_BRANCHES);
        if (missedBranches + coveredBranches == 0) {
            covered = coveredInstructions > 0 ? 1 : 0;
            missed = covered > 0 ? 0 : 1;
        } else {
            covered = coveredBranches;
            missed = missedBranches;
        }
        fileNode.addCounters(lineNumber, covered, missed);
    }

    @CanIgnoreReturnValue
    private Node readMethod(XMLEventReader reader, ClassNode classNode, StartElement startElement, String fileName) throws XMLStreamException {
        String methodName = JacocoParser.getValueOf(startElement, NAME);
        String methodSignature = JacocoParser.getValueOf(startElement, SIGNATURE);
        MethodNode methodNode = this.createMethod(startElement, methodName, methodSignature);
        classNode.addChild(methodNode);
        while (reader.hasNext()) {
            EndElement endElement;
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement()) {
                StartElement nextElement = event.asStartElement();
                if (!COUNTER.equals(nextElement.getName())) continue;
                this.readValueCounter(methodNode, nextElement);
                continue;
            }
            if (!event.isEndElement() || !METHOD.equals((endElement = event.asEndElement()).getName())) continue;
            return methodNode;
        }
        throw JacocoParser.createEofException(fileName);
    }

    private MethodNode createMethod(StartElement startElement, String methodName, String methodSignature) {
        return JacocoParser.getOptionalValueOf(startElement, LINE).map(x$0 -> CoverageParser.parseInteger(x$0)).map(line -> new MethodNode(methodName, methodSignature, (int)line)).orElseGet(() -> new MethodNode(methodName, methodSignature));
    }

    private void readValueCounter(Node node, StartElement startElement) {
        String currentType = JacocoParser.getValueOf(startElement, TYPE);
        if (Strings.CS.containsAny((CharSequence)currentType, new CharSequence[]{VALUE_LINE, VALUE_INSTRUCTION, VALUE_BRANCH, "COMPLEXITY"})) {
            int covered = JacocoParser.getIntegerValueOf(startElement, COVERED);
            int missed = JacocoParser.getIntegerValueOf(startElement, MISSED);
            if (!node.isAggregation()) {
                node.addValue(this.createValue(currentType, covered, missed));
            }
        }
    }

    private Value createValue(String currentType, int covered, int missed) {
        if ("COMPLEXITY".equals(currentType)) {
            return new Value(Metric.CYCLOMATIC_COMPLEXITY, covered + missed);
        }
        Coverage.CoverageBuilder builder = new Coverage.CoverageBuilder();
        return builder.withMetric(Metric.valueOf(currentType)).withCovered(covered).withMissed(missed).build();
    }
}

