/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.registry.ParserRegistry;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.BuildableItem;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.AccessControlled;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.coverage.metrics.steps.Messages;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class CoverageTool
extends AbstractDescribableImpl<CoverageTool>
implements Serializable {
    private static final long serialVersionUID = -8612521458890553037L;
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    private JenkinsFacade jenkins = new JenkinsFacade();
    private String pattern = "";
    private Parser parser = Parser.JACOCO;

    @DataBoundConstructor
    public CoverageTool() {
    }

    CoverageTool(Parser parser, String pattern) {
        this.pattern = pattern;
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }

    @DataBoundSetter
    public void setParser(Parser parser) {
        this.parser = parser;
    }

    @VisibleForTesting
    void setJenkinsFacade(JenkinsFacade jenkinsFacade) {
        this.jenkins = jenkinsFacade;
    }

    protected Object readResolve() {
        this.jenkins = new JenkinsFacade();
        return this;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @CheckForNull
    public String getPattern() {
        return this.pattern;
    }

    public String getActualPattern() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.pattern, (CharSequence)this.parser.getDefaultPattern());
    }

    public String toString() {
        return "%s (pattern: %s)".formatted(new Object[]{this.getParser(), this.getActualPattern()});
    }

    public CoverageToolDescriptor getDescriptor() {
        return (CoverageToolDescriptor)this.jenkins.getDescriptorOrDie(this.getClass());
    }

    public String getDisplayName() {
        return this.getParser().getDisplayName();
    }

    public static enum Parser {
        COBERTURA(Messages._Parser_Cobertura(), ParserType.COVERAGE, "**/cobertura.xml", "symbol-footsteps-outline plugin-ionicons-api"),
        CLOVER(Messages._Parser_Clover(), ParserType.COVERAGE, "**/*clover*.xml,**/*Clover*.xml", "symbol-footsteps-outline plugin-ionicons-api"),
        GO_COV(Messages._Parser_GoCov(), ParserType.COVERAGE, "**/*coverage*.out,**/*coverage*.txt,**/cover.out", "symbol-footsteps-outline plugin-ionicons-api"),
        JACOCO(Messages._Parser_JaCoCo(), ParserType.COVERAGE, "**/jacoco.xml,**/jacocoTestReport.xml", "symbol-footsteps-outline plugin-ionicons-api"),
        JUNIT(Messages._Parser_Junit(), ParserType.TEST, "**/TEST-*.xml", "symbol-solid/list-check plugin-font-awesome-api"),
        METRICS(Messages._Parser_Metrics(), ParserType.METRICS, "**/metrics.xml", "symbol-solid/scale-balanced plugin-font-awesome-api"),
        NUNIT(Messages._Parser_Nunit(), ParserType.TEST, "**/nunit.xml,**/TestResult.xml", "symbol-solid/list-check plugin-font-awesome-api"),
        OPENCOVER(Messages._Parser_OpenCover(), ParserType.COVERAGE, "**/*opencover.xml", "symbol-footsteps-outline plugin-ionicons-api"),
        PIT(Messages._Parser_PIT(), ParserType.COVERAGE, "**/mutations.xml", "symbol-solid/virus-slash plugin-font-awesome-api"),
        VECTORCAST(Messages._Parser_VectorCAST(), ParserType.COVERAGE, "xml_data/cobertura/coverage_results*.xml", "symbol-footsteps-outline plugin-ionicons-api"),
        XUNIT(Messages._Parser_Xunit(), ParserType.TEST, "**/xunit.xml,**/TestResult.xml", "symbol-solid/list-check plugin-font-awesome-api");

        private final Localizable displayName;
        private final ParserType parserType;
        private final String defaultPattern;
        private final String icon;

        private Parser(Localizable displayName, ParserType parserType, String defaultPattern, String icon) {
            this.displayName = displayName;
            this.parserType = parserType;
            this.defaultPattern = defaultPattern;
            this.icon = icon;
        }

        public String getDisplayName() {
            return this.displayName.toString();
        }

        public ParserType getParserType() {
            return this.parserType;
        }

        public String getDefaultPattern() {
            return this.defaultPattern;
        }

        public String getIcon() {
            return this.icon;
        }

        public CoverageParser createParser(CoverageParser.ProcessingMode processingMode) {
            return new ParserRegistry().get(this.name(), processingMode);
        }
    }

    @Extension
    public static class CoverageToolDescriptor
    extends Descriptor<CoverageTool> {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();

        @POST
        public ListBoxModel doFillParserItems() {
            if (!JENKINS.hasPermission(Jenkins.READ)) {
                return new ListBoxModel();
            }
            List options = Stream.of(Parser.values()).map(p -> new ListBoxModel.Option(p.getDisplayName(), p.name())).collect(Collectors.toList());
            return new ListBoxModel(options);
        }

        @POST
        public FormValidation doCheckId(@AncestorInPath BuildableItem project, @QueryParameter String id) {
            if (!new JenkinsFacade().hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateId(id);
        }

        public String getHelp() {
            return "";
        }

        public String getUrl() {
            return "";
        }
    }

    public static enum ParserType {
        COVERAGE,
        TEST,
        METRICS;

    }
}

