/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.FilteredLog;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import io.jenkins.plugins.coverage.metrics.source.SourceCodePainter;
import io.jenkins.plugins.coverage.metrics.steps.CodeDeltaCalculator;
import io.jenkins.plugins.coverage.metrics.steps.CoverageBuildAction;
import io.jenkins.plugins.coverage.metrics.steps.CoverageQualityGate;
import io.jenkins.plugins.coverage.metrics.steps.CoverageQualityGateEvaluator;
import io.jenkins.plugins.coverage.metrics.steps.FileChangesProcessor;
import io.jenkins.plugins.forensics.delta.Delta;
import io.jenkins.plugins.forensics.delta.FileChanges;
import io.jenkins.plugins.forensics.reference.ReferenceFinder;
import io.jenkins.plugins.prism.SourceCodeRetention;
import io.jenkins.plugins.util.QualityGateResult;
import io.jenkins.plugins.util.ResultHandler;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class CoverageReporter {
    private static final List<Value> EMPTY_VALUES = List.of();

    CoverageBuildAction publishAction(String id, String optionalName, String icon, Node rootNode, Run<?, ?> build, FilePath workspace, TaskListener listener, List<CoverageQualityGate> qualityGates, String scm, String sourceCodeEncoding, SourceCodeRetention sourceCodeRetention, ResultHandler notifier, FilteredLog log) throws InterruptedException {
        Optional<CoverageBuildAction> possibleReferenceResult = this.getReferenceBuildAction(build, id, log);
        CoverageBuildAction action = possibleReferenceResult.isPresent() ? this.computeCoverageBasedOnReferenceBuild(id, optionalName, icon, rootNode, build, workspace, qualityGates, sourceCodeEncoding, sourceCodeRetention, notifier, possibleReferenceResult.get(), scm, listener, log) : this.computeActionWithoutHistory(id, optionalName, icon, rootNode, build, workspace, qualityGates, sourceCodeEncoding, sourceCodeRetention, notifier, log);
        build.addAction((Action)action);
        return action;
    }

    private CoverageBuildAction computeActionWithoutHistory(String id, String optionalName, String icon, Node rootNode, Run<?, ?> build, FilePath workspace, List<CoverageQualityGate> qualityGates, String sourceCodeEncoding, SourceCodeRetention sourceCodeRetention, ResultHandler notifier, FilteredLog log) throws InterruptedException {
        CoverageStatistics statistics = new CoverageStatistics(rootNode.aggregateValues(), List.of(), List.of(), List.of(), EMPTY_VALUES, List.of());
        CoverageQualityGateEvaluator evaluator = new CoverageQualityGateEvaluator(qualityGates, statistics);
        QualityGateResult qualityGateStatus = evaluator.evaluate(notifier, log);
        this.paintSourceFiles(build, workspace, sourceCodeEncoding, sourceCodeRetention, id, rootNode, rootNode.getAllFileNodes(), log);
        return new CoverageBuildAction(build, id, optionalName, icon, rootNode, qualityGateStatus, log);
    }

    private CoverageBuildAction computeCoverageBasedOnReferenceBuild(String id, String optionalName, String icon, Node rootNode, Run<?, ?> build, FilePath workspace, List<CoverageQualityGate> qualityGates, String sourceCodeEncoding, SourceCodeRetention sourceCodeRetention, ResultHandler notifier, CoverageBuildAction referenceAction, String scm, TaskListener listener, FilteredLog log) throws InterruptedException {
        List modifiedLinesDelta;
        List modifiedFilesDelta;
        List modifiedFilesValues;
        log.logInfo("Calculating the code delta...");
        CodeDeltaCalculator codeDeltaCalculator = new CodeDeltaCalculator(build, workspace, listener, scm);
        Optional<Delta> delta = codeDeltaCalculator.calculateCodeDeltaToReference(referenceAction.getOwner(), log);
        Node referenceRoot = (Node)referenceAction.getResult();
        delta.ifPresent(value -> this.createDeltaReports(rootNode, log, referenceRoot, codeDeltaCalculator, (Delta)value));
        log.logInfo("Calculating coverage deltas...");
        Node modifiedLinesCoverageRoot = rootNode.filterByModifiedLines();
        if (this.hasModifiedLinesCoverage(modifiedLinesCoverageRoot)) {
            Node modifiedFilesCoverageRoot = rootNode.filterByModifiedFiles();
            modifiedFilesValues = modifiedFilesCoverageRoot.aggregateValues();
            modifiedFilesDelta = modifiedFilesCoverageRoot.computeDelta(referenceRoot.filterByFileNames((Collection)modifiedFilesCoverageRoot.getFiles()));
            modifiedLinesDelta = modifiedLinesCoverageRoot.computeDelta(modifiedFilesCoverageRoot);
        } else {
            modifiedLinesDelta = List.of();
            modifiedFilesValues = List.of();
            modifiedFilesDelta = List.of();
            if (rootNode.hasModifiedLines()) {
                log.logInfo("No detected code changes affect the code coverage");
            }
        }
        List overallValues = rootNode.aggregateValues();
        List overallDelta = rootNode.computeDelta(referenceRoot);
        List modifiedLinesValues = modifiedLinesCoverageRoot.aggregateValues();
        CoverageStatistics statistics = new CoverageStatistics(overallValues, overallDelta, modifiedLinesValues, modifiedLinesDelta, modifiedFilesValues, modifiedFilesDelta);
        CoverageQualityGateEvaluator evaluator = new CoverageQualityGateEvaluator(qualityGates, statistics);
        QualityGateResult qualityGateResult = evaluator.evaluate(notifier, log);
        List<FileNode> filesToStore = this.computePaintedFiles(rootNode, sourceCodeRetention, log, modifiedLinesCoverageRoot);
        this.paintSourceFiles(build, workspace, sourceCodeEncoding, sourceCodeRetention, id, rootNode, filesToStore, log);
        return new CoverageBuildAction(build, id, optionalName, icon, rootNode, qualityGateResult, log, referenceAction.getOwner().getExternalizableId(), overallDelta, modifiedLinesValues, modifiedLinesDelta, modifiedFilesValues, modifiedFilesDelta, rootNode.filterByIndirectChanges().aggregateValues());
    }

    private List<FileNode> computePaintedFiles(Node rootNode, SourceCodeRetention sourceCodeRetention, FilteredLog log, Node modifiedLinesCoverageRoot) {
        List filesToStore;
        if (sourceCodeRetention == SourceCodeRetention.MODIFIED) {
            filesToStore = modifiedLinesCoverageRoot.getAllFileNodes();
            log.logInfo("-> Selecting %d modified files for source code painting", new Object[]{filesToStore.size()});
        } else {
            filesToStore = rootNode.getAllFileNodes();
        }
        return filesToStore;
    }

    private void paintSourceFiles(Run<?, ?> build, FilePath workspace, String sourceCodeEncoding, SourceCodeRetention sourceCodeRetention, String id, Node rootNode, List<FileNode> filesToStore, FilteredLog log) throws InterruptedException {
        log.logInfo("Executing source code painting...");
        SourceCodePainter sourceCodePainter = new SourceCodePainter(build, workspace, id);
        sourceCodePainter.processSourceCodePainting(rootNode, filesToStore, sourceCodeEncoding, sourceCodeRetention, log);
        log.logInfo("Finished coverage processing - adding the action to the build...");
    }

    private void createDeltaReports(Node rootNode, FilteredLog log, Node referenceRoot, CodeDeltaCalculator codeDeltaCalculator, Delta delta) {
        FileChangesProcessor fileChangesProcessor = new FileChangesProcessor();
        try {
            log.logInfo("Preprocessing code changes...");
            Set<FileChanges> changes = codeDeltaCalculator.getCoverageRelevantChanges(delta);
            Map<String, FileChanges> mappedChanges = codeDeltaCalculator.mapScmChangesToReportPaths(changes, rootNode, log);
            Map<String, String> oldPathMapping = codeDeltaCalculator.createOldPathMapping(rootNode, referenceRoot, mappedChanges, log);
            log.logInfo("Obtaining code changes for files...");
            fileChangesProcessor.attachChangedCodeLines(rootNode, mappedChanges);
            log.logInfo("Obtaining indirect coverage changes...");
            fileChangesProcessor.attachIndirectCoveragesChanges(rootNode, referenceRoot, mappedChanges, oldPathMapping);
            log.logInfo("Obtaining coverage delta for files...");
            fileChangesProcessor.attachFileCoverageDeltas(rootNode, referenceRoot, oldPathMapping);
        }
        catch (IllegalStateException exception) {
            log.logError("An error occurred while processing code and coverage changes:");
            log.logError("-> Message: " + exception.getMessage());
            log.logError("-> Skipping calculating modified lines coverage, modified files coverage and indirect coverage changes");
        }
    }

    private boolean hasModifiedLinesCoverage(Node modifiedLinesCoverageRoot) {
        Optional lineCoverage = modifiedLinesCoverageRoot.getValue(Metric.LINE);
        if (lineCoverage.isPresent() && this.hasLineCoverageSet((Value)lineCoverage.get())) {
            return true;
        }
        Optional branchCoverage = modifiedLinesCoverageRoot.getValue(Metric.BRANCH);
        return branchCoverage.filter(this::hasLineCoverageSet).isPresent();
    }

    private boolean hasLineCoverageSet(Value value) {
        Coverage coverage;
        return value instanceof Coverage && (coverage = (Coverage)value).isSet();
    }

    private Optional<CoverageBuildAction> getReferenceBuildAction(Run<?, ?> build, String id, FilteredLog log) {
        log.logInfo("Obtaining result action of reference build");
        ReferenceFinder referenceFinder = new ReferenceFinder();
        Optional reference = referenceFinder.findReference(build, log);
        if (reference.isPresent()) {
            Run referenceBuild = (Run)reference.get();
            log.logInfo("-> Using reference build '%s'", new Object[]{referenceBuild});
            Optional<CoverageBuildAction> possibleResult = this.getAction(id, (Run)reference.get());
            if (possibleResult.isEmpty()) {
                log.logInfo("-> Reference build has no action for ID '%s'", new Object[]{id});
            }
            return possibleResult;
        }
        log.logInfo("-> Found no reference build");
        return Optional.empty();
    }

    private Optional<CoverageBuildAction> getAction(String id, Run<?, ?> build) {
        List actions = build.getActions(CoverageBuildAction.class);
        for (CoverageBuildAction action : actions) {
            if (!action.getUrlName().equals(id)) continue;
            return Optional.of(action);
        }
        return Optional.empty();
    }
}

