/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import com.thoughtworks.xstream.converters.Converter;
import edu.hm.hafner.coverage.Difference;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Functions;
import hudson.model.Run;
import hudson.util.XStream2;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.steps.CoverageJobAction;
import io.jenkins.plugins.coverage.metrics.steps.CoverageViewModel;
import io.jenkins.plugins.coverage.metrics.steps.CoverageXmlStream;
import io.jenkins.plugins.coverage.metrics.steps.Messages;
import io.jenkins.plugins.coverage.metrics.steps.TrendChartFactory;
import io.jenkins.plugins.forensics.reference.ReferenceBuild;
import io.jenkins.plugins.util.AbstractXmlStream;
import io.jenkins.plugins.util.BuildAction;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.JobAction;
import io.jenkins.plugins.util.QualityGateResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.StaplerProxy;

public final class CoverageBuildAction
extends BuildAction<Node>
implements StaplerProxy {
    private static final long serialVersionUID = -6023811049340671399L;
    private static final ElementFormatter FORMATTER = new ElementFormatter();
    private static final String NO_REFERENCE_BUILD = "-";
    private static final List<Difference> NO_VALUES = List.of();
    private static final int MAX_METRICS_COUNT_IN_SUMMARY = 5;
    private final String id;
    private final String name;
    private final String referenceBuildId;
    private final QualityGateResult qualityGateResult;
    private final String icon;
    private final FilteredLog log;
    private final List<? extends Value> projectValues;
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Not used anymore")
    private transient NavigableMap<Metric, Difference> difference;
    private List<Difference> differences;
    private final List<? extends Value> modifiedLinesCoverage;
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Not used anymore")
    private transient NavigableMap<Metric, Difference> modifiedLinesCoverageDifference;
    private List<Difference> modifiedLinesDifferences;
    private final List<? extends Value> modifiedFilesCoverage;
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Not used anymore")
    private transient NavigableMap<Metric, Difference> modifiedFilesCoverageDifference;
    private List<Difference> modifiedFilesDifferences;
    private final List<? extends Value> indirectCoverageChanges;

    static void registerValueListConverters(XStream2 xstream) {
        CoverageBuildAction.registerMapConverter("difference", xstream);
        CoverageBuildAction.registerMapConverter("modifiedLinesCoverageDifference", xstream);
        CoverageBuildAction.registerMapConverter("modifiedFilesCoverageDifference", xstream);
    }

    private static void registerMapConverter(String difference, XStream2 xstream) {
        xstream.registerLocalConverter(CoverageBuildAction.class, difference, (Converter)new CoverageXmlStream.MetricFractionMapConverter());
    }

    public CoverageBuildAction(Run<?, ?> owner, String id, String optionalName, String icon, Node result, QualityGateResult qualityGateResult, FilteredLog log) {
        this(owner, id, optionalName, icon, result, qualityGateResult, log, NO_REFERENCE_BUILD, NO_VALUES, NO_VALUES, NO_VALUES, NO_VALUES, NO_VALUES, NO_VALUES);
    }

    public CoverageBuildAction(Run<?, ?> owner, String id, String optionalName, String icon, Node result, QualityGateResult qualityGateResult, FilteredLog log, String referenceBuildId, List<? extends Difference> delta, List<? extends Value> modifiedLinesCoverage, List<? extends Difference> modifiedLinesCoverageDifference, List<? extends Value> modifiedFilesCoverage, List<? extends Difference> modifiedFilesCoverageDifference, List<? extends Value> indirectCoverageChanges) {
        this(owner, id, optionalName, icon, result, qualityGateResult, log, referenceBuildId, delta, modifiedLinesCoverage, modifiedLinesCoverageDifference, modifiedFilesCoverage, modifiedFilesCoverageDifference, indirectCoverageChanges, true);
    }

    @VisibleForTesting
    CoverageBuildAction(Run<?, ?> owner, String id, String name, String icon, Node result, QualityGateResult qualityGateResult, FilteredLog log, String referenceBuildId, List<? extends Difference> differences, List<? extends Value> modifiedLinesCoverage, List<? extends Difference> modifiedLinesDifferences, List<? extends Value> modifiedFilesCoverage, List<? extends Difference> modifiedFilesDifferences, List<? extends Value> indirectCoverageChanges, boolean canSerialize) {
        super(owner, (Object)result, false);
        this.id = id;
        this.name = name;
        this.icon = icon;
        this.log = log;
        this.projectValues = result.aggregateValues();
        this.qualityGateResult = qualityGateResult;
        this.referenceBuildId = referenceBuildId;
        this.differences = this.copy(differences);
        this.modifiedLinesCoverage = this.copy(modifiedLinesCoverage);
        this.modifiedLinesDifferences = this.copy(modifiedLinesDifferences);
        this.modifiedFilesCoverage = this.copy(modifiedFilesCoverage);
        this.modifiedFilesDifferences = this.copy(modifiedFilesDifferences);
        this.indirectCoverageChanges = this.copy(indirectCoverageChanges);
        if (canSerialize) {
            this.createXmlStream().write(owner.getRootDir().toPath().resolve(this.getBuildResultBaseName()), (Object)result);
        }
    }

    private <T> List<T> copy(List<? extends T> list) {
        return new ArrayList<T>(list);
    }

    protected Object readResolve() {
        super.readResolve();
        if (this.difference == null) {
            this.difference = new TreeMap<Metric, Difference>();
        }
        if (this.modifiedLinesCoverageDifference == null) {
            this.modifiedLinesCoverageDifference = new TreeMap<Metric, Difference>();
        }
        if (this.modifiedFilesCoverageDifference == null) {
            this.modifiedFilesCoverageDifference = new TreeMap<Metric, Difference>();
        }
        if (this.differences == null) {
            this.differences = this.difference.values().stream().toList();
        }
        if (this.modifiedFilesDifferences == null) {
            this.modifiedFilesDifferences = this.modifiedFilesCoverageDifference.values().stream().toList();
        }
        if (this.modifiedLinesDifferences == null) {
            this.modifiedLinesDifferences = this.modifiedLinesCoverageDifference.values().stream().toList();
        }
        return this;
    }

    private String getActualName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.name, (CharSequence)Messages.Coverage_Link_Name());
    }

    public FilteredLog getLog() {
        return this.log;
    }

    public QualityGateResult getQualityGateResult() {
        return this.qualityGateResult;
    }

    public ElementFormatter getFormatter() {
        return FORMATTER;
    }

    public CoverageStatistics getStatistics() {
        return new CoverageStatistics(this.projectValues, this.differences, this.modifiedLinesCoverage, this.modifiedLinesDifferences, this.modifiedFilesCoverage, this.modifiedFilesDifferences);
    }

    public List<Baseline> getBaselines() {
        return List.of(Baseline.PROJECT, Baseline.MODIFIED_FILES, Baseline.MODIFIED_LINES, Baseline.INDIRECT);
    }

    public boolean hasBaselineResult(Baseline baseline) {
        return !this.getValues(baseline).isEmpty();
    }

    public Baseline getDeltaBaseline(Baseline baseline) {
        if (baseline == Baseline.PROJECT) {
            return Baseline.PROJECT_DELTA;
        }
        if (baseline == Baseline.MODIFIED_LINES) {
            return Baseline.MODIFIED_LINES_DELTA;
        }
        if (baseline == Baseline.MODIFIED_FILES) {
            return Baseline.MODIFIED_FILES_DELTA;
        }
        if (baseline == Baseline.INDIRECT) {
            return Baseline.INDIRECT;
        }
        throw new NoSuchElementException("No delta baseline for this baseline: " + String.valueOf((Object)baseline));
    }

    public String getTitle(Baseline baseline) {
        if (this.hasDelta(baseline)) {
            return this.getDeltaBaseline(baseline).getTitle();
        }
        return baseline.getTitle();
    }

    public List<Value> getAllValues(Baseline baseline) {
        return this.getValueStream(baseline).collect(Collectors.toList());
    }

    public List<Difference> getAllDeltas(Baseline baseline) {
        if (baseline == Baseline.PROJECT_DELTA) {
            return this.differences;
        }
        if (baseline == Baseline.MODIFIED_LINES_DELTA) {
            return this.modifiedLinesDifferences;
        }
        if (baseline == Baseline.MODIFIED_FILES_DELTA) {
            return this.modifiedFilesDifferences;
        }
        throw new NoSuchElementException("No delta baseline: " + String.valueOf((Object)baseline));
    }

    public List<Value> getValues(Baseline baseline) {
        return this.filterImportantMetrics(this.getValueStream(baseline));
    }

    public boolean hasCoverage() {
        return this.getAllValues(Baseline.PROJECT).stream().map(Value::getMetric).anyMatch(Metric::isCoverage);
    }

    public Optional<Value> getValueForMetric(Baseline baseline, Metric metric) {
        return this.getAllValues(baseline).stream().filter(value -> value.getMetric() == metric).findFirst();
    }

    private List<Value> filterImportantMetrics(Stream<? extends Value> values) {
        return values.filter(v -> this.getMetricsForSummary().contains(v.getMetric())).limit(5L).collect(Collectors.toList());
    }

    private Stream<? extends Value> getValueStream(Baseline baseline) {
        Stream stream;
        if (baseline == Baseline.PROJECT) {
            stream = this.projectValues.stream();
        } else if (baseline == Baseline.MODIFIED_LINES) {
            stream = this.modifiedLinesCoverage.stream();
        } else if (baseline == Baseline.MODIFIED_FILES) {
            stream = this.modifiedFilesCoverage.stream();
        } else if (baseline == Baseline.INDIRECT) {
            stream = this.indirectCoverageChanges.stream();
        } else {
            throw new NoSuchElementException("No such baseline: " + String.valueOf((Object)baseline));
        }
        return stream.sorted();
    }

    public boolean hasDelta(Baseline baseline) {
        if (this.differences.isEmpty()) {
            return false;
        }
        return baseline == Baseline.PROJECT || baseline == Baseline.MODIFIED_LINES || baseline == Baseline.MODIFIED_FILES;
    }

    public boolean hasDelta(Baseline baseline, Metric metric) {
        if (baseline == Baseline.PROJECT) {
            return this.containsMetric(metric, this.differences);
        }
        if (baseline == Baseline.MODIFIED_LINES) {
            return this.isLineOrBranchCoverage(metric) && this.containsMetric(metric, this.modifiedLinesDifferences);
        }
        if (baseline == Baseline.MODIFIED_FILES) {
            return this.isLineOrBranchCoverage(metric) && this.containsMetric(metric, this.modifiedFilesDifferences);
        }
        if (baseline == Baseline.INDIRECT) {
            return false;
        }
        throw new NoSuchElementException("No such baseline: " + String.valueOf((Object)baseline));
    }

    private boolean isLineOrBranchCoverage(Metric metric) {
        return Set.of(Metric.BRANCH, Metric.LINE).contains(metric);
    }

    private boolean containsMetric(Metric metric, List<Difference> values) {
        return values.stream().map(Value::getMetric).anyMatch(arg_0 -> metric.equals(arg_0));
    }

    public Optional<Value> getDelta(Baseline baseline, Metric metric) {
        if (baseline == Baseline.PROJECT) {
            return this.findDelta(metric, this.differences);
        }
        if (baseline == Baseline.MODIFIED_LINES) {
            return this.findDelta(metric, this.modifiedLinesDifferences);
        }
        if (baseline == Baseline.MODIFIED_FILES) {
            return this.findDelta(metric, this.modifiedFilesDifferences);
        }
        return Optional.empty();
    }

    private Optional<Value> findDelta(Metric metric, List<Difference> values) {
        return values.stream().filter(d -> d.getMetric() == metric).findAny().map(Value.class::cast);
    }

    public boolean hasValue(Baseline baseline, Metric metric) {
        return this.getAllValues(baseline).stream().anyMatch(v -> v.getMetric() == metric);
    }

    public String formatValue(Baseline baseline, Metric metric) {
        Optional<Value> value = this.getValueForMetric(baseline, metric);
        return value.isPresent() ? FORMATTER.formatValue(value.get()) : Messages.Coverage_Not_Available();
    }

    public String formatDelta(Baseline baseline, Metric metric) {
        Locale currentLocale = Functions.getCurrentLocale();
        if (baseline == Baseline.PROJECT && this.hasDelta(baseline, metric)) {
            return FORMATTER.formatDelta(metric, this.findDelta(metric, this.differences).get(), currentLocale);
        }
        if (baseline == Baseline.MODIFIED_LINES && this.hasDelta(baseline, metric)) {
            return FORMATTER.formatDelta(metric, this.findDelta(metric, this.modifiedLinesDifferences).get(), currentLocale);
        }
        if (baseline == Baseline.MODIFIED_FILES && this.hasDelta(baseline, metric)) {
            return FORMATTER.formatDelta(metric, this.findDelta(metric, this.modifiedFilesDifferences).get(), currentLocale);
        }
        return Messages.Coverage_Not_Available();
    }

    public double getTrend(Baseline baseline, Metric metric) {
        Optional<Value> delta = this.getDelta(baseline, metric);
        if (delta.isPresent()) {
            double deltaValue = delta.get().asDouble();
            if (-0.001 < deltaValue && deltaValue < 0.001) {
                return 0.0;
            }
            return deltaValue;
        }
        return 0.0;
    }

    @VisibleForTesting
    NavigableSet<Metric> getMetricsForSummary() {
        return new TreeSet<Metric>(Set.of(Metric.LINE, Metric.BRANCH, Metric.MUTATION, Metric.TEST_STRENGTH, Metric.LOC, Metric.NCSS, Metric.TESTS, Metric.CYCLOMATIC_COMPLEXITY, Metric.COGNITIVE_COMPLEXITY, Metric.NPATH_COMPLEXITY, Metric.MCDC_PAIR, Metric.FUNCTION_CALL));
    }

    public Optional<Run<?, ?>> getReferenceBuild() {
        if (NO_REFERENCE_BUILD.equals(this.referenceBuildId)) {
            return Optional.empty();
        }
        return new JenkinsFacade().getBuild(this.referenceBuildId);
    }

    public String getReferenceBuildLink() {
        return ReferenceBuild.getReferenceBuildLink((String)this.referenceBuildId);
    }

    protected AbstractXmlStream<Node> createXmlStream() {
        return new CoverageXmlStream();
    }

    protected JobAction<? extends BuildAction<Node>> createProjectAction() {
        return new CoverageJobAction(this.getOwner().getParent(), this.getUrlName(), this.name, this.icon);
    }

    protected String getBuildResultBaseName() {
        return "%s.xml".formatted(this.id);
    }

    public CoverageViewModel getTarget() {
        return new CoverageViewModel(this.getOwner(), this.getUrlName(), this.name, (Node)this.getResult(), this.getStatistics(), this.getQualityGateResult(), this.getReferenceBuildLink(), this.log, this::createCoverageModel, this::createMetricsModel);
    }

    private String createCoverageModel(String configuration) {
        return new JacksonFacade().toJson((Object)new TrendChartFactory().createChartModel(configuration, this));
    }

    private String createMetricsModel(String configuration) {
        return new JacksonFacade().toJson((Object)new TrendChartFactory().createMetricsModel(configuration, this));
    }

    @NonNull
    public String getIconFileName() {
        return this.icon;
    }

    @NonNull
    public String getDisplayName() {
        return this.getActualName();
    }

    @NonNull
    public String getUrlName() {
        return this.id;
    }

    public String toString() {
        return "%s (%s): %s".formatted(this.getDisplayName(), this.getUrlName(), this.projectValues);
    }

    static {
        CoverageXmlStream.registerConverters(Run.XSTREAM2);
        CoverageBuildAction.registerValueListConverters(Run.XSTREAM2);
    }
}

