/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.color;

import io.jenkins.plugins.coverage.metrics.color.ColorId;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;
import io.jenkins.plugins.coverage.metrics.color.CoverageColorJenkinsId;
import io.jenkins.plugins.coverage.metrics.color.CoverageColorPalette;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ColorProviderFactory {
    private ColorProviderFactory() {
    }

    public static ColorProvider createDefaultColorProvider() {
        return new ColorProvider(ColorProviderFactory.getDefaultColors());
    }

    public static ColorProvider createColorProvider(Map<String, String> colors) {
        if (!colors.keySet().equals(CoverageColorJenkinsId.getAll()) || !ColorProviderFactory.verifyHexCodes(colors.values())) {
            return ColorProviderFactory.createDefaultColorProvider();
        }
        EnumMap<ColorId, ColorProvider.DisplayColors> colorMap = new EnumMap<ColorId, ColorProvider.DisplayColors>(ColorId.class);
        colorMap.put(ColorId.INSUFFICIENT, ColorProviderFactory.createDisplayColor(colors.get(CoverageColorJenkinsId.RED.getJenkinsColorId()), "#ffffff"));
        colorMap.put(ColorId.VERY_BAD, ColorProviderFactory.createDisplayColor(colors.get(CoverageColorJenkinsId.LIGHT_RED.getJenkinsColorId()), "#ffffff"));
        colorMap.put(ColorId.BAD, ColorProviderFactory.createDisplayColor(colors.get(CoverageColorJenkinsId.ORANGE.getJenkinsColorId()), "#000000"));
        colorMap.put(ColorId.INADEQUATE, ColorProviderFactory.createDisplayColor(colors.get(CoverageColorJenkinsId.LIGHT_ORANGE.getJenkinsColorId()), "#000000"));
        colorMap.put(ColorId.AVERAGE, ColorProviderFactory.createDisplayColor(colors.get(CoverageColorJenkinsId.YELLOW.getJenkinsColorId()), "#000000"));
        colorMap.put(ColorId.GOOD, ColorProviderFactory.createDisplayColor(colors.get(CoverageColorJenkinsId.LIGHT_YELLOW.getJenkinsColorId()), "#000000"));
        colorMap.put(ColorId.VERY_GOOD, ColorProviderFactory.createDisplayColor(colors.get(CoverageColorJenkinsId.LIGHT_GREEN.getJenkinsColorId()), "#000000"));
        colorMap.put(ColorId.EXCELLENT, ColorProviderFactory.createDisplayColor(colors.get(CoverageColorJenkinsId.GREEN.getJenkinsColorId()), "#ffffff"));
        colorMap.put(ColorId.BLACK, ColorProviderFactory.createDisplayColor(CoverageColorPalette.BLACK));
        colorMap.put(ColorId.WHITE, ColorProviderFactory.createDisplayColor(CoverageColorPalette.WHITE));
        return new ColorProvider(colorMap);
    }

    private static Map<ColorId, ColorProvider.DisplayColors> getDefaultColors() {
        return Arrays.stream(CoverageColorPalette.values()).collect(Collectors.toMap(CoverageColorPalette::getColorId, ColorProviderFactory::createDisplayColor));
    }

    private static boolean verifyHexCodes(Collection<String> hexCodes) {
        Pattern hexPattern = Pattern.compile("^#[A-Fa-f0-9]{6}$");
        for (String hex : hexCodes) {
            if (hexPattern.matcher(hex).matches()) continue;
            return false;
        }
        return true;
    }

    private static ColorProvider.DisplayColors createDisplayColor(CoverageColorPalette color) {
        return new ColorProvider.DisplayColors(color.getLineColor(), color.getFillColor());
    }

    private static ColorProvider.DisplayColors createDisplayColor(String backgroundColorHex, String textColorHex) {
        Color backgroundColor = Color.decode(backgroundColorHex);
        Color textColor = Color.decode(textColorHex);
        return new ColorProvider.DisplayColors(textColor, backgroundColor);
    }
}

