/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.charts;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.echarts.ItemStyle;
import edu.hm.hafner.echarts.Label;
import edu.hm.hafner.echarts.LabeledTreeMapNode;
import hudson.Functions;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;
import io.jenkins.plugins.coverage.metrics.color.ColorProviderFactory;
import io.jenkins.plugins.coverage.metrics.color.CoverageLevel;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.echarts.JenkinsPalette;
import java.util.Optional;

public class TreeMapNodeConverter {
    private static final ElementFormatter FORMATTER = new ElementFormatter();

    public LabeledTreeMapNode toTreeChartModel(Node node, Metric metric, ColorProvider colorProvider) {
        Node tree = this.mergePackages(node);
        LabeledTreeMapNode root = this.toTreeMapNode(tree, metric, colorProvider).orElse(new LabeledTreeMapNode(this.getId(node), node.getName()));
        for (LabeledTreeMapNode child : root.getChildren()) {
            child.collapseEmptyPackages();
        }
        return root;
    }

    private String getId(Node node) {
        String id = node.getName();
        if (node.isRoot()) {
            return id;
        }
        return this.getId(node.getParent()) + "/" + id;
    }

    private Node mergePackages(Node root) {
        Node node = this.skipEmptyModules(root);
        if (node instanceof ModuleNode) {
            ModuleNode copy = (ModuleNode)node.copyTree();
            copy.splitPackages();
            return copy;
        }
        return root;
    }

    private Node skipEmptyModules(Node root) {
        Node node = root;
        while (node.hasChildren() && node.getChildren().size() == 1 && this.isTopLevel((Node)node.getChildren().get(0))) {
            node = (Node)node.getChildren().get(0);
        }
        return node;
    }

    private boolean isTopLevel(Node child) {
        return child.getMetric() == Metric.MODULE || child.getMetric() == Metric.CONTAINER;
    }

    private Optional<LabeledTreeMapNode> toTreeMapNode(Node node, Metric metric, ColorProvider colorProvider) {
        Optional value = node.getValue(metric);
        if (value.isPresent()) {
            Value rootValue = (Value)value.get();
            if (rootValue instanceof Coverage) {
                Coverage coverage = (Coverage)rootValue;
                return Optional.of(this.createCoverageTree(coverage, colorProvider, node, metric));
            }
            return Optional.of(this.createMetricsTree(rootValue, node, metric));
        }
        return Optional.empty();
    }

    private LabeledTreeMapNode createCoverageTree(Coverage coverage, ColorProvider colorProvider, Node node, Metric metric) {
        ColorProvider.DisplayColors colors = CoverageLevel.getDisplayColorsOfCoverageLevel(coverage.asDouble(), colorProvider);
        String lineColor = colors.getLineColorAsRGBHex();
        String fillColor = colors.getFillColorAsRGBHex();
        Label label = new Label(true, lineColor);
        if (node instanceof FileNode) {
            return this.createTreeNode(coverage, node, new ItemStyle(fillColor), label);
        }
        ItemStyle boldFill = new ItemStyle(fillColor, fillColor, 4);
        LabeledTreeMapNode treeNode = this.createTreeNode(coverage, node, boldFill, label);
        node.getChildren().stream().map(n -> this.toTreeMapNode((Node)n, metric, colorProvider)).flatMap(Optional::stream).forEach(arg_0 -> ((LabeledTreeMapNode)treeNode).insertNode(arg_0));
        return treeNode;
    }

    private LabeledTreeMapNode createTreeNode(Coverage coverage, Node node, ItemStyle itemStyle, Label label) {
        return new LabeledTreeMapNode(this.getId(node), node.getName(), itemStyle, label, label, String.valueOf(coverage.getTotal()), new String[]{FORMATTER.getTooltip((Value)coverage)});
    }

    private LabeledTreeMapNode createMetricsTree(Value value, Node node, Metric metric) {
        String fillColor;
        Label label = new Label(true, JenkinsPalette.BLACK.normal());
        String string = fillColor = metric == Metric.TESTS ? JenkinsPalette.GREEN.light() : JenkinsPalette.ORANGE.normal();
        if (node instanceof FileNode) {
            return this.createValueNode(value, node, new ItemStyle(fillColor), label);
        }
        LabeledTreeMapNode treeNode = this.createValueNode(value, node, new ItemStyle(fillColor, fillColor, 4), label);
        node.getChildren().stream().map(n -> this.toTreeMapNode((Node)n, metric, ColorProviderFactory.createDefaultColorProvider())).flatMap(Optional::stream).forEach(arg_0 -> ((LabeledTreeMapNode)treeNode).insertNode(arg_0));
        return treeNode;
    }

    private LabeledTreeMapNode createValueNode(Value value, Node node, ItemStyle itemStyle, Label label) {
        return new LabeledTreeMapNode(this.getId(node), node.getName(), itemStyle, label, label, value.asText(Functions.getCurrentLocale()), new String[]{FORMATTER.getTooltip(value)});
    }
}

