/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Value;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.steps.CoverageBuildAction;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;

@Extension(optional=true)
public class CoverageTokenMacro
extends DataBoundTokenMacro {
    private static final ElementFormatter FORMATTER = new ElementFormatter();
    static final String COVERAGE = "COVERAGE";
    private String id = "coverage";
    private Metric metric = Metric.LINE;
    private Baseline baseline = Baseline.PROJECT;

    @DataBoundTokenMacro.Parameter
    public void setId(String id) {
        this.id = id;
    }

    @DataBoundTokenMacro.Parameter
    public void setMetric(String metric) {
        this.metric = Metric.valueOf((String)metric);
    }

    @DataBoundTokenMacro.Parameter
    public void setBaseline(String baseline) {
        this.baseline = Baseline.valueOf(baseline);
    }

    public boolean acceptsMacroName(String macroName) {
        return COVERAGE.equals(macroName);
    }

    public String evaluate(AbstractBuild<?, ?> abstractBuild, TaskListener taskListener, String macroName) {
        return this.extractCoverageFromBuild((Run<?, ?>)abstractBuild);
    }

    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) {
        return this.extractCoverageFromBuild(run);
    }

    private String extractCoverageFromBuild(Run<?, ?> run) {
        Optional<Value> value;
        Optional<CoverageStatistics> statistics = run.getActions(CoverageBuildAction.class).stream().filter(this.createIdFilter()).map(CoverageBuildAction::getStatistics).findFirst();
        if (statistics.isPresent() && (value = statistics.get().getValue(this.baseline, this.metric)).isPresent()) {
            return FORMATTER.format(value.get());
        }
        return "n/a";
    }

    private Predicate<CoverageBuildAction> createIdFilter() {
        if (StringUtils.isBlank((CharSequence)this.id)) {
            return jobAction -> true;
        }
        return jobAction -> jobAction.getUrlName().equals(this.id);
    }
}

