/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Mutation;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.LineRange;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.checks.api.ChecksAnnotation;
import io.jenkins.plugins.checks.api.ChecksConclusion;
import io.jenkins.plugins.checks.api.ChecksDetails;
import io.jenkins.plugins.checks.api.ChecksOutput;
import io.jenkins.plugins.checks.api.ChecksPublisherFactory;
import io.jenkins.plugins.checks.api.ChecksStatus;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.steps.CoverageBuildAction;
import io.jenkins.plugins.coverage.metrics.steps.CoverageRecorder;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.QualityGateResult;
import io.jenkins.plugins.util.QualityGateStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

class CoverageChecksPublisher {
    private static final ElementFormatter FORMATTER = new ElementFormatter();
    private static final int TITLE_HEADER_LEVEL = 4;
    private static final char NEW_LINE = '\n';
    private static final String COLUMN = "|";
    private static final String GAP = " ";
    private final CoverageBuildAction action;
    private final Node rootNode;
    private final JenkinsFacade jenkinsFacade;
    private final String checksName;
    private final CoverageRecorder.ChecksAnnotationScope annotationScope;

    CoverageChecksPublisher(CoverageBuildAction action, Node rootNode, String checksName, CoverageRecorder.ChecksAnnotationScope annotationScope) {
        this(action, rootNode, checksName, annotationScope, new JenkinsFacade());
    }

    @VisibleForTesting
    CoverageChecksPublisher(CoverageBuildAction action, Node rootNode, String checksName, CoverageRecorder.ChecksAnnotationScope annotationScope, JenkinsFacade jenkinsFacade) {
        this.rootNode = rootNode;
        this.jenkinsFacade = jenkinsFacade;
        this.action = action;
        this.checksName = checksName;
        this.annotationScope = annotationScope;
    }

    private ChecksFormatter getFormatter() {
        if (this.rootNode.getValue(Metric.FUNCTION_CALL).isPresent() || this.rootNode.getValue(Metric.MCDC_PAIR).isPresent()) {
            return new VectorCastFormatter();
        }
        return new ChecksFormatter();
    }

    void publishCoverageReport(TaskListener listener) {
        ChecksPublisherFactory.fromRun((Run)this.action.getOwner(), (TaskListener)listener).publish(this.extractChecksDetails());
    }

    @VisibleForTesting
    ChecksDetails extractChecksDetails() {
        ChecksOutput output = new ChecksOutput.ChecksOutputBuilder().withTitle(this.getChecksTitle()).withSummary(this.getSummary()).withText(this.getProjectMetricsSummary()).withAnnotations(this.getAnnotations()).build();
        return new ChecksDetails.ChecksDetailsBuilder().withName(this.checksName).withStatus(ChecksStatus.COMPLETED).withConclusion(this.getCheckConclusion(this.action.getQualityGateResult().getOverallStatus())).withDetailsURL(this.getBaseUrl()).withOutput(output).build();
    }

    private String getChecksTitle() {
        return this.getFormatter().getTitleMetrics().stream().map(this::format).flatMap(Optional::stream).collect(Collectors.joining(", "));
    }

    private Optional<String> format(Metric metric) {
        Baseline baseline = this.selectBaseline();
        return this.action.getValueForMetric(baseline, metric).map(value -> this.formatValue(baseline, metric, (Value)value));
    }

    private Baseline selectBaseline() {
        if (this.action.hasBaselineResult(Baseline.MODIFIED_LINES)) {
            return Baseline.MODIFIED_LINES;
        }
        return Baseline.PROJECT;
    }

    private String formatValue(Baseline baseline, Metric metric, Value value) {
        return "%s: %s%s".formatted(FORMATTER.getDisplayName(metric), FORMATTER.format(value), this.getDeltaDetails(baseline, metric));
    }

    private String getDeltaDetails(Baseline baseline, Metric metric) {
        if (this.action.hasDelta(baseline, metric)) {
            return " (%s)".formatted(this.action.formatDelta(baseline, metric));
        }
        return "";
    }

    private String getSummary() {
        return this.getAnnotationSummary() + this.getOverallCoverageSummary() + this.getQualityGatesSummary();
    }

    private String getAnnotationSummary() {
        if (this.rootNode.hasModifiedLines()) {
            Node filteredRoot = this.rootNode.filterByModifiedLines();
            List modifiedFiles = filteredRoot.getAllFileNodes();
            StringBuilder summary = new StringBuilder("#### Summary for modified lines\n");
            this.createTotalLinesSummary(modifiedFiles, summary);
            this.createLineCoverageSummary(modifiedFiles, summary);
            this.createBranchCoverageSummary(filteredRoot, modifiedFiles, summary);
            this.createMutationCoverageSummary(filteredRoot, modifiedFiles, summary);
            return summary.toString();
        }
        return "";
    }

    private void createTotalLinesSummary(List<FileNode> modifiedFiles, StringBuilder summary) {
        int total = this.countLines(modifiedFiles, FileNode::getModifiedLines);
        if (total == 1) {
            summary.append("- 1 line has been modified");
        } else {
            summary.append("- %d lines have been modified".formatted(total));
        }
        summary.append('\n');
    }

    private int countLines(List<FileNode> modifiedFiles, Function<FileNode, Collection<?>> linesGetter) {
        return modifiedFiles.stream().map(linesGetter).mapToInt(Collection::size).sum();
    }

    private void createLineCoverageSummary(List<FileNode> modifiedFiles, StringBuilder summary) {
        int missed = this.countLines(modifiedFiles, FileNode::getMissedLines);
        if (missed == 0) {
            summary.append("- all lines are covered");
        } else if (missed == 1) {
            summary.append("- 1 line is not covered");
        } else {
            summary.append("- %d lines are not covered".formatted(missed));
        }
        summary.append('\n');
    }

    private void createBranchCoverageSummary(Node filteredRoot, List<FileNode> modifiedFiles, StringBuilder summary) {
        if (filteredRoot.containsMetric(Metric.BRANCH)) {
            long partiallyCovered = modifiedFiles.stream().map(FileNode::getPartiallyCoveredLines).map(Map::size).count();
            if (partiallyCovered == 1L) {
                summary.append("- 1 line is covered only partially");
            } else {
                summary.append("- %d lines are covered only partially".formatted(partiallyCovered));
            }
            summary.append('\n');
        }
    }

    private void createMutationCoverageSummary(Node filteredRoot, List<FileNode> modifiedFiles, StringBuilder summary) {
        if (filteredRoot.containsMetric(Metric.MUTATION)) {
            long survived = modifiedFiles.stream().map(FileNode::getSurvivedMutationsPerLine).map(Map::entrySet).flatMap(Collection::stream).map(Map.Entry::getValue).count();
            int mutations = this.countLines(modifiedFiles, FileNode::getMutations);
            if (survived == 0L) {
                if (mutations == 1) {
                    summary.append("- 1 mutation has been killed");
                } else {
                    summary.append("- all %d mutations have been killed".formatted(mutations));
                }
            } else if (survived == 1L) {
                summary.append("- 1 mutation survived (of %d)".formatted(mutations));
            } else {
                summary.append("- %d mutations survived (of %d)".formatted(survived, mutations));
            }
            summary.append('\n');
        }
    }

    private List<ChecksAnnotation> getAnnotations() {
        if (this.annotationScope == CoverageRecorder.ChecksAnnotationScope.SKIP) {
            return List.of();
        }
        ArrayList<ChecksAnnotation> annotations = new ArrayList<ChecksAnnotation>();
        Node filteredByScope = this.filterAnnotations();
        boolean hasMutationCoverage = filteredByScope.getValue(Metric.MUTATION).isPresent();
        for (FileNode fileNode : filteredByScope.getAllFileNodes()) {
            if (hasMutationCoverage) {
                annotations.addAll(this.getSurvivedMutations(fileNode));
                continue;
            }
            annotations.addAll(this.getMissingLines(fileNode));
            annotations.addAll(this.getPartiallyCoveredLines(fileNode));
        }
        return annotations;
    }

    private Node filterAnnotations() {
        if (this.annotationScope == CoverageRecorder.ChecksAnnotationScope.ALL_LINES) {
            return this.rootNode;
        }
        return this.rootNode.filterByModifiedLines();
    }

    private Collection<? extends ChecksAnnotation> getMissingLines(FileNode fileNode) {
        ChecksAnnotation.ChecksAnnotationBuilder builder = this.createAnnotationBuilder(fileNode);
        return fileNode.getMissedLineRanges().stream().map(range -> this.rangeToAnnotation((LineRange)range, builder)).collect(Collectors.toList());
    }

    private ChecksAnnotation rangeToAnnotation(LineRange range, ChecksAnnotation.ChecksAnnotationBuilder builder) {
        if (range.getStart() == range.getEnd()) {
            builder.withTitle("Not covered line").withMessage("Line %d is not covered by tests".formatted(range.getStart()));
        } else {
            builder.withTitle("Not covered lines").withMessage("Lines %d-%d are not covered by tests".formatted(range.getStart(), range.getEnd()));
        }
        return builder.withStartLine(Integer.valueOf(range.getStart())).withEndLine(Integer.valueOf(range.getEnd())).build();
    }

    private Collection<? extends ChecksAnnotation> getSurvivedMutations(FileNode fileNode) {
        ChecksAnnotation.ChecksAnnotationBuilder builder = this.createAnnotationBuilder(fileNode).withTitle("Mutation survived");
        return fileNode.getSurvivedMutationsPerLine().entrySet().stream().filter(entry -> fileNode.getCoveredOfLine(((Integer)entry.getKey()).intValue()) > 0).map(entry -> builder.withMessage(this.createMutationMessage((Integer)entry.getKey(), (List)entry.getValue())).withStartLine((Integer)entry.getKey()).withEndLine((Integer)entry.getKey()).withRawDetails(this.createMutationDetails((List)entry.getValue())).build()).collect(Collectors.toList());
    }

    private String createMutationDetails(List<Mutation> mutations) {
        return mutations.stream().map(mutation -> "- %s (%s)".formatted(mutation.getDescription(), mutation.getMutator())).collect(Collectors.joining("\n", "Survived mutations:\n", ""));
    }

    private String createMutationMessage(int line, List<Mutation> survived) {
        if (survived.size() == 1) {
            return "One mutation survived in line %d (%s)".formatted(line, this.formatMutator(survived));
        }
        return "%d mutations survived in line %d".formatted(survived.size(), line);
    }

    private String formatMutator(List<Mutation> survived) {
        return survived.get(0).getMutator().replaceAll(".*\\.", "");
    }

    private Collection<? extends ChecksAnnotation> getPartiallyCoveredLines(FileNode fileNode) {
        ChecksAnnotation.ChecksAnnotationBuilder builder = this.createAnnotationBuilder(fileNode).withTitle("Partially covered line");
        return fileNode.getPartiallyCoveredLines().entrySet().stream().map(entry -> builder.withMessage(this.createBranchMessage((Integer)entry.getKey(), (Integer)entry.getValue())).withStartLine((Integer)entry.getKey()).withEndLine((Integer)entry.getKey()).build()).collect(Collectors.toList());
    }

    private String createBranchMessage(int line, int missed) {
        if (missed == 1) {
            return "Line %d is only partially covered, one branch is missing".formatted(line);
        }
        return "Line %d is only partially covered, %d branches are missing".formatted(line, missed);
    }

    private ChecksAnnotation.ChecksAnnotationBuilder createAnnotationBuilder(FileNode fileNode) {
        return new ChecksAnnotation.ChecksAnnotationBuilder().withPath(fileNode.getRelativePath()).withAnnotationLevel(ChecksAnnotation.ChecksAnnotationLevel.WARNING);
    }

    private String getBaseUrl() {
        return this.jenkinsFacade.getAbsoluteUrl(new String[]{this.action.getOwner().getUrl(), this.action.getUrlName()});
    }

    private List<Baseline> getBaselines() {
        return List.of(Baseline.PROJECT, Baseline.MODIFIED_FILES, Baseline.MODIFIED_LINES, Baseline.INDIRECT);
    }

    private String getOverallCoverageSummary() {
        if (this.rootNode.hasModifiedLines()) {
            return this.createDeltaBaselinesOverview();
        }
        return this.createProjectOverview();
    }

    private String createDeltaBaselinesOverview() {
        StringBuilder description = new StringBuilder(this.getSectionHeader(4, "Overview by baseline"));
        for (Baseline baseline : this.getBaselines()) {
            if (!this.action.hasBaselineResult(baseline)) continue;
            description.append(this.getBulletListItem(1, this.formatText(TextFormat.BOLD, this.getUrlText(this.action.getTitle(baseline), this.getBaseUrl() + baseline.getUrl()))));
            for (Value value : this.getValues(baseline)) {
                Object display = FORMATTER.formatDetailedValueWithMetric(value);
                if (this.action.hasDelta(baseline, value.getMetric())) {
                    display = (String)display + " - Delta: %s".formatted(this.action.formatDelta(baseline, value.getMetric()));
                }
                description.append(this.getBulletListItem(4, (String)display));
            }
        }
        description.append('\n');
        return description.toString();
    }

    private List<Value> getValues(Baseline baseline) {
        return this.action.getAllValues(baseline).stream().filter(value -> this.getFormatter().getOverviewMetrics().contains(value.getMetric())).collect(Collectors.toList());
    }

    private String createProjectOverview() {
        StringBuilder description = new StringBuilder(this.getSectionHeader(4, "Project Overview"));
        description.append("No changes detected, that affect the code coverage.\n");
        for (Value value : this.getValues(Baseline.PROJECT)) {
            description.append(this.getBulletListItem(1, FORMATTER.formatDetailedValueWithMetric(value)));
        }
        description.append('\n');
        return description.toString();
    }

    private String getQualityGatesSummary() {
        String summary = this.getSectionHeader(4, "Quality Gates Summary");
        QualityGateResult qualityGateResult = this.action.getQualityGateResult();
        if (qualityGateResult.isInactive()) {
            return summary + "No active quality gates.";
        }
        return summary + "Overall result: " + qualityGateResult.getOverallStatus().getDescription() + "\n" + qualityGateResult.getMessages().stream().map(s -> s.replaceAll("-> ", "")).map(s -> s.replaceAll("[\\[\\]]", "")).collect(this.asSeparateLines());
    }

    private Collector<CharSequence, ?, String> asSeparateLines() {
        return Collectors.joining("\n- ", "- ", "\n");
    }

    private String getProjectMetricsSummary() {
        StringBuilder builder = new StringBuilder(this.getSectionHeader(4, "Project coverage details"));
        builder.append(COLUMN);
        builder.append(COLUMN);
        builder.append(this.getMetricStream().map(FORMATTER::getDisplayName).collect(this.asColumn()));
        builder.append(COLUMN);
        builder.append(":---:");
        builder.append(COLUMN);
        builder.append(this.getMetricStream().map(i -> ":---:").collect(this.asColumn()));
        for (Baseline baseline : this.action.getBaselines()) {
            if (!this.action.hasBaselineResult(baseline)) continue;
            builder.append("%s **%s**|".formatted(Icon.FEET.markdown, FORMATTER.getDisplayName(baseline)));
            builder.append(this.getMetricStream().map(metric -> this.action.formatValue(baseline, (Metric)metric)).collect(this.asColumn()));
            Baseline deltaBaseline = this.action.getDeltaBaseline(baseline);
            if (deltaBaseline == baseline) continue;
            builder.append("%s **%s**|".formatted(Icon.CHART_UPWARDS_TREND.markdown, FORMATTER.getDisplayName(deltaBaseline)));
            builder.append(this.getMetricStream().map(metric -> this.getFormatDelta(baseline, (Metric)metric)).collect(this.asColumn()));
        }
        return builder.toString();
    }

    private String getFormatDelta(Baseline baseline, Metric metric) {
        String delta = this.action.formatDelta(baseline, metric);
        return delta + this.getTrendIcon(delta);
    }

    private Stream<Metric> getMetricStream() {
        return Metric.getCoverageMetrics().stream().skip(1L).filter(m -> this.rootNode.getValue(m).isPresent());
    }

    private Collector<CharSequence, ?, String> asColumn() {
        return Collectors.joining(COLUMN, "", "\n");
    }

    private String formatText(TextFormat format, String text) {
        return switch (format) {
            default -> throw new IncompatibleClassChangeError();
            case TextFormat.BOLD -> "**" + text + "**";
            case TextFormat.CURSIVE -> "_" + text + "_";
        };
    }

    private String getTrendIcon(String trend) {
        if (!StringUtils.containsAny((CharSequence)trend, (CharSequence)"123456789") || trend.startsWith("n/a")) {
            return "";
        }
        return GAP + (trend.startsWith("+") ? Icon.ARROW_UP.markdown : Icon.ARROW_DOWN.markdown);
    }

    private String getBulletListItem(int level, String text) {
        int whitespaces = (level - 1) * 4;
        return String.join((CharSequence)"", Collections.nCopies(whitespaces, GAP)) + "* " + text + "\n";
    }

    private String getUrlText(String text, String url) {
        return "[%s](%s)".formatted(text, url);
    }

    private String getSectionHeader(int level, String text) {
        return String.join((CharSequence)"", Collections.nCopies(level, "#")) + GAP + text + "\n\n";
    }

    private ChecksConclusion getCheckConclusion(QualityGateStatus status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case QualityGateStatus.INACTIVE, QualityGateStatus.PASSED -> ChecksConclusion.SUCCESS;
            case QualityGateStatus.FAILED, QualityGateStatus.ERROR, QualityGateStatus.WARNING, QualityGateStatus.NOTE -> ChecksConclusion.FAILURE;
        };
    }

    private static class VectorCastFormatter
    extends ChecksFormatter {
        private VectorCastFormatter() {
        }

        @Override
        NavigableSet<Metric> getOverviewMetrics() {
            NavigableSet<Metric> valueMetrics = super.getOverviewMetrics();
            valueMetrics.add(Metric.METHOD);
            return valueMetrics;
        }
    }

    private static class ChecksFormatter {
        private ChecksFormatter() {
        }

        NavigableSet<Metric> getTitleMetrics() {
            return new TreeSet<Metric>(Set.of(Metric.LINE, Metric.BRANCH, Metric.MUTATION));
        }

        NavigableSet<Metric> getOverviewMetrics() {
            return new TreeSet<Metric>(Set.of(Metric.LINE, Metric.LOC, Metric.BRANCH, Metric.CYCLOMATIC_COMPLEXITY, Metric.MUTATION, Metric.TEST_STRENGTH, Metric.TESTS, Metric.MCDC_PAIR, Metric.FUNCTION_CALL));
        }
    }

    private static enum TextFormat {
        BOLD,
        CURSIVE;

    }

    private static enum Icon {
        FEET(":feet:"),
        WHITE_CHECK_MARK(":white_check_mark:"),
        CHART_UPWARDS_TREND(":chart_with_upwards_trend:"),
        ARROW_UP(":arrow_up:"),
        ARROW_RIGHT(":arrow_right:"),
        ARROW_DOWN(":arrow_down:");

        private final String markdown;

        private Icon(String markdown) {
            this.markdown = markdown;
        }
    }
}

