/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import hudson.Functions;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;
import io.jenkins.plugins.coverage.metrics.steps.CoverageTableModel;
import io.jenkins.plugins.datatables.DetailedCell;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

abstract class ChangesTableModel
extends CoverageTableModel {
    private final Node changeRoot;

    ChangesTableModel(String id, Node root, Node changeRoot, CoverageTableModel.RowRenderer renderer, ColorProvider colorProvider) {
        super(id, root, renderer, colorProvider);
        this.changeRoot = changeRoot;
    }

    @Override
    public List<Object> getRows() {
        Locale browserLocale = Functions.getCurrentLocale();
        return this.changeRoot.getAllFileNodes().stream().map(file -> this.createRow((FileNode)file, browserLocale)).collect(Collectors.toList());
    }

    abstract CoverageTableModel.CoverageRow createRow(FileNode var1, Locale var2);

    FileNode getOriginalNode(FileNode fileNode) {
        return this.getRoot().getAllFileNodes().stream().filter(node -> node.getRelativePath().equals(fileNode.getRelativePath()) && node.getName().equals(fileNode.getName())).findFirst().orElse(fileNode);
    }

    static class ChangesRow
    extends CoverageTableModel.CoverageRow {
        private final FileNode originalFile;

        ChangesRow(FileNode originalFile, FileNode changedFileNode, Locale browserLocale, CoverageTableModel.RowRenderer renderer, ColorProvider colorProvider) {
            super(changedFileNode, browserLocale, renderer, colorProvider);
            this.originalFile = originalFile;
        }

        FileNode getOriginalFile() {
            return this.originalFile;
        }

        @Override
        public DetailedCell<?> getLineCoverageDelta() {
            return this.createColoredModifiedLinesCoverageDeltaColumn(Metric.LINE);
        }

        @Override
        public DetailedCell<?> getBranchCoverageDelta() {
            return this.createColoredModifiedLinesCoverageDeltaColumn(Metric.BRANCH);
        }

        DetailedCell<?> createColoredModifiedLinesCoverageDeltaColumn(Metric metric) {
            Coverage modifiedLinesCoverage = (Coverage)this.getFile().getTypedValue(metric, (Value)Coverage.nullObject((Metric)metric));
            if (modifiedLinesCoverage.isSet()) {
                return this.createColoredCoverageDeltaColumn(metric, (Value)modifiedLinesCoverage.subtract(this.originalFile.getTypedValue(metric, (Value)Coverage.nullObject((Metric)metric))));
            }
            return CoverageTableModel.NO_COVERAGE;
        }
    }
}

