/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.source;

import edu.hm.hafner.coverage.FileNode;
import io.jenkins.plugins.coverage.metrics.source.CoverageSourcePrinter;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;

public class VectorCastSourcePrinter
extends CoverageSourcePrinter {
    private static final long serialVersionUID = 7204367145168517936L;
    private final int[] mcdcPairCoveredPerLine;
    private final int[] mcdcPairMissedPerLine;
    private final int[] functionCallCoveredPerLine;
    private final int[] functionCallMissedPerLine;

    VectorCastSourcePrinter(FileNode file) {
        super(file);
        this.mcdcPairCoveredPerLine = file.getMcdcPairCoveredCounters();
        this.mcdcPairMissedPerLine = file.getMcdcPairMissedCounters();
        this.functionCallCoveredPerLine = file.getFunctionCallCoveredCounters();
        this.functionCallMissedPerLine = file.getFunctionCallMissedCounters();
    }

    private String getTr(int line, String sourceCode, boolean isPainted, String third, String fouth) {
        ContainerTag trData = (ContainerTag)((ContainerTag)TagCreator.tr().withClasses(new String[]{isPainted ? this.getColorClass(line) : "noCover", this.getModifiedClass(line)})).condAttr(isPainted, "data-html-tooltip", isPainted ? this.getTooltip(line) : "");
        trData.with(new DomContent[]{((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)((ContainerTag)TagCreator.a().withName(String.valueOf(line))).withText(String.valueOf(line))), ((ContainerTag)TagCreator.td().withClass("hits")).with((DomContent)(isPainted ? TagCreator.text((String)this.getSummaryColumn(line)) : TagCreator.text((String)"")))});
        if (!third.equals("")) {
            trData.with((DomContent)((ContainerTag)TagCreator.td().withClass("hits")).with((DomContent)(isPainted ? TagCreator.text((String)third) : TagCreator.text((String)""))));
        }
        if (!fouth.equals("")) {
            trData.with((DomContent)((ContainerTag)TagCreator.td().withClass("hits")).with((DomContent)(isPainted ? TagCreator.text((String)fouth) : TagCreator.text((String)""))));
        }
        trData.with((DomContent)((ContainerTag)TagCreator.td().withClass("code")).with((DomContent)TagCreator.rawHtml((String)SANITIZER.render(this.cleanupCode(sourceCode)))));
        return trData.render();
    }

    private String getTr(int line, String sourceCode, boolean isPainted) {
        return this.getTr(line, sourceCode, isPainted, "", "");
    }

    private String getTr(int line, String sourceCode, boolean isPainted, String third) {
        return this.getTr(line, sourceCode, isPainted, third, "");
    }

    @Override
    public String renderLine(int line, String sourceCode) {
        boolean isPainted = this.isPainted(line);
        boolean hasMcdc = this.hasAnyMcdcPairCoverage();
        boolean hasFc = this.hasAnyFunctionCallCoverage();
        String trString = !hasMcdc && hasFc ? this.getTr(line, sourceCode, isPainted, this.getFunctionCallSummaryColumn(line)) : (hasMcdc && !hasFc ? this.getTr(line, sourceCode, isPainted, this.getMcdcPairSummaryColumn(line)) : (hasMcdc && hasFc ? this.getTr(line, sourceCode, isPainted, this.getFunctionCallSummaryColumn(line), this.getMcdcPairSummaryColumn(line)) : this.getTr(line, sourceCode, isPainted)));
        return trString;
    }

    private String getColumnHeader(String third) {
        return this.getColumnHeader(third, "&nbsp;");
    }

    private String getColumnHeader(String third, String fourth) {
        return ((ContainerTag)TagCreator.tr().withClass("noCover")).with(new DomContent[]{((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)TagCreator.text((String)"Line")), ((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)TagCreator.text((String)"St/Br")), ((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)TagCreator.text((String)third)), ((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)TagCreator.text((String)fourth)), ((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)TagCreator.text((String)"&nbsp;"))}).render();
    }

    @Override
    public String getColumnHeader() {
        boolean hasMcdc = this.hasAnyMcdcPairCoverage();
        boolean hasFc = this.hasAnyFunctionCallCoverage();
        String trString = !hasMcdc && hasFc ? this.getColumnHeader("FCall") : (hasMcdc && !hasFc ? this.getColumnHeader("MC/DC") : (hasMcdc && hasFc ? this.getColumnHeader("FCall", "MC/DC") : ((ContainerTag)TagCreator.tr().withClass("noCover")).with(new DomContent[]{((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)TagCreator.text((String)"Line ")), ((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)TagCreator.text((String)"St/Br")), ((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)TagCreator.text((String)"&nbsp;"))}).render()));
        return trString;
    }

    @Override
    public String getColorClass(int line) {
        if (this.getCovered(line) == 0 && this.getMcdcPairCovered(line) == 0 && this.getFunctionCallCovered(line) == 0) {
            return "coverNone";
        }
        if (this.getMissed(line) == 0 && this.getMcdcPairMissed(line) == 0 && this.getFunctionCallMissed(line) == 0) {
            return "coverFull";
        }
        return "coverPart";
    }

    public String getMcdcPairTooltip(int line) {
        int mcdcPairCovered = this.getMcdcPairCovered(line);
        int mcdcPairMissed = this.getMcdcPairMissed(line);
        return this.getTooltip(mcdcPairCovered, mcdcPairMissed, false, "MC/DC pairs");
    }

    public String getfunctionCallTooltip(int line) {
        int functionCallCovered = this.getFunctionCallCovered(line);
        int functionCallMissed = this.getFunctionCallMissed(line);
        return this.getTooltip(functionCallCovered, functionCallMissed, true, "Function calls");
    }

    public String getTooltip(int covered, int missed, boolean checkAny, String description) {
        String tooltip = "";
        if (covered + missed > 1) {
            tooltip = missed == 0 ? "All %s covered: %d/%d".formatted(description, covered, covered + missed) : "%s partially covered: %d/%d".formatted(description, covered, covered + missed);
        } else if (checkAny && covered == 1) {
            tooltip = "%s covered".formatted(description);
        }
        return tooltip;
    }

    @Override
    public String getTooltip(int line) {
        Object toolTipString = "";
        String lineBranchToolTipString = super.getTooltip(line);
        String mcdcPairToolTipString = this.getMcdcPairTooltip(line);
        String functionCallToolTipString = this.getfunctionCallTooltip(line);
        if (lineBranchToolTipString.length() > 0) {
            toolTipString = (String)toolTipString + lineBranchToolTipString;
        }
        if (mcdcPairToolTipString.length() > 0) {
            if (((String)toolTipString).length() > 0) {
                toolTipString = (String)toolTipString + " | ";
            }
            toolTipString = (String)toolTipString + mcdcPairToolTipString;
        }
        if (functionCallToolTipString.length() > 0) {
            if (((String)toolTipString).length() > 0) {
                toolTipString = (String)toolTipString + " | ";
            }
            toolTipString = (String)toolTipString + functionCallToolTipString;
        }
        return toolTipString;
    }

    public boolean hasAnyMcdcPairCoverage() {
        boolean hasMcDc = false;
        for (int i = 0; i < this.mcdcPairCoveredPerLine.length && !hasMcDc; ++i) {
            if (this.mcdcPairCoveredPerLine[i] + this.mcdcPairMissedPerLine[i] <= 0) continue;
            hasMcDc = true;
        }
        return hasMcDc;
    }

    public boolean hasAnyFunctionCallCoverage() {
        boolean hasFc = false;
        for (int i = 0; i < this.functionCallMissedPerLine.length && !hasFc; ++i) {
            if (this.functionCallCoveredPerLine[i] + this.functionCallMissedPerLine[i] <= 0) continue;
            hasFc = true;
        }
        return hasFc;
    }

    public int getMcdcPairCovered(int line) {
        return this.getCounter(line, this.mcdcPairCoveredPerLine);
    }

    public int getMcdcPairMissed(int line) {
        return this.getCounter(line, this.mcdcPairMissedPerLine);
    }

    public int getFunctionCallCovered(int line) {
        return this.getCounter(line, this.functionCallCoveredPerLine);
    }

    public int getFunctionCallMissed(int line) {
        return this.getCounter(line, this.functionCallMissedPerLine);
    }

    public String getMcdcPairSummaryColumn(int line) {
        int missed;
        int covered = this.getMcdcPairCovered(line);
        if (covered + (missed = this.getMcdcPairMissed(line)) > 1) {
            return "%d/%d".formatted(covered, covered + missed);
        }
        return String.valueOf(covered);
    }

    public String getFunctionCallSummaryColumn(int line) {
        int missed;
        int covered = this.getFunctionCallCovered(line);
        if (covered + (missed = this.getFunctionCallMissed(line)) > 1) {
            return "%d/%d".formatted(covered, covered + missed);
        }
        return String.valueOf(covered);
    }
}

