/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.source;

import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.util.FilteredLog;
import hudson.FilePath;
import hudson.model.Run;
import hudson.util.TextFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class SourceCodeFacade {
    static final String COVERAGE_SOURCES_DIRECTORY = "coverage-sources";
    static final String COVERAGE_SOURCES_ZIP = "coverage-sources.zip";
    static final int MAX_FILENAME_LENGTH = 245;
    static final String ZIP_FILE_EXTENSION = ".zip";

    static String sanitizeFilename(String inputName) {
        return StringUtils.right((String)inputName.replaceAll("[^a-zA-Z0-9-_.]", "_"), (int)245);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(File buildResults, String id, String path) throws IOException, InterruptedException {
        Path tempDir = Files.createTempDirectory(COVERAGE_SOURCES_DIRECTORY, new FileAttribute[0]);
        FilePath unzippedSourcesDir = new FilePath(tempDir.toFile());
        try {
            FilePath inputZipFile = new FilePath(this.createFileInBuildFolder(buildResults, id, path));
            inputZipFile.unzip(unzippedSourcesDir);
            String actualPaintedSourceFileName = StringUtils.removeEnd((String)SourceCodeFacade.sanitizeFilename(path), (String)ZIP_FILE_EXTENSION);
            File sourceFile = tempDir.resolve(actualPaintedSourceFileName).toFile();
            String string = new TextFile(sourceFile).read();
            return string;
        }
        finally {
            unzippedSourcesDir.deleteRecursive();
        }
    }

    public boolean canRead(File buildResults, String id, String path) {
        return this.createFileInBuildFolder(buildResults, id, path).canRead();
    }

    public boolean hasStoredSourceCode(File buildResults, String id) {
        File sourceFolder = new File(buildResults, COVERAGE_SOURCES_DIRECTORY);
        File elementFolder = new File(sourceFolder, id);
        File[] files = elementFolder.listFiles();
        return files != null && files.length > 0;
    }

    String getCoverageSourcesDirectory() {
        return COVERAGE_SOURCES_DIRECTORY;
    }

    void copySourcesToBuildFolder(Run<?, ?> build, FilePath workspace, FilteredLog log) throws InterruptedException {
        try {
            FilePath buildFolder = new FilePath(build.getRootDir()).child(COVERAGE_SOURCES_DIRECTORY);
            FilePath buildZip = buildFolder.child(COVERAGE_SOURCES_ZIP);
            workspace.child(COVERAGE_SOURCES_ZIP).copyTo(buildZip);
            log.logInfo("-> extracting...");
            buildZip.unzip(buildFolder);
            buildZip.delete();
            log.logInfo("-> done");
        }
        catch (IOException exception) {
            log.logException((Exception)exception, "Can't copy zipped sources from agent to controller", new Object[0]);
        }
    }

    File createFileInBuildFolder(File buildResults, String id, String path) {
        File sourceFolder = new File(buildResults, COVERAGE_SOURCES_DIRECTORY);
        File elementFolder = new File(sourceFolder, id);
        return new File(elementFolder, SourceCodeFacade.sanitizeFilename(path) + ZIP_FILE_EXTENSION);
    }

    public String calculateModifiedLinesCoverageSourceCode(String content, FileNode fileNode) {
        NavigableSet lines = fileNode.getLinesWithCoverage();
        lines.retainAll(fileNode.getModifiedLines());
        Set linesAsText = lines.stream().map(String::valueOf).collect(Collectors.toSet());
        Document doc = Jsoup.parse((String)content, (Parser)Parser.xmlParser());
        int maxLine = Integer.parseInt(Objects.requireNonNull(doc.select("tr").last()).select("a").text());
        Map<String, Boolean> linesMapping = this.calculateLineMapping(lines, maxLine);
        Elements elements = doc.select("tr");
        for (Element element : elements) {
            String line = element.select("td > a").text();
            if (linesMapping.containsKey(line)) {
                if (linesMapping.get(line).booleanValue()) {
                    this.changeCodeToSkipLine(element);
                    continue;
                }
                if (linesAsText.contains(line)) continue;
                element.removeClass(element.className());
                element.addClass("noCover");
                Objects.requireNonNull(element.select("td.hits").first()).text("");
                continue;
            }
            element.remove();
        }
        return doc.html();
    }

    public String calculateIndirectCoverageChangesSourceCode(String content, FileNode fileNode) {
        SortedMap lines = fileNode.getIndirectCoverageChanges();
        Map<String, String> indirectCoverageChangesAsText = lines.entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> String.valueOf(entry.getValue())));
        Document doc = Jsoup.parse((String)content, (Parser)Parser.xmlParser());
        int maxLine = Integer.parseInt(Objects.requireNonNull(doc.select("tr").last()).select("a").text());
        Map<String, Boolean> linesMapping = this.calculateLineMapping(lines.keySet(), maxLine);
        doc.select("tr").forEach(element -> {
            String line = element.select("td > a").text();
            if (linesMapping.containsKey(line)) {
                this.colorIndirectCoverageChangeLine((Element)element, line, linesMapping, indirectCoverageChangesAsText);
            } else {
                element.remove();
            }
        });
        return doc.html();
    }

    private void changeCodeToSkipLine(Element element) {
        element.removeClass(element.className());
        element.addClass("coverSkip");
        Objects.requireNonNull(element.select("td.line").first()).text("..");
        Objects.requireNonNull(element.select("td.hits").first()).text("");
        Objects.requireNonNull(element.select("td.code").first()).text("");
    }

    private void colorIndirectCoverageChangeLine(Element element, String line, Map<String, Boolean> linesMapping, Map<String, String> indirectCoverageChangesAsText) {
        if (linesMapping.get(line).booleanValue()) {
            this.changeCodeToSkipLine(element);
        } else if (indirectCoverageChangesAsText.containsKey(line)) {
            element.removeClass(element.className());
            String hits = indirectCoverageChangesAsText.get(line);
            if (hits.startsWith("-")) {
                element.addClass("coverNone");
            } else {
                element.addClass("coverFull");
            }
            Objects.requireNonNull(element.select("td.hits").first()).text(hits);
        } else {
            element.removeClass(element.className());
            element.addClass("noCover");
            Objects.requireNonNull(element.select("td.hits").first()).text("");
        }
    }

    private Map<String, Boolean> calculateLineMapping(Set<Integer> lines, int maxLine) {
        TreeSet<Integer> linesWithSurroundings = new TreeSet<Integer>(lines);
        lines.forEach(line -> {
            for (int i = 1; i <= 3; ++i) {
                linesWithSurroundings.add(line + i);
                linesWithSurroundings.add(line - i);
            }
        });
        List sortedLines = linesWithSurroundings.stream().filter(line -> line >= 1 && line <= maxLine).collect(Collectors.toList());
        TreeMap<String, Boolean> linesMapping = new TreeMap<String, Boolean>();
        for (int i = 0; i < sortedLines.size(); ++i) {
            int line2 = (Integer)sortedLines.get(i);
            linesMapping.put(String.valueOf(line2), false);
            if (i >= sortedLines.size() - 1 || line2 + 1 == (Integer)sortedLines.get(i + 1)) continue;
            linesMapping.put(String.valueOf(line2 + 1), true);
        }
        int highestLine = (Integer)sortedLines.get(sortedLines.size() - 1);
        if ((Integer)sortedLines.get(0) > 1) {
            linesMapping.put("1", true);
        }
        if (highestLine < maxLine) {
            linesMapping.put(String.valueOf(highestLine + 1), true);
        }
        return linesMapping;
    }
}

