/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.charts;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.line.LinesChartModel;
import edu.hm.hafner.echarts.line.LinesDataSet;
import io.jenkins.plugins.coverage.metrics.charts.CoverageSeriesBuilder;
import io.jenkins.plugins.coverage.metrics.charts.TrendChart;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import io.jenkins.plugins.echarts.JenkinsPalette;
import java.util.Set;

public class MetricsTrendChart
extends TrendChart {
    public MetricsTrendChart(Set<Metric> visibleMetrics, boolean useLines) {
        super(visibleMetrics, useLines);
    }

    @Override
    public LinesChartModel create(Iterable<BuildResult<CoverageStatistics>> results, ChartModelConfiguration configuration) {
        LinesDataSet dataSet = new CoverageSeriesBuilder().createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(dataSet);
        if (dataSet.isNotEmpty()) {
            int colorIndex = 0;
            for (String tag : dataSet.getDataSetIds()) {
                Metric metric = Metric.fromTag((String)tag);
                this.addSeriesIfAvailable(dataSet, model, metric.getDisplayName(), tag, JenkinsPalette.chartColor((int)colorIndex++).normal());
            }
            model.useContinuousRangeAxis();
            model.computeVisibleRange();
        }
        return model;
    }
}

