/*
 * Decompiled with CFR 0.152.
 */
package hpi;

import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class CopyDataToWorkspacePlugin
extends BuildWrapper {
    private String folderPath;
    private boolean makeFilesExecutable;
    private boolean deleteFilesAfterBuild;
    private String[] copiedFiles = new String[0];
    private static final Logger log = Logger.getLogger(CopyDataToWorkspacePlugin.class.getName());

    @DataBoundConstructor
    public CopyDataToWorkspacePlugin(String folderPath, boolean makeFilesExecutable, boolean deleteFilesAfterBuild) {
        this.folderPath = folderPath;
        this.makeFilesExecutable = makeFilesExecutable;
        this.deleteFilesAfterBuild = deleteFilesAfterBuild;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public boolean getMakeFilesExecutable() {
        return this.makeFilesExecutable;
    }

    public boolean getDeleteFilesAfterBuild() {
        return this.deleteFilesAfterBuild;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        log.finest("Recognize project workspace and folder");
        FilePath projectWorkspace = build.getWorkspace();
        Jenkins jenkins = Jenkins.get();
        FilePath jenkinsRoot = jenkins.getRootPath();
        FilePath userContentDir = new FilePath(jenkinsRoot, "userContent");
        FilePath copyFrom = new FilePath(userContentDir, this.folderPath);
        if (!copyFrom.getRemote().startsWith(userContentDir.getRemote() + File.separator) && !copyFrom.getRemote().equals(userContentDir.getRemote())) {
            throw new IOException("The source path must be within the JENKINS_HOME/userContent directory");
        }
        if (!copyFrom.exists()) {
            throw new IOException("The specified source path does not exist: " + copyFrom.getRemote());
        }
        if (copyFrom.containsSymlink(userContentDir, new OpenOption[]{LinkOption.NOFOLLOW_LINKS})) {
            throw new IOException("The specified path contains symlinks which are not allowed for security reasons");
        }
        log.finest("Copying data from " + String.valueOf(copyFrom.toURI()) + " to " + String.valueOf(projectWorkspace.toURI()));
        copyFrom.copyRecursiveTo(projectWorkspace);
        log.finest("Saving names");
        this.saveNames(copyFrom);
        log.finest("Making executable");
        if (this.makeFilesExecutable) {
            this.seeFolder(projectWorkspace);
        }
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                if (CopyDataToWorkspacePlugin.this.deleteFilesAfterBuild) {
                    FilePath projectWorkspace = build.getWorkspace();
                    for (String str : CopyDataToWorkspacePlugin.this.copiedFiles) {
                        log.finest("Deleting file = " + str);
                        FilePath child = new FilePath(projectWorkspace, str);
                        if (child.isDirectory()) {
                            child.deleteRecursive();
                            continue;
                        }
                        child.delete();
                    }
                }
                return true;
            }
        };
    }

    void seeFolder(FilePath path) throws IOException, InterruptedException {
        List children = path.list();
        for (FilePath child : children) {
            if (child.isDirectory()) {
                this.seeFolder(child);
                continue;
            }
            child.chmod(493);
        }
    }

    void saveNames(FilePath path) throws IOException, InterruptedException {
        List children = path.list();
        this.copiedFiles = new String[children.size()];
        int i = 0;
        for (FilePath child : children) {
            this.copiedFiles[i] = child.getName();
            ++i;
            log.finest("Saving name = " + child.getName());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public DescriptorImpl() {
            super(CopyDataToWorkspacePlugin.class);
        }

        @RequirePOST
        public FormValidation doCheckFolderPath(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            if (project != null) {
                project.checkPermission(Item.CONFIGURE);
            }
            return DescriptorImpl.validateFolderPath(value);
        }

        public static FormValidation validateFolderPath(String value) {
            String[] parts;
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"Path cannot be empty");
            }
            String normalized = value.replace('\\', '/').trim();
            for (String part : parts = normalized.split("/")) {
                if (!part.equals("..")) continue;
                return FormValidation.error((String)"Path traversal .. is not allowed");
            }
            if (normalized.startsWith("~/") || normalized.equals("~")) {
                return FormValidation.error((String)"Leading ~ is not allowed");
            }
            if (Functions.isWindows()) {
                if (normalized.matches("^[A-Za-z]:.*") || normalized.startsWith("//")) {
                    return FormValidation.error((String)"Absolute paths are not allowed");
                }
                if (normalized.matches(".*[<>:\"|?*].*")) {
                    return FormValidation.error((String)"Invalid Windows characters: <, >, :, \", |, ?, *");
                }
            } else {
                if (normalized.startsWith("/")) {
                    return FormValidation.error((String)"Absolute paths are not allowed");
                }
                if (normalized.chars().anyMatch(Character::isISOControl)) {
                    return FormValidation.error((String)"Control characters are not allowed");
                }
            }
            return FormValidation.ok();
        }

        public String getDisplayName() {
            return "Copy data to workspace";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public BuildWrapper newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            String folderPath = formData.getString("folderPath");
            FormValidation validation = DescriptorImpl.validateFolderPath(folderPath);
            if (validation.kind == FormValidation.Kind.ERROR) {
                throw new Descriptor.FormException(validation.getMessage(), "folderPath");
            }
            return (BuildWrapper)super.newInstance(req, formData);
        }
    }
}

