/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.PartialFunction;
import io.vavr.Tuple2;
import io.vavr.collection.GwtIncompatible;
import io.vavr.collection.Iterator;
import io.vavr.collection.LinearSeqModule;
import io.vavr.collection.Map;
import io.vavr.collection.Seq;
import io.vavr.control.Option;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.jspecify.annotations.NonNull;

public interface LinearSeq<T>
extends Seq<T> {
    public static final long serialVersionUID = 1L;

    public static <T> LinearSeq<T> narrow(LinearSeq<? extends T> linearSeq) {
        return linearSeq;
    }

    @Override
    public LinearSeq<T> append(T var1);

    @Override
    public LinearSeq<T> appendAll(@NonNull Iterable<? extends T> var1);

    @Override
    @GwtIncompatible
    public LinearSeq<T> asJava(@NonNull Consumer<? super List<T>> var1);

    @Override
    @GwtIncompatible
    public LinearSeq<T> asJavaMutable(@NonNull Consumer<? super List<T>> var1);

    @Override
    default public PartialFunction<Integer, T> asPartialFunction() throws IndexOutOfBoundsException {
        return new PartialFunction<Integer, T>(){
            private static final long serialVersionUID = 1L;

            @Override
            public T apply(Integer index) {
                return LinearSeq.this.get(index);
            }

            @Override
            public boolean isDefinedAt(Integer index) {
                return 0 <= index && LinearSeq.this.drop(index).nonEmpty();
            }
        };
    }

    @Override
    public <R> LinearSeq<R> collect(@NonNull PartialFunction<? super T, ? extends R> var1);

    public LinearSeq<? extends LinearSeq<T>> combinations();

    public LinearSeq<? extends LinearSeq<T>> combinations(int var1);

    @Override
    public Iterator<? extends LinearSeq<T>> crossProduct(int var1);

    @Override
    public LinearSeq<T> distinct();

    @Override
    public LinearSeq<T> distinctBy(@NonNull Comparator<? super T> var1);

    @Override
    public <U> LinearSeq<T> distinctBy(@NonNull Function<? super T, ? extends U> var1);

    @Override
    public LinearSeq<T> distinctByKeepLast(@NonNull Comparator<? super T> var1);

    @Override
    public <U> LinearSeq<T> distinctByKeepLast(@NonNull Function<? super T, ? extends U> var1);

    @Override
    public LinearSeq<T> drop(int var1);

    @Override
    public LinearSeq<T> dropUntil(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> dropWhile(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> dropRight(int var1);

    @Override
    public LinearSeq<T> dropRightUntil(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> dropRightWhile(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> filter(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> reject(@NonNull Predicate<? super T> var1);

    @Override
    public <U> LinearSeq<U> flatMap(@NonNull Function<? super T, ? extends Iterable<? extends U>> var1);

    @Override
    public <C> Map<C, ? extends LinearSeq<T>> groupBy(@NonNull Function<? super T, ? extends C> var1);

    @Override
    public Iterator<? extends LinearSeq<T>> grouped(int var1);

    @Override
    default public int indexOfSlice(@NonNull Iterable<? extends T> that, int from) {
        Objects.requireNonNull(that, "that is null");
        return LinearSeqModule.Slice.indexOfSlice(this, that, from);
    }

    @Override
    default public int indexWhere(@NonNull Predicate<? super T> predicate, int from) {
        Objects.requireNonNull(predicate, "predicate is null");
        int i = from;
        Seq these = this.drop(from);
        while (!these.isEmpty()) {
            if (predicate.test(these.head())) {
                return i;
            }
            ++i;
            these = these.tail();
        }
        return -1;
    }

    @Override
    public LinearSeq<T> init();

    @Override
    public Option<? extends LinearSeq<T>> initOption();

    @Override
    public LinearSeq<T> insert(int var1, T var2);

    @Override
    public LinearSeq<T> insertAll(int var1, @NonNull Iterable<? extends T> var2);

    @Override
    public LinearSeq<T> intersperse(T var1);

    @Override
    @Deprecated
    default public boolean isDefinedAt(Integer index) {
        return 0 <= index && this.drop(index).nonEmpty();
    }

    @Override
    default public int lastIndexOfSlice(@NonNull Iterable<? extends T> that, int end) {
        Objects.requireNonNull(that, "that is null");
        return LinearSeqModule.Slice.lastIndexOfSlice(this, that, end);
    }

    @Override
    default public int lastIndexWhere(@NonNull Predicate<? super T> predicate, int end) {
        Objects.requireNonNull(predicate, "predicate is null");
        Seq<T> these = this;
        int last = -1;
        for (int i = 0; !these.isEmpty() && i <= end; ++i) {
            if (predicate.test(these.head())) {
                last = i;
            }
            these = these.tail();
        }
        return last;
    }

    @Override
    public <U> LinearSeq<U> map(@NonNull Function<? super T, ? extends U> var1);

    @Override
    default public <U> LinearSeq<U> mapTo(U value) {
        return this.map((T ignored) -> value);
    }

    @Override
    default public LinearSeq<Void> mapToVoid() {
        return this.map((T ignored) -> null);
    }

    @Override
    public LinearSeq<T> orElse(@NonNull Iterable<? extends T> var1);

    @Override
    public LinearSeq<T> orElse(@NonNull Supplier<? extends Iterable<? extends T>> var1);

    @Override
    public LinearSeq<T> padTo(int var1, T var2);

    @Override
    public LinearSeq<T> patch(int var1, @NonNull Iterable<? extends T> var2, int var3);

    @Override
    public Tuple2<? extends LinearSeq<T>, ? extends LinearSeq<T>> partition(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> peek(@NonNull Consumer<? super T> var1);

    public LinearSeq<? extends LinearSeq<T>> permutations();

    @Override
    public LinearSeq<T> prepend(T var1);

    @Override
    public LinearSeq<T> prependAll(@NonNull Iterable<? extends T> var1);

    @Override
    public LinearSeq<T> remove(T var1);

    @Override
    public LinearSeq<T> removeFirst(@NonNull Predicate<T> var1);

    @Override
    public LinearSeq<T> removeLast(@NonNull Predicate<T> var1);

    @Override
    public LinearSeq<T> removeAt(int var1);

    @Override
    public LinearSeq<T> removeAll(T var1);

    @Override
    public LinearSeq<T> removeAll(@NonNull Iterable<? extends T> var1);

    @Override
    @Deprecated
    public LinearSeq<T> removeAll(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> replace(T var1, T var2);

    @Override
    public LinearSeq<T> replaceAll(T var1, T var2);

    @Override
    public LinearSeq<T> retainAll(@NonNull Iterable<? extends T> var1);

    @Override
    public LinearSeq<T> reverse();

    @Override
    default public Iterator<T> reverseIterator() {
        return this.reverse().iterator();
    }

    @Override
    public LinearSeq<T> rotateLeft(int var1);

    @Override
    public LinearSeq<T> rotateRight(int var1);

    @Override
    public LinearSeq<T> shuffle();

    @Override
    public LinearSeq<T> scan(T var1, @NonNull BiFunction<? super T, ? super T, ? extends T> var2);

    @Override
    public <U> LinearSeq<U> scanLeft(U var1, @NonNull BiFunction<? super U, ? super T, ? extends U> var2);

    @Override
    public <U> LinearSeq<U> scanRight(U var1, @NonNull BiFunction<? super T, ? super U, ? extends U> var2);

    @Override
    default public int segmentLength(@NonNull Predicate<? super T> predicate, int from) {
        Objects.requireNonNull(predicate, "predicate is null");
        int i = 0;
        Seq these = this.drop(from);
        while (!these.isEmpty() && predicate.test(these.head())) {
            ++i;
            these = these.tail();
        }
        return i;
    }

    @Override
    public LinearSeq<T> slice(int var1, int var2);

    @Override
    public Iterator<? extends LinearSeq<T>> slideBy(@NonNull Function<? super T, ?> var1);

    @Override
    public Iterator<? extends LinearSeq<T>> sliding(int var1);

    @Override
    public Iterator<? extends LinearSeq<T>> sliding(int var1, int var2);

    @Override
    public LinearSeq<T> sorted();

    @Override
    public LinearSeq<T> sorted(@NonNull Comparator<? super T> var1);

    @Override
    public <U extends Comparable<? super U>> LinearSeq<T> sortBy(@NonNull Function<? super T, ? extends U> var1);

    @Override
    public <U> LinearSeq<T> sortBy(@NonNull Comparator<? super U> var1, Function<? super T, ? extends U> var2);

    @Override
    public Tuple2<? extends LinearSeq<T>, ? extends LinearSeq<T>> span(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> subSequence(int var1);

    @Override
    public LinearSeq<T> subSequence(int var1, int var2);

    @Override
    public LinearSeq<T> tail();

    @Override
    public Option<? extends LinearSeq<T>> tailOption();

    @Override
    public LinearSeq<T> take(int var1);

    @Override
    public LinearSeq<T> takeUntil(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> takeWhile(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> takeRight(int var1);

    @Override
    public LinearSeq<T> takeRightUntil(@NonNull Predicate<? super T> var1);

    @Override
    public LinearSeq<T> takeRightWhile(@NonNull Predicate<? super T> var1);

    @Override
    public <T1, T2> Tuple2<? extends LinearSeq<T1>, ? extends LinearSeq<T2>> unzip(@NonNull Function<? super T, Tuple2<? extends T1, ? extends T2>> var1);

    @Override
    public LinearSeq<T> update(int var1, T var2);

    @Override
    public LinearSeq<T> update(int var1, @NonNull Function<? super T, ? extends T> var2);

    @Override
    public <U> LinearSeq<Tuple2<T, U>> zip(@NonNull Iterable<? extends U> var1);

    @Override
    public <U, R> LinearSeq<R> zipWith(@NonNull Iterable<? extends U> var1, BiFunction<? super T, ? super U, ? extends R> var2);

    @Override
    public <U> LinearSeq<Tuple2<T, U>> zipAll(@NonNull Iterable<? extends U> var1, T var2, U var3);

    @Override
    public LinearSeq<Tuple2<T, Integer>> zipWithIndex();

    @Override
    public <U> LinearSeq<U> zipWithIndex(@NonNull BiFunction<? super T, ? super Integer, ? extends U> var1);

    @Override
    default public int search(T element) {
        ToIntFunction<Object> comparison = ((Comparable)element)::compareTo;
        return LinearSeqModule.Search.linearSearch(this, comparison);
    }

    @Override
    default public int search(T element, @NonNull Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        ToIntFunction<Object> comparison = current -> comparator.compare(element, current);
        return LinearSeqModule.Search.linearSearch(this, comparison);
    }
}

