/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc.model;

import io.jenkins.plugins.casc.ConfiguratorException;
import io.jenkins.plugins.casc.model.Mapping;
import io.jenkins.plugins.casc.model.Scalar;
import io.jenkins.plugins.casc.model.Sequence;
import io.jenkins.plugins.casc.model.Source;

public interface CNode
extends Cloneable {
    public Type getType();

    default public Mapping asMapping() throws ConfiguratorException {
        throw new ConfiguratorException("Item isn't a Mapping" + this.getSourceLocation());
    }

    default public Sequence asSequence() throws ConfiguratorException {
        throw new ConfiguratorException("Item isn't a Sequence" + this.getSourceLocation());
    }

    default public Scalar asScalar() throws ConfiguratorException {
        throw new ConfiguratorException("Item isn't a Scalar" + this.getSourceLocation());
    }

    @Deprecated
    default public boolean isSensitiveData() {
        return false;
    }

    default public boolean isPrintableWhenEmpty() {
        return false;
    }

    public Source getSource();

    default public String getSourceLocation() {
        Source s = this.getSource();
        return s != null ? " " + String.valueOf(s) : "";
    }

    public CNode clone();

    public static enum Type {
        MAPPING,
        SEQUENCE,
        SCALAR;

    }
}

