/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.casc;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import io.jenkins.plugins.casc.Configurator;
import io.jenkins.plugins.casc.model.CNode;
import io.jenkins.plugins.casc.model.Source;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;

public class ConfiguratorException
extends RuntimeException {
    @CheckForNull
    private final Configurator configurator;
    private final List<String> validAttributes;
    @CheckForNull
    private final String invalidAttribute;
    @CheckForNull
    private final Source source;
    @CheckForNull
    private final String path;

    private ConfiguratorException(@CheckForNull Configurator configurator, @CheckForNull String message, @CheckForNull String invalidAttribute, List<String> validAttributes, @CheckForNull Throwable cause, @CheckForNull Source source, @CheckForNull String path) {
        super(message, cause);
        this.configurator = configurator;
        this.invalidAttribute = invalidAttribute;
        this.validAttributes = validAttributes == null ? Collections.emptyList() : validAttributes;
        this.source = source;
        this.path = path;
    }

    public static ConfiguratorException from(CNode node, String message) {
        return new ConfiguratorException(null, message, null, Collections.emptyList(), null, node != null ? node.getSource() : null, null);
    }

    public static ConfiguratorException from(CNode node, String message, Throwable cause) {
        return new ConfiguratorException(null, message, null, Collections.emptyList(), cause, node != null ? node.getSource() : null, null);
    }

    public static ConfiguratorException from(CNode node, Configurator configurator, String path, String message, Throwable cause) {
        Source source;
        Source source2 = source = node != null ? node.getSource() : null;
        if (source == null && cause instanceof ConfiguratorException) {
            source = ((ConfiguratorException)cause).getSource();
        }
        return new ConfiguratorException(configurator, message, null, Collections.emptyList(), cause, source, path);
    }

    public ConfiguratorException(@CheckForNull String message) {
        this(null, message, null, Collections.emptyList(), null);
    }

    public ConfiguratorException(@CheckForNull String message, @CheckForNull Throwable cause) {
        this(null, message, null, Collections.emptyList(), cause, null, null);
    }

    public ConfiguratorException(@CheckForNull Configurator configurator, @CheckForNull String message) {
        this(configurator, message, null, Collections.emptyList(), null, null, null);
    }

    public ConfiguratorException(@CheckForNull Configurator configurator, @CheckForNull String message, @CheckForNull Throwable cause) {
        this(configurator, message, null, Collections.emptyList(), cause, null, null);
    }

    public ConfiguratorException(@CheckForNull Configurator configurator, @CheckForNull String message, String invalidAttribute, List<String> validAttributes, @CheckForNull Throwable cause) {
        this(configurator, message, invalidAttribute, validAttributes, cause, null, null);
    }

    @CheckForNull
    public Configurator getConfigurator() {
        return this.configurator;
    }

    public List<String> getValidAttributes() {
        return this.validAttributes;
    }

    @CheckForNull
    public String getInvalidAttribute() {
        return this.invalidAttribute;
    }

    @CheckForNull
    public Source getSource() {
        return this.source;
    }

    @CheckForNull
    public String getPath() {
        return this.path;
    }

    public String getErrorMessage() {
        return super.getMessage();
    }

    @Override
    public String getMessage() {
        String base;
        String string = this.configurator != null ? String.format("%s: %s", Jenkins.getInstanceOrNull() == null ? this.configurator.getClass() : this.configurator.getName(), super.getMessage()) : (base = super.getMessage());
        if (this.source == null && this.path == null) {
            return base;
        }
        StringBuilder sb = new StringBuilder(base);
        sb.append(System.lineSeparator()).append("  at ");
        if (this.source != null) {
            sb.append(this.source);
        } else {
            sb.append("unknown source");
        }
        if (this.path != null) {
            sb.append(" (path: ").append(this.path).append(")");
        }
        return sb.toString();
    }
}

