/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.security;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.DomainSpecificationDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.Util;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.jenkinsci.plugins.configfiles.Messages;
import org.jenkinsci.plugins.configfiles.maven.security.MavenServerIdRequirement;
import org.kohsuke.stapler.DataBoundConstructor;

public class MavenServerIdSpecification
extends DomainSpecification {
    @CheckForNull
    private final String includes;
    @CheckForNull
    private final String excludes;

    @DataBoundConstructor
    public MavenServerIdSpecification(String includes, String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getIncludes() {
        return this.includes;
    }

    public DomainSpecification.Result test(DomainRequirement requirement) {
        if (requirement instanceof MavenServerIdRequirement) {
            String serverId = ((MavenServerIdRequirement)requirement).getServerId();
            if (this.includes != null) {
                boolean isInclude = false;
                for (String include : this.includes.split("[,\\n ]")) {
                    if ((include = Util.fixEmptyAndTrim((String)include)) == null || !FilenameUtils.wildcardMatch((String)serverId, (String)include, (IOCase)IOCase.INSENSITIVE)) continue;
                    isInclude = true;
                    break;
                }
                if (!isInclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            if (this.excludes != null) {
                boolean isExclude = false;
                for (String exclude : this.excludes.split("[,\\n ]")) {
                    if ((exclude = Util.fixEmptyAndTrim((String)exclude)) == null || !FilenameUtils.wildcardMatch((String)serverId, (String)exclude, (IOCase)IOCase.INSENSITIVE)) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            return DomainSpecification.Result.PARTIAL;
        }
        return DomainSpecification.Result.UNKNOWN;
    }

    @Extension
    public static class DescriptorImpl
    extends DomainSpecificationDescriptor {
        public String getDisplayName() {
            return Messages.MavenServerIdSpecification_displayname();
        }
    }
}

