/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.configprovider;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ReflectionUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.configprovider.model.Config;
import org.jenkinsci.lib.configprovider.model.ContentType;
import org.jenkinsci.plugins.configfiles.GlobalConfigFiles;

public abstract class ConfigProvider
extends Descriptor<Config>
implements ExtensionPoint {
    public static ExtensionList<ConfigProvider> all() {
        return Jenkins.get().getExtensionList(ConfigProvider.class);
    }

    @CheckForNull
    public static ConfigProvider getByIdOrNull(@Nullable String providerId) {
        if (providerId == null || providerId.isEmpty()) {
            return null;
        }
        for (ConfigProvider provider : ConfigProvider.all()) {
            if (!providerId.equals(provider.getProviderId())) continue;
            return provider;
        }
        return null;
    }

    public abstract ContentType getContentType();

    public abstract String getProviderId();

    @Deprecated
    public Config newConfig() {
        String id = this.getProviderId() + "." + System.currentTimeMillis();
        return this.newConfig(id);
    }

    @NonNull
    public Config newConfig(@NonNull String id) {
        throw new AbstractMethodError(String.valueOf(((Object)((Object)this)).getClass()) + " MUST implement 'newConfig(String)'");
    }

    public Config newConfig(@NonNull String id, String name, String comment, String content) {
        Config config = this.newConfig(id);
        this.setField("name", name, config);
        this.setField("comment", comment, config);
        this.setField("content", content, config);
        config.setProviderId(this.getProviderId());
        return config;
    }

    private void setField(String fieldName, String value, Config config) {
        Field field = ReflectionUtils.findField(config.getClass(), (String)fieldName);
        if (field != null) {
            field.setAccessible(true);
            ReflectionUtils.setField((Field)field, (Object)config, (Object)value);
        }
    }

    public abstract void clearOldDataStorage();

    public boolean supportsFolder() {
        return true;
    }

    @Deprecated
    public Collection<Config> getAllConfigs() {
        return GlobalConfigFiles.get().getConfigs(((Object)((Object)this)).getClass());
    }

    @Deprecated
    public Config getConfigById(String configId) {
        return GlobalConfigFiles.get().getById(configId);
    }

    @Deprecated
    public boolean configExists(String configId) {
        return GlobalConfigFiles.get().getById(configId) != null;
    }

    @Deprecated
    public void remove(String configId) {
        GlobalConfigFiles.get().remove(configId);
        this.save();
    }

    @Deprecated
    public void save(Config config) {
        GlobalConfigFiles.get().save(config);
        this.save();
    }

    @CheckForNull
    public String supplyContent(@NonNull Config configFile, Run<?, ?> build, FilePath workDir, TaskListener listener, @NonNull List<String> tempFiles) throws IOException {
        return configFile.content;
    }

    @NonNull
    public List<String> getSensitiveContentForMasking(Config configFile, Run<?, ?> build) {
        return Collections.emptyList();
    }
}

