/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.collapsingconsolesections;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.lang.reflect.Array;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jvnet.hudson.plugins.collapsingconsolesections.CollapsingSectionsConfiguration;
import org.jvnet.hudson.plugins.collapsingconsolesections.SectionDefinition;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class CollapsingSectionNote
extends ConsoleNote {
    @Nonnull
    private String sectionDisplayName;
    @Nonnull
    private String sectionStartPattern;
    @Nonnull
    private String sectionEndPattern;
    private boolean collapseOnlyOneLevel;
    private boolean collapseSection;

    @DataBoundConstructor
    public CollapsingSectionNote(@Nonnull String sectionDisplayName, @Nonnull String sectionStartPattern, @Nonnull String sectionEndPattern, boolean collapseOnlyOneLevel, boolean collapseSection) {
        this.sectionDisplayName = sectionDisplayName;
        this.sectionStartPattern = sectionStartPattern;
        this.sectionEndPattern = sectionEndPattern;
        this.collapseOnlyOneLevel = collapseOnlyOneLevel;
        this.collapseSection = collapseSection;
    }

    @Deprecated
    public CollapsingSectionNote(String sectionDisplayName, String sectionStartPattern, String sectionEndPattern, boolean collapseOnlyOneLevel) {
        this(sectionDisplayName, sectionStartPattern, sectionEndPattern, collapseOnlyOneLevel, false);
    }

    @Nonnull
    public String getSectionDisplayName() {
        return this.sectionDisplayName;
    }

    @Nonnull
    public String getSectionStartPattern() {
        return this.sectionStartPattern;
    }

    @Nonnull
    public String getSectionEndPattern() {
        return this.sectionEndPattern;
    }

    public boolean isCollapseSection() {
        return this.collapseSection;
    }

    public boolean isCollapseOnlyOneLevel() {
        return this.collapseOnlyOneLevel;
    }

    @Nonnull
    public SectionDefinition getDefinition() {
        return new SectionDefinition(this.sectionDisplayName, this.sectionStartPattern, this.sectionEndPattern, this.collapseOnlyOneLevel, this.collapseSection);
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
        return null;
    }

    @Extension
    public static final class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        @CheckForNull
        private CollapsingSectionNote[] sections;
        private boolean numberingEnabled;
        @Nonnull
        private transient CollapsingSectionsConfiguration configuration;

        @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="configuration is always initialized in load()")
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Console Section";
        }

        @Nonnull
        public CollapsingSectionNote[] getSections() {
            if (this.sections != null) {
                return (CollapsingSectionNote[])this.sections.clone();
            }
            return new CollapsingSectionNote[0];
        }

        @Nonnull
        public SectionDefinition[] getSectionDefinitions() {
            return this.configuration.getSectionDefinitions();
        }

        public void setSections(CollapsingSectionNote ... sections) {
            this.sections = (CollapsingSectionNote[])sections.clone();
        }

        public boolean isNumberingEnabled() {
            return this.numberingEnabled;
        }

        @Nonnull
        public CollapsingSectionsConfiguration getConfiguration() {
            return this.configuration;
        }

        public synchronized void load() {
            super.load();
            this.configuration = new CollapsingSectionsConfiguration(this.sections, this.numberingEnabled);
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            this.setSections(req.bindJSONToList(this.clazz, json.get("consolesection")).toArray((CollapsingSectionNote[])Array.newInstance(this.clazz, 0)));
            this.numberingEnabled = json.getBoolean("numberingEnabled");
            this.configuration = new CollapsingSectionsConfiguration(this.sections, this.numberingEnabled);
            this.save();
            return true;
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckSectionStartPattern(@QueryParameter String sectionStartPattern) {
            try {
                Pattern.compile(sectionStartPattern);
            }
            catch (PatternSyntaxException exception) {
                return FormValidation.error((String)exception.getDescription());
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckSectionEndPattern(@QueryParameter String sectionEndPattern) {
            return this.doCheckSectionStartPattern(sectionEndPattern);
        }
    }
}

