/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.spi.lang;

import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.reporters.html.source.SourceRenderHelper;
import java.text.MessageFormat;
import java.util.Locale;

public interface LanguageConstruct {
    public String getId();

    public String calcCoverageMsg(SourceInfo var1, int var2, int var3, Locale var4);

    public static enum Builtin implements LanguageConstruct
    {
        METHOD("()", "method {2,choice,0#not entered|1#entered {2,number,integer} time|1<entered {2,number,integer} times}."),
        STATEMENT(";", "statement {2,choice,0#not executed|1#executed 1 time|1<executed {2,number,integer} times}."),
        BRANCH("?", "true branch executed {2} {2,choice,0#times|1#time|1<times}, false branch executed {3} {3,choice,0#times|1#time|1<times}."),
        GROOVY_FIELD_EXPRESSION("=", "field {2,choice,0#not initialised|1#initialised 1 time|1<initialised {2,number,integer} times}."),
        GROOVY_SAFE_METHOD("?()", "safe method call had non-null target {2} {2,choice,0#times|1#time|1<times}, had null target {3} {3,choice,0#times|1#time|1<times}."),
        GROOVY_SAFE_PROPERTY("?P", "safe property call had non-null target {2} {2,choice,0#times|1#time|1<times}, had null target {3} {3,choice,0#times|1#time|1<times}."),
        GROOVY_SAFE_ATTRIBUTE("?A", "safe attribute call had non-null target {2} {2,choice,0#times|1#time|1<times}, had null target {3} {3,choice,0#times|1#time|1<times}."),
        GROOVY_ELVIS_OPERATOR("?:", "elvis expression defaulted {2} {2,choice,0#times|1#time|1<times}, evaluated alternate expression  {3} {3,choice,0#times|1#time|1<times}.");

        private final String id;
        private final MessageFormat msgFormat;

        private Builtin(String id, String msgFormat) {
            this.id = id;
            this.msgFormat = new MessageFormat(msgFormat);
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String calcCoverageMsg(SourceInfo sourceRegion, int trueBranchCount, int falseBranchCount, Locale locale) {
            return String.valueOf(SourceRenderHelper.getRegionStartStr(sourceRegion)) + this.msgFormat.format(new Object[]{sourceRegion.getStartLine(), sourceRegion.getStartColumn(), trueBranchCount, falseBranchCount});
        }
    }
}

