/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.util;

import com.atlassian.clover.Logger;
import java.net.URI;
import java.util.Arrays;

public class BrowserLaunch {
    private static final String[] BROWSERS = new String[]{"google-chrome", "firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla"};
    private static final String ERROR_MSG = "Error attempting to launch web browser";

    public static void openURL(String url) {
        try {
            Class<?> d = Class.forName("java.awt.Desktop");
            d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(url));
        }
        catch (Exception exception) {
            String osName = System.getProperty("os.name");
            try {
                if (osName.startsWith("Mac OS")) {
                    Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                } else if (osName.startsWith("Windows")) {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                } else {
                    boolean found = false;
                    String[] stringArray = BROWSERS;
                    int n = BROWSERS.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String browser = stringArray[n2];
                        if (!found) {
                            boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0;
                            if (found) {
                                Runtime.getRuntime().exec(new String[]{browser, url});
                            }
                        }
                        ++n2;
                    }
                    if (!found) {
                        throw new Exception(Arrays.toString(BROWSERS));
                    }
                }
            }
            catch (Exception e) {
                Logger.getInstance().debug(ERROR_MSG, e);
                Logger.getInstance().info(ERROR_MSG);
            }
        }
    }
}

