/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters;

import com.atlassian.clover.Logger;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.filters.AntPatternTestFilter;
import com.atlassian.clover.util.FilterUtils;

public class TestSelectionHelper {
    public static final String TESTS_INCLUDE_PATTERN_PARAM = "--testsIncludePattern";
    public static final String TESTS_EXCLUDE_PATTERN_PARAM = "--testsExcludePattern";
    public static final String SOURCE_ROOT_PARAM = "--sourceRoot";

    private TestSelectionHelper() {
    }

    public static String getParamsUsage() {
        return "         --testsIncludePattern <string>\tAnt-style pattern of files containing test classes and utilities.\n\t\t\t\tIf unspecified Clover uses default test detection logic.\n\n         --testsExcludePattern <string>\tAnt-style pattern of files NOT containing test classes and utilities.\n\n         --sourceRoot <string>\tSource root path prefix that will be ignored when evaluating the test inclusion patterns.\n\n";
    }

    public static void configureTestSelectionFilter(Current cfg, String[] args) {
        String includeFilter = null;
        String excludeFilter = null;
        String sourceRoot = null;
        int i = 0;
        while (i < args.length) {
            switch (args[i]) {
                case "--testsIncludePattern": {
                    includeFilter = args[++i];
                    break;
                }
                case "--testsExcludePattern": {
                    excludeFilter = args[++i];
                    break;
                }
                case "--sourceRoot": {
                    sourceRoot = args[++i];
                }
            }
            ++i;
        }
        if (includeFilter == null && excludeFilter == null) {
            return;
        }
        String[] includes = includeFilter == null ? new String[]{} : FilterUtils.tokenizePattern(includeFilter);
        String[] excludes = excludeFilter == null ? new String[]{} : FilterUtils.tokenizePattern(excludeFilter);
        AntPatternTestFilter filter = new AntPatternTestFilter(sourceRoot, includes, excludes);
        cfg.setTestFilter(filter);
        Logger.getInstance().verbose("Setting up Ant-pattern based test filter.");
    }
}

