/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters;

import clover.antlr.CommonAST;
import clover.antlr.RecognitionException;
import clover.antlr.TokenStreamException;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.BlockMetrics;
import com.atlassian.clover.reporters.CalcLexer;
import com.atlassian.clover.reporters.CalcParser;
import com.atlassian.clover.reporters.CalcTreeWalker;
import java.io.ByteArrayInputStream;

public class ExpressionEvaluator {
    public static double eval(String expr, BlockMetrics metrics, String title) throws CloverException {
        CalcParser parser = ExpressionEvaluator.parse(expr, title);
        CommonAST t = (CommonAST)parser.getAST();
        if (Logger.isDebug()) {
            Logger.getInstance().debug(t.toStringTree());
        }
        CalcTreeWalker walker = new CalcTreeWalker();
        try {
            return walker.expr(t, metrics);
        }
        catch (RecognitionException e) {
            Logger.getInstance().debug(e.getMessage(), e);
            throw ExpressionEvaluator.wrapException(expr, e);
        }
    }

    public static CalcParser parse(String expr, String title) throws CloverException {
        ByteArrayInputStream in = new ByteArrayInputStream(expr.getBytes());
        CalcLexer lexer = new CalcLexer(in);
        lexer.setFilename(title);
        CalcParser parser = new CalcParser(lexer);
        parser.setFilename(title);
        try {
            parser.expr();
            return parser;
        }
        catch (RecognitionException | TokenStreamException e) {
            Logger.getInstance().debug(e.getMessage(), e);
            throw ExpressionEvaluator.wrapException(expr, e);
        }
    }

    public static void validate(String expr, String title) throws CloverException {
        try {
            new CalcTreeWalker().validate(ExpressionEvaluator.parse(expr, title).getAST());
        }
        catch (RecognitionException e) {
            Logger.getInstance().debug(e.getMessage(), e);
            throw ExpressionEvaluator.wrapException(expr, e);
        }
    }

    private static CloverException wrapException(String expr, Exception e) {
        return new CloverException(String.valueOf(e.getMessage()) + " in expression '" + expr + "'", e);
    }
}

