/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.api.registry.EntityContainer;
import com.atlassian.clover.api.registry.EntityVisitor;
import com.atlassian.clover.api.registry.FileInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentEntity {
    private final EntityContainer parentEntity;
    private FileInfo containingFile;

    public ParentEntity(@NotNull ClassInfo containingClass) {
        this(containingClass, null);
    }

    public ParentEntity(@NotNull MethodInfo containingMethod) {
        this(containingMethod, null);
    }

    public ParentEntity(@NotNull FileInfo containingFile) {
        this(containingFile, containingFile);
    }

    public ParentEntity(@NotNull EntityContainer parentEntity, @Nullable FileInfo containingFile) {
        this.parentEntity = parentEntity;
        this.containingFile = containingFile;
    }

    @Nullable
    public ClassInfo getContainingClass() {
        ParentClassExtractor callback = new ParentClassExtractor();
        this.parentEntity.visit(callback);
        return callback.getClassInfo();
    }

    @Nullable
    public FileInfo getContainingFile() {
        FileExtractor callback = new FileExtractor();
        this.parentEntity.visit(callback);
        return callback.getFileInfo() != null ? callback.getFileInfo() : this.containingFile;
    }

    @Nullable
    public MethodInfo getContainingMethod() {
        ParentMethodExtractor callback = new ParentMethodExtractor();
        this.parentEntity.visit(callback);
        return callback.getMethodInfo();
    }

    @NotNull
    public EntityContainer getParentEntity() {
        return this.parentEntity;
    }

    public void setContainingFile(@NotNull FullFileInfo fileInfo) {
        this.containingFile = fileInfo;
    }

    private static class FileExtractor
    extends EntityVisitor {
        FileInfo fileInfo = null;

        private FileExtractor() {
        }

        @Override
        public void visitClass(ClassInfo parentClass) {
            this.fileInfo = parentClass.getContainingFile();
        }

        @Override
        public void visitFile(FileInfo parentFile) {
            this.fileInfo = parentFile;
        }

        @Override
        public void visitMethod(MethodInfo parentMethod) {
            this.fileInfo = parentMethod.getContainingFile();
        }

        @Nullable
        public FileInfo getFileInfo() {
            return this.fileInfo;
        }
    }

    private static class ParentClassExtractor
    extends EntityVisitor {
        ClassInfo cls = null;

        private ParentClassExtractor() {
        }

        @Override
        public void visitClass(ClassInfo parentClass) {
            this.cls = parentClass;
        }

        @Nullable
        public ClassInfo getClassInfo() {
            return this.cls;
        }
    }

    private static class ParentMethodExtractor
    extends EntityVisitor {
        MethodInfo methodInfo = null;

        private ParentMethodExtractor() {
        }

        @Override
        public void visitMethod(MethodInfo parentMethod) {
            this.methodInfo = parentMethod;
        }

        @Nullable
        public MethodInfo getMethodInfo() {
            return this.methodInfo;
        }
    }
}

