/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry;

import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import java.io.IOException;
import java.util.Comparator;

public class FixedSourceRegion
implements SourceInfo,
TaggedPersistent {
    protected final int startLine;
    protected final int startColumn;
    protected final int endLine;
    protected final int endColumn;
    public static final Comparator<SourceInfo> SOURCE_ORDER_COMP = new RegionStartComparator();

    public FixedSourceRegion(int startLine, int startColumn) {
        this(startLine, startColumn, startLine, startColumn);
    }

    public FixedSourceRegion(SourceInfo other) {
        this(other.getStartLine(), other.getStartColumn(), other.getEndLine(), other.getEndColumn());
    }

    public FixedSourceRegion(int startLine, int startColumn, int endLine, int endColumn) {
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    @Override
    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public int getStartColumn() {
        return this.startColumn;
    }

    @Override
    public int getEndLine() {
        return this.endLine;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    public FixedSourceRegion setStartLine(int startLine) {
        return new FixedSourceRegion(startLine, this.startColumn, this.endLine, this.endColumn);
    }

    public FixedSourceRegion setStartColumn(int startColumn) {
        return new FixedSourceRegion(this.startLine, startColumn, this.endLine, this.endColumn);
    }

    public FixedSourceRegion setEndLine(int endLine) {
        return new FixedSourceRegion(this.startLine, this.startColumn, endLine, this.endColumn);
    }

    public FixedSourceRegion setEndColumn(int endColumn) {
        return new FixedSourceRegion(this.startLine, this.startColumn, this.endLine, endColumn);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedSourceRegion that = (FixedSourceRegion)o;
        if (this.endColumn != that.endColumn) {
            return false;
        }
        if (this.endLine != that.endLine) {
            return false;
        }
        if (this.startColumn != that.startColumn) {
            return false;
        }
        return this.startLine == that.startLine;
    }

    public int hashCode() {
        int result = this.startLine;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endColumn;
        return result;
    }

    public String toString() {
        return "{" + this.startLine + ", " + this.startColumn + ", " + this.endLine + ", " + this.endColumn + '}';
    }

    public static FixedSourceRegion of(SourceInfo region) {
        return region instanceof FixedSourceRegion ? (FixedSourceRegion)region : new FixedSourceRegion(region);
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        FixedSourceRegion.writeRaw(this, out);
    }

    public static void writeRaw(SourceInfo region, TaggedDataOutput out) throws IOException {
        out.writeInt(region.getStartLine());
        out.writeInt(region.getStartColumn());
        out.writeInt(region.getEndLine());
        out.writeInt(region.getEndColumn());
    }

    public static FixedSourceRegion read(TaggedDataInput in) throws IOException {
        return new FixedSourceRegion(in.readInt(), in.readInt(), in.readInt(), in.readInt());
    }

    public static class RegionStartComparator
    implements Comparator<SourceInfo> {
        @Override
        public int compare(SourceInfo reg1, SourceInfo reg2) {
            if (reg1 == null && reg2 == null) {
                return 0;
            }
            if (reg1 == null) {
                return -1;
            }
            if (reg2 == null) {
                return 1;
            }
            int sld = reg1.getStartLine() - reg2.getStartLine();
            if (sld == 0) {
                int scd = reg1.getStartColumn() - reg2.getStartColumn();
                if (scd == 0) {
                    int eld = reg1.getEndLine() - reg2.getEndLine();
                    if (eld == 0) {
                        return reg1.getEndColumn() - reg2.getEndColumn();
                    }
                    return eld;
                }
                return scd;
            }
            return sld;
        }
    }
}

