/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.ErrorInfo;
import com.atlassian.clover.Logger;
import com.atlassian.clover.recorder.CoverageSnapshot;
import com.atlassian.clover.recorder.NullRecorder;
import com.atlassian.clover.util.CloverBitSet;
import com_atlassian_clover.Clover;
import com_atlassian_clover.CloverProfile;
import com_atlassian_clover.CoverageRecorder;

public class DelayedRecorder
extends CoverageRecorder {
    private final RecorderDelegateConstructor delegateConstructor;
    private transient CoverageRecorder delegate = NullRecorder.INSTANCE;
    private transient RecordingState state = RecordingState.WaitingForClover;

    public DelayedRecorder(final String initString, final long dbVersion, final long cfgbits, final int maxNumElements, final CloverProfile[] profiles, final String ... nvpProperties) {
        this.delegateConstructor = new RecorderDelegateConstructor(){

            @Override
            public CoverageRecorder create() {
                return Clover.getRecorder(initString, dbVersion, cfgbits, maxNumElements, profiles, nvpProperties);
            }
        };
    }

    private synchronized void changeState(RecordingState state, CoverageRecorder delegate) {
        this.state = state;
        this.delegate = delegate;
    }

    private CoverageRecorder syncWithCloverRuntime() {
        this.state.syncWithCloverRuntime(this, this.delegateConstructor);
        return this.delegate;
    }

    @Override
    public String getDbName() {
        return this.syncWithCloverRuntime().getDbName();
    }

    @Override
    public String getRecordingName() {
        return this.syncWithCloverRuntime().getRecordingName();
    }

    @Override
    public long getDbVersion() {
        return this.syncWithCloverRuntime().getDbVersion();
    }

    @Override
    public CloverBitSet compareCoverageWith(CoverageSnapshot before) {
        return this.syncWithCloverRuntime().compareCoverageWith(before);
    }

    @Override
    public CloverBitSet createEmptyHitsMask() {
        return this.syncWithCloverRuntime().createEmptyHitsMask();
    }

    @Override
    public void startRun() {
        this.syncWithCloverRuntime().startRun();
    }

    @Override
    public void flushNeeded() {
        this.syncWithCloverRuntime().flushNeeded();
    }

    @Override
    public void maybeFlush() {
        this.syncWithCloverRuntime().maybeFlush();
    }

    @Override
    public void forceFlush() {
        this.syncWithCloverRuntime().forceFlush();
    }

    @Override
    public void flush() {
        this.syncWithCloverRuntime().flush();
    }

    @Override
    public void sliceStart(String runtimeType, long ts, int id, int rid) {
        this.syncWithCloverRuntime().sliceStart(runtimeType, ts, id, rid);
    }

    @Override
    public void sliceEnd(String runtimeType, String method, String runtimeTestName, long ts, int id, int rid, int exitStatus, ErrorInfo errorInfo) {
        this.syncWithCloverRuntime().sliceEnd(runtimeType, method, runtimeTestName, ts, id, rid, exitStatus, errorInfo);
    }

    @Override
    public void inc(int index) {
        this.syncWithCloverRuntime().inc(index);
    }

    @Override
    public int iget(int index) {
        return this.syncWithCloverRuntime().iget(index);
    }

    @Override
    public CoverageRecorder withCapacityFor(int maxNumElements) {
        return this.syncWithCloverRuntime().withCapacityFor(maxNumElements);
    }

    @Override
    public void globalSliceStart(String runtimeType, int id) {
        this.syncWithCloverRuntime().globalSliceStart(runtimeType, id);
    }

    @Override
    public void globalSliceStart(String runtimeType, int id, long startTime) {
        this.syncWithCloverRuntime().globalSliceStart(runtimeType, id, startTime);
    }

    @Override
    public void globalSliceEnd(String runtimeType, String method, String runtimeTestName, int id) {
        this.syncWithCloverRuntime().globalSliceEnd(runtimeType, method, runtimeTestName, id);
    }

    @Override
    public void globalSliceEnd(String runtimeType, String method, String runtimeTestName, int id, int exitStatus, Throwable throwable) {
        this.syncWithCloverRuntime().globalSliceEnd(runtimeType, method, runtimeTestName, id, exitStatus, throwable);
    }

    @Override
    public CoverageSnapshot getCoverageSnapshot() {
        return this.syncWithCloverRuntime().getCoverageSnapshot();
    }

    private static interface RecorderDelegateConstructor {
        public CoverageRecorder create();
    }

    private static enum RecordingState {
        WaitingForClover{

            @Override
            public void syncWithCloverRuntime(DelayedRecorder delayedRecorder, RecorderDelegateConstructor constructor) {
                if (Clover.isInitialised()) {
                    Logger.getInstance().warn("Re-entrant Clover initialisation detected. Some coverage may not have been recorded before this point.");
                    delayedRecorder.changeState(1.Running, constructor.create());
                }
            }
        }
        ,
        Running{

            @Override
            public void syncWithCloverRuntime(DelayedRecorder delayedRecorder, RecorderDelegateConstructor constructor) {
            }
        };


        public abstract void syncWithCloverRuntime(DelayedRecorder var1, RecorderDelegateConstructor var2);
    }
}

