/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.optimization;

import com.atlassian.clover.Logger;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.optimization.Snapshot;
import com.atlassian.clover.optimization.TestMethodCall;
import com.atlassian.clover.reporters.json.JSONArray;
import com.atlassian.clover.reporters.json.JSONException;
import com.atlassian.clover.reporters.json.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SnapshotPrinter {
    private static int indent;

    public static void main(String[] args) throws IOException, JSONException {
        if (args.length == 0) {
            SnapshotPrinter.printUsage();
        } else {
            PrintStream out;
            Config config = SnapshotPrinter.parseCommandLineArgs(args);
            OutputStream outputStream = out = config.outputFile == null ? System.out : Files.newOutputStream(config.outputFile.toPath(), new OpenOption[0]);
            if (config.format.equalsIgnoreCase("json")) {
                SnapshotPrinter.jsonPrint(Snapshot.loadFrom(config.snapshotFile), out);
            } else {
                SnapshotPrinter.textPrint(Snapshot.loadFrom(config.snapshotFile), out);
            }
            ((OutputStream)out).flush();
            if (config.outputFile != null) {
                ((OutputStream)out).close();
            }
        }
    }

    private static Config parseCommandLineArgs(String[] args) {
        Config config = new Config();
        int i = 0;
        while (i < args.length - 1) {
            if (args[i].equals("-o")) {
                config.outputFile = new File(args[i + 1]);
            } else if (args[i].equals("-f")) {
                config.format = args[i + 1];
            }
            ++i;
        }
        config.snapshotFile = new File(args[args.length - 1]);
        return config;
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("java " + SnapshotPrinter.class.getName() + " [-o output_file] [-f text|json] <snapshot path>");
    }

    public static void jsonPrint(Snapshot snapshot, OutputStream out) throws JSONException {
        if (snapshot != null) {
            PrintWriter writer = new PrintWriter(out);
            JSONArray jsonFilesArray = new JSONArray();
            for (Map.Entry<String, Collection<TestMethodCall>> fileEntry : snapshot.getFile2TestsMap().entrySet()) {
                JSONArray testArray = new JSONArray();
                for (TestMethodCall methodCall : fileEntry.getValue()) {
                    testArray.put(new JSONObject().put(methodCall.getRuntimeMethodName(), ""));
                }
                JSONObject jsonFileEntry = new JSONObject().put("path", fileEntry.getKey()).put("tests", testArray);
                jsonFilesArray.put(jsonFileEntry);
            }
            JSONObject jsonRoot = new JSONObject().put("project", new JSONObject().put("files", jsonFilesArray));
            writer.println(jsonRoot.toString());
            writer.flush();
        }
    }

    public static void textPrint(Snapshot snapshot, OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        if (snapshot != null) {
            writer.println("Loaded snapshot at: " + snapshot.getLocation());
            writer.println("Loaded snapshot for clover.db: " + snapshot.getInitString());
            writer.println("Snapshot's Clover version: " + snapshot.getCloverVersionInfo());
            writer.println("CLI's Clover version: " + snapshot.getCloverVersionInfo());
            writer.println("Versions: ");
            for (Long l : snapshot.getDbVersions()) {
                ++indent;
                writer.println("" + l);
                --indent;
            }
            writer.println("Known tests: ");
            for (Map.Entry entry : snapshot.getTestLookup().entrySet()) {
                ++indent;
                String name = (String)entry.getKey();
                Set tests = (Set)entry.getValue();
                long duration = snapshot.calculateDurationOf(tests);
                writer.println(SnapshotPrinter.indent(String.valueOf(name) + " : duration " + SnapshotPrinter.durationAsString(duration)));
                for (TestMethodCall test : tests) {
                    ++indent;
                    snapshot.calculateDurationOf(Collections.singleton(test));
                    writer.println(SnapshotPrinter.indent(String.valueOf(test.toString()) + " : "));
                    --indent;
                }
                --indent;
            }
            writer.flush();
            writer.println("Failing tests: ");
            for (String string : snapshot.getFailingTestPaths()) {
                ++indent;
                writer.println(SnapshotPrinter.indent(string));
                --indent;
            }
            writer.flush();
            writer.println("All files: ");
            for (Map.Entry entry : snapshot.getFile2TestsMap().entrySet()) {
                ++indent;
                writer.println(SnapshotPrinter.indent((String)entry.getKey()));
                writer.println(SnapshotPrinter.indent("Hitting tests:"));
                for (TestMethodCall testMethodCall : (Collection)entry.getValue()) {
                    ++indent;
                    writer.println(SnapshotPrinter.indent(testMethodCall.toString()));
                    --indent;
                }
                --indent;
            }
            writer.flush();
        }
    }

    public static void textPrint(Snapshot snapshot, Logger logger, int logLevel) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        SnapshotPrinter.textPrint(snapshot, buffer);
        try {
            logger.log(logLevel, buffer.toString(Charset.defaultCharset().name()), null);
        }
        catch (UnsupportedEncodingException ex) {
            logger.log(logLevel, "Unsupported encoding: " + Charset.defaultCharset().name(), ex);
        }
    }

    private static String durationAsString(long duration) {
        return String.valueOf(new Interval(BigDecimal.valueOf(duration).divide(BigDecimal.valueOf(1000L), 2, RoundingMode.HALF_UP), 0).toSensibleString()) + " (" + duration + " ms)";
    }

    private static String indent(String line) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < indent) {
            buffer.append("\t");
            ++i;
        }
        buffer.append(line);
        return buffer.toString();
    }

    private static class Config {
        File outputFile;
        String format = "text";
        File snapshotFile;

        private Config() {
        }
    }
}

