/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests;

import com.atlassian.clover.instr.tests.TestDetector;
import com.atlassian.clover.registry.entities.MethodSignature;
import com.atlassian.clover.registry.entities.Modifiers;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class TestSpec
implements TestDetector {
    private Pattern pkgPattern;
    private Pattern classAnnotationPattern;
    private Pattern classPattern;
    private Pattern superPattern;
    private Pattern classTagPattern;
    private Pattern methodAnnotationPattern;
    private Pattern methodPattern;
    private Pattern methodReturnTypePattern;
    private Pattern methodTagPattern;

    public TestSpec() {
    }

    public TestSpec(TestSpec spec) {
        this.pkgPattern = spec.pkgPattern;
        this.classAnnotationPattern = spec.classAnnotationPattern;
        this.classPattern = spec.classPattern;
        this.superPattern = spec.superPattern;
        this.classTagPattern = spec.classTagPattern;
        this.methodAnnotationPattern = spec.methodAnnotationPattern;
        this.methodPattern = spec.methodPattern;
        this.methodReturnTypePattern = spec.methodReturnTypePattern;
        this.methodTagPattern = spec.methodTagPattern;
    }

    public void setPkgPattern(Pattern pkgPattern) {
        this.pkgPattern = pkgPattern;
    }

    public void setClassAnnotationPattern(Pattern classAnnotationPattern) {
        this.classAnnotationPattern = classAnnotationPattern;
    }

    public void setClassTagPattern(Pattern classTagPattern) {
        this.classTagPattern = classTagPattern;
    }

    private boolean tagsMatch(Pattern javaDocPattern, Map<String, List<String>> tags) {
        for (String s : tags.keySet()) {
            if (!javaDocPattern.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    public void setMethodTagPattern(Pattern methodTagPattern) {
        this.methodTagPattern = methodTagPattern;
    }

    public void setClassPattern(Pattern classPattern) {
        this.classPattern = classPattern;
    }

    public void setSuperPattern(Pattern superPattern) {
        this.superPattern = superPattern;
    }

    public void setMethodAnnotationPattern(Pattern methodAnnotationPattern) {
        this.methodAnnotationPattern = methodAnnotationPattern;
    }

    public void setMethodPattern(Pattern methodPattern) {
        this.methodPattern = methodPattern;
    }

    public void setMethodReturnTypePattern(Pattern methodReturnsPattern) {
        this.methodReturnTypePattern = methodReturnsPattern;
    }

    public boolean methodReturnPatternMatches(String methodReturnType) {
        return methodReturnType != null && (this.methodReturnTypePattern == null || this.methodReturnTypePattern.matcher(methodReturnType).matches());
    }

    @Override
    public boolean isTypeMatch(TestDetector.SourceContext sourceContext, TestDetector.TypeContext typeContext) {
        return this.pkgMatches(typeContext.getPackageName()) && this.classMatches(typeContext.getTypeName()) && this.superMatches(typeContext.getSuperTypeName()) && this.classAnnotationMatches(typeContext.getModifiers()) && this.classTagMatches(typeContext.getDocTags());
    }

    @Override
    public boolean isMethodMatch(TestDetector.SourceContext sourceContext, TestDetector.MethodContext methodContext) {
        MethodSignature signature = methodContext.getSignature();
        return this.methodMatches(signature.getName()) && this.methodAnnotationMatches(signature.getModifiers()) && this.methodReturnPatternMatches(signature.getReturnType()) && this.methodTagMatches(signature.getTags());
    }

    public boolean pkgMatches(String pkg) {
        return this.pkgPattern == null || pkg != null && this.pkgPattern.matcher(pkg).matches();
    }

    public boolean classAnnotationMatches(Modifiers m) {
        return this.classAnnotationPattern == null || m != null && m.containsAnnotation(this.classAnnotationPattern);
    }

    public boolean classTagMatches(Map<String, List<String>> tags) {
        return this.classTagPattern == null || tags != null && !tags.isEmpty() && this.tagsMatch(this.classTagPattern, tags);
    }

    public boolean methodTagMatches(Map<String, List<String>> tags) {
        return this.methodTagPattern == null || tags != null && !tags.isEmpty() && this.tagsMatch(this.methodTagPattern, tags);
    }

    public boolean classMatches(String className) {
        return this.classPattern == null || className != null && this.classPattern.matcher(className).matches();
    }

    public boolean methodAnnotationMatches(Modifiers modifiers) {
        return this.methodAnnotationPattern == null || modifiers != null && modifiers.containsAnnotation(this.methodAnnotationPattern);
    }

    public boolean superMatches(String superName) {
        return this.superPattern == null || superName != null && this.superPattern.matcher(superName).matches();
    }

    public boolean methodMatches(String method) {
        return this.methodPattern == null || method != null && this.methodPattern.matcher(method).matches();
    }
}

