/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.instr.java.InstrumentationSource;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class FileInstrumentationSource
implements InstrumentationSource {
    private final File sourceFile;
    private final String encoding;

    public FileInstrumentationSource(File sourceFile, String encoding) {
        this.sourceFile = sourceFile;
        this.encoding = encoding;
    }

    @Override
    public File getSourceFileLocation() {
        return this.sourceFile;
    }

    @Override
    public Reader createReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(Files.newInputStream(this.sourceFile.toPath(), new OpenOption[0]), this.encoding);
        }
        return new FileReader(this.sourceFile);
    }
}

