/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.plot.dial;

import clover.org.jfree.chart.HashUtilities;
import clover.org.jfree.chart.plot.dial.AbstractDialLayer;
import clover.org.jfree.chart.plot.dial.DialLayer;
import clover.org.jfree.chart.plot.dial.DialLayerChangeEvent;
import clover.org.jfree.chart.plot.dial.DialPlot;
import clover.org.jfree.chart.util.ParamChecks;
import clover.org.jfree.io.SerialUtilities;
import clover.org.jfree.ui.GradientPaintTransformer;
import clover.org.jfree.ui.StandardGradientPaintTransformer;
import clover.org.jfree.util.PaintUtilities;
import clover.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class DialBackground
extends AbstractDialLayer
implements DialLayer,
Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = -9019069533317612375L;
    private transient Paint paint;
    private GradientPaintTransformer gradientPaintTransformer;

    public DialBackground() {
        this(Color.white);
    }

    public DialBackground(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer t) {
        ParamChecks.nullNotPermitted(t, "t");
        this.gradientPaintTransformer = t;
        this.notifyListeners(new DialLayerChangeEvent(this));
    }

    @Override
    public boolean isClippedToWindow() {
        return true;
    }

    @Override
    public void draw(Graphics2D g2, DialPlot plot, Rectangle2D frame, Rectangle2D view) {
        Paint p = this.paint;
        if (p instanceof GradientPaint) {
            p = this.gradientPaintTransformer.transform((GradientPaint)p, view);
        }
        g2.setPaint(p);
        g2.fill(view);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DialBackground)) {
            return false;
        }
        DialBackground that = (DialBackground)obj;
        if (!PaintUtilities.equal(this.paint, that.paint)) {
            return false;
        }
        if (!this.gradientPaintTransformer.equals(that.gradientPaintTransformer)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = 193;
        result = 37 * result + HashUtilities.hashCodeForPaint(this.paint);
        result = 37 * result + this.gradientPaintTransformer.hashCode();
        return result;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(stream);
    }
}

