/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.clover;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class CloverInstallation
extends ToolInstallation
implements NodeSpecific<CloverInstallation> {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public CloverInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public static CloverInstallation forName(String name) {
        for (CloverInstallation cloverInstallation : (CloverInstallation[])DESCRIPTOR.getInstallations()) {
            if (name == null || !name.equals(cloverInstallation.getName())) continue;
            return cloverInstallation;
        }
        return null;
    }

    public static List<CloverInstallation> installations() {
        return Arrays.asList((CloverInstallation[])DESCRIPTOR.getInstallations());
    }

    public CloverInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
        return new CloverInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public static final class DescriptorImpl
    extends ToolDescriptor<CloverInstallation> {
        public DescriptorImpl() {
            super.setInstallations((ToolInstallation[])new CloverInstallation[0]);
            this.load();
        }

        public String getDisplayName() {
            return "Clover";
        }

        public void setInstallations(CloverInstallation ... installations) {
            super.setInstallations((ToolInstallation[])installations);
            this.save();
        }

        public CloverInstallation newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (CloverInstallation)super.newInstance(req, formData.getJSONObject("cloverInstallation"));
        }
    }
}

