/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.ChildNameGenerator;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ExtensionPoint;
import hudson.XmlFile;
import hudson.model.Items;
import hudson.model.TopLevelItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ChildLoader
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(ChildLoader.class.getName());

    protected abstract <K, V extends TopLevelItem> Map<K, V> loadChildren(AbstractFolder<V> var1, File var2, Function<? super V, ? extends K> var3);

    protected <V extends TopLevelItem> boolean ensureDirExists(File modulesDir, AbstractFolder<V> parent) {
        if (!modulesDir.isDirectory() && !modulesDir.mkdirs()) {
            LOGGER.log(Level.SEVERE, "Could not create {0} for folder {1}", new Object[]{modulesDir, parent.getFullName()});
            return false;
        }
        return true;
    }

    protected <V extends TopLevelItem> Map<String, V> getItemsByDirName(AbstractFolder<V> parent) {
        HashMap<String, TopLevelItem> byDirName = new HashMap<String, TopLevelItem>();
        if (parent.items != null) {
            ChildNameGenerator<AbstractFolder<V>, V> childNameGenerator = parent.childNameGenerator();
            for (TopLevelItem item : parent.items.values()) {
                byDirName.put(childNameGenerator.dirName(parent, item), item);
            }
        }
        return byDirName;
    }

    @CheckForNull
    public <V extends TopLevelItem> V loadItem(AbstractFolder<V> parent, File subdir, @CheckForNull V item) {
        try {
            String name;
            if (item == null) {
                XmlFile xmlFile = Items.getConfigFile((File)subdir);
                if (xmlFile.exists()) {
                    item = (TopLevelItem)xmlFile.read();
                } else {
                    throw new FileNotFoundException("Could not find configuration file " + String.valueOf(xmlFile.getFile()));
                }
            }
            if ((name = parent.childNameGenerator().itemNameFromItem(parent, item)) == null) {
                name = subdir.getName();
            }
            item.onLoad(parent, name);
            return item;
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException && !LOGGER.isLoggable(Level.FINE)) {
                LOGGER.warning(() -> "could not load " + String.valueOf(subdir) + " due to " + String.valueOf(e));
            } else {
                LOGGER.log(Level.WARNING, "could not load " + String.valueOf(subdir), e);
            }
            return null;
        }
    }
}

