/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.health;

import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetric;
import com.cloudbees.hudson.plugins.folder.health.FolderHealthMetricDescriptor;
import com.cloudbees.hudson.plugins.folder.health.Messages;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.HealthReport;
import hudson.model.Item;
import hudson.model.ItemGroup;
import java.util.Collections;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class NamedChildHealthMetric
extends FolderHealthMetric {
    private String childName;

    @DataBoundConstructor
    public NamedChildHealthMetric(String childName) {
        this.childName = childName;
    }

    public String getChildName() {
        return this.childName;
    }

    @Override
    public FolderHealthMetric.Type getType() {
        return FolderHealthMetric.Type.SELF_ONLY;
    }

    @Override
    public FolderHealthMetric.Reporter reporter() {
        return new ReporterImpl(this.childName);
    }

    private static class ReporterImpl
    implements FolderHealthMetric.Reporter {
        private HealthReport report = null;
        private String childName;

        public ReporterImpl(String childName) {
            this.childName = childName;
        }

        @Override
        public void observe(Item item) {
            Item child;
            if (item instanceof ItemGroup && (child = ((ItemGroup)item).getItem(this.childName)) != null) {
                this.report = FolderHealthMetric.getHealthReport(child);
            }
        }

        @Override
        public List<HealthReport> report() {
            return this.report != null ? Collections.singletonList(this.report) : Collections.emptyList();
        }
    }

    @Extension(ordinal=400.0)
    public static class DescriptorImpl
    extends FolderHealthMetricDescriptor {
        private static final String DEFAULT = "";

        public String getDisplayName() {
            return Messages.NamedChildHealthMetric_DisplayName();
        }

        @Override
        public FolderHealthMetric createDefault() {
            return new NamedChildHealthMetric(DEFAULT);
        }

        @RequirePOST
        @Restricted(value={DoNotUse.class})
        public AutoCompletionCandidates doAutoCompleteChildName(@QueryParameter String value, @AncestorInPath ItemGroup<Item> container) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            for (Item item : container.getItems()) {
                String name = item.getName();
                if (name == null || !name.startsWith(value)) continue;
                candidates.add(name);
            }
            return candidates;
        }
    }
}

