/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.util;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketOAuthAuthenticatorSource;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketUserAPITokenAuthenticatorSource;
import com.cloudbees.jenkins.plugins.bitbucket.impl.credentials.BitbucketUsernamePasswordAuthenticatorSource;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokenContext;
import jenkins.authentication.tokens.api.AuthenticationTokenSource;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.util.SystemProperties;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.core.Authentication;

public class BitbucketCredentialsUtils {
    private BitbucketCredentialsUtils() {
        throw new IllegalAccessError("Utility class");
    }

    @Restricted(value={NoExternalUse.class})
    public static void resetBlacklist() {
        TimeBoxedCredentialsMatcher.blacklist.clear();
    }

    @CheckForNull
    public static <T extends StandardCredentials> T lookupCredentials(@CheckForNull Item item, @CheckForNull String serverURL, @CheckForNull String credentialsId, @NonNull Class<T> type) {
        if (StringUtils.isNotBlank((CharSequence)credentialsId)) {
            Authentication authentication;
            if (item instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)item;
                authentication = task.getDefaultAuthentication2();
            } else {
                authentication = ACL.SYSTEM2;
            }
            Authentication authentication2 = authentication;
            List domainRequirements = URIRequirementBuilder.fromUri((String)serverURL).build();
            return (T)((StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(type, (Item)item, (Authentication)authentication2, (List)domainRequirements), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)));
        }
        return null;
    }

    @CheckForNull
    public static <T extends StandardCredentials> T lookupCredentials(@CheckForNull ItemGroup<?> itemGroup, @CheckForNull String serverURL, @CheckForNull String credentialsId, @NonNull Class<T> type) {
        if (StringUtils.isNotBlank((CharSequence)credentialsId)) {
            List domainRequirements = URIRequirementBuilder.fromUri((String)serverURL).build();
            return (T)((StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(type, itemGroup, null, (List)domainRequirements), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)));
        }
        return null;
    }

    public static FormValidation checkCredentialsId(@CheckForNull SCMSourceOwner context, @CheckForNull String serverURL, @CheckForNull String credentialsId) {
        if (StringUtils.isNotBlank((CharSequence)credentialsId)) {
            Authentication authentication;
            serverURL = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(BitbucketEndpointConfiguration.get().getDefaultEndpoint()).getServerURL();
            Jenkins contextToCheck = context == null ? Jenkins.get() : context;
            contextToCheck.checkPermission(CredentialsProvider.VIEW);
            if (context instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)context;
                authentication = task.getDefaultAuthentication2();
            } else {
                authentication = ACL.SYSTEM2;
            }
            Authentication authentication2 = authentication;
            List domainRequirements = URIRequirementBuilder.fromUri((String)serverURL).build();
            StandardCertificateCredentials certificateCredentials = (StandardCertificateCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardCertificateCredentials.class, (Item)context, (Authentication)authentication2, (List)domainRequirements), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
            if (certificateCredentials != null) {
                return FormValidation.warning((String)"A certificate was selected. You will likely need to configure Checkout over SSH.");
            }
            return FormValidation.ok();
        }
        return FormValidation.warning((String)"Credentials are required for build notifications");
    }

    public static ListBoxModel listCredentials(@NonNull Item context, @CheckForNull String serverURL, @CheckForNull String credentialsId) {
        Authentication authentication;
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeEmptyValue();
        if (!context.hasPermission(CredentialsProvider.VIEW)) {
            return result;
        }
        if (context instanceof Queue.Task) {
            Queue.Task task = (Queue.Task)context;
            authentication = task.getDefaultAuthentication2();
        } else {
            authentication = ACL.SYSTEM2;
        }
        Authentication authentication2 = authentication;
        serverURL = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(BitbucketEndpointConfiguration.get().getDefaultEndpoint()).getServerURL();
        List domainRequirements = URIRequirementBuilder.fromUri((String)serverURL).build();
        CredentialsMatcher matcher = BitbucketCredentialsUtils.matcher(BitbucketAuthenticator.authenticationContext(serverURL));
        result.includeMatchingAs(authentication2, context, StandardCredentials.class, domainRequirements, matcher);
        if (credentialsId != null) {
            result.includeCurrentValue(credentialsId);
        }
        return result;
    }

    public static ListBoxModel listCredentials(@NonNull ItemGroup<?> context, @CheckForNull String serverURL, @CheckForNull String credentialsId) {
        List domainRequirements = URIRequirementBuilder.fromUri((String)serverURL).build();
        Authentication authentication = ACL.SYSTEM2;
        CredentialsMatcher matcher = BitbucketCredentialsUtils.matcher(BitbucketAuthenticator.authenticationContext(serverURL));
        StandardListBoxModel result = new StandardListBoxModel();
        result.includeMatchingAs(authentication, context, StandardCredentials.class, domainRequirements, matcher);
        if (credentialsId != null) {
            result.includeCurrentValue(credentialsId);
        }
        return result;
    }

    private static <T> CredentialsMatcher matcher(AuthenticationTokenContext<T> context) {
        ArrayList<CredentialsMatcher> matchers = new ArrayList<CredentialsMatcher>();
        for (AuthenticationTokenSource source : ExtensionList.lookup(AuthenticationTokenSource.class)) {
            if (!source.fits(context)) continue;
            CredentialsMatcher matcher = source.matcher();
            if (source instanceof BitbucketUsernamePasswordAuthenticatorSource || source instanceof BitbucketOAuthAuthenticatorSource || source instanceof BitbucketUserAPITokenAuthenticatorSource) {
                matcher = new TimeBoxedCredentialsMatcher(matcher);
            }
            matchers.add(matcher);
        }
        return matchers.isEmpty() ? CredentialsMatchers.never() : CredentialsMatchers.anyOf((CredentialsMatcher[])matchers.toArray(new CredentialsMatcher[matchers.size()]));
    }

    private static class TimeBoxedCredentialsMatcher
    implements CredentialsMatcher {
        static final String TIMEOUT_CREDENTILS_RESOLUTION_PROPERTY_NAME = "bitbucket.credentials.resolutionTimeout";
        private static final Logger logger = Logger.getLogger(TimeBoxedCredentialsMatcher.class.getName());
        private static final Map<Class<?>, Integer> blacklist = new ConcurrentHashMap();
        private CredentialsMatcher delegate;
        private Integer resolutionTimout = SystemProperties.getInteger((String)"bitbucket.credentials.resolutionTimeout", (Integer)250);

        public TimeBoxedCredentialsMatcher(CredentialsMatcher matcher) {
            this.delegate = matcher;
        }

        public boolean matches(Credentials item) {
            SimpleTimeLimiter timeLimiter = SimpleTimeLimiter.create((ExecutorService)Executors.newSingleThreadExecutor());
            Class<?> credentialClass = item.getClass();
            if (blacklist.containsKey(credentialClass) && blacklist.get(credentialClass) > 1) {
                logger.fine(() -> "Credentials " + credentialClass + " discarded becuase it is blacklisted");
                return false;
            }
            try {
                return (Boolean)timeLimiter.callWithTimeout(() -> this.delegate.matches(item), Duration.ofMillis(this.resolutionTimout.intValue()));
            }
            catch (TimeoutException e) {
                blacklist.compute(credentialClass, (k, v) -> {
                    if (v == null) {
                        return 1;
                    }
                    logger.warning(() -> "Credentials of type " + credentialClass + " will be added to the blacklist because exeed the resolution time of the secret twice");
                    return v + 1;
                });
                logger.fine(() -> "Credentials " + item.getDescriptor() + " takes too long to get password, maybe is performing remote call");
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

