/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerHeadEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerPullRequestEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.RestrictedSince;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.collections4.MultiValuedMap;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="933.3.0")
public class ServerPullRequestWebhookProcessor
extends AbstractWebhookProcessor {
    private static final Logger LOGGER = Logger.getLogger(ServerPullRequestWebhookProcessor.class.getName());
    private static final List<String> supportedEvents = List.of(HookEventType.SERVER_PULL_REQUEST_OPENED.getKey(), HookEventType.SERVER_PULL_REQUEST_MERGED.getKey(), HookEventType.SERVER_PULL_REQUEST_DECLINED.getKey(), HookEventType.SERVER_PULL_REQUEST_DELETED.getKey(), HookEventType.SERVER_PULL_REQUEST_MODIFIED.getKey(), HookEventType.SERVER_PULL_REQUEST_FROM_REF_UPDATED.getKey());

    @Override
    public boolean canHandle(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        return headers.containsKey("X-Event-Key") && headers.containsKey("X-Request-Id") && supportedEvents.contains(headers.get("X-Event-Key")) && parameters.containsKey((Object)"server_url");
    }

    @Override
    public void process(@NonNull String hookEventType, @NonNull String payload, @NonNull Map<String, Object> context, @NonNull BitbucketEndpoint endpoint) {
        SCMEvent.Type eventType;
        NativeServerPullRequestEvent pullRequestEvent;
        try {
            pullRequestEvent = JsonParser.toJava(payload, NativeServerPullRequestEvent.class);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can not read hook payload", e);
            return;
        }
        HookEventType hookEvent = HookEventType.fromString(hookEventType);
        switch (hookEvent) {
            case SERVER_PULL_REQUEST_OPENED: {
                eventType = SCMEvent.Type.CREATED;
                break;
            }
            case SERVER_PULL_REQUEST_MERGED: 
            case SERVER_PULL_REQUEST_DECLINED: 
            case SERVER_PULL_REQUEST_DELETED: {
                eventType = SCMEvent.Type.REMOVED;
                break;
            }
            case SERVER_PULL_REQUEST_MODIFIED: 
            case SERVER_PULL_REQUEST_FROM_REF_UPDATED: {
                eventType = SCMEvent.Type.UPDATED;
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Unknown hook event {0} received from Bitbucket Server", (Object)hookEvent);
                return;
            }
        }
        this.notifyEvent(new ServerHeadEvent(endpoint.getServerURL(), eventType, pullRequestEvent, this.getOrigin(context)), BitbucketSCMSource.getEventDelaySeconds());
    }
}

