/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server.ServerWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerVersion;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMName;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class BitbucketServerEndpoint
extends AbstractBitbucketEndpoint {
    private static final String[] COMMON_PREFIX_HOSTNAMES = new String[]{"git.", "bitbucket.", "bb.", "stash.", "vcs.", "scm.", "source."};
    @CheckForNull
    private final String displayName;
    @NonNull
    private final String serverURL;
    private BitbucketServerVersion serverVersion = BitbucketServerVersion.getMinSupportedVersion();

    @NonNull
    public static BitbucketServerVersion findServerVersion(String serverURL) {
        return BitbucketEndpointProvider.lookupEndpoint(serverURL, BitbucketServerEndpoint.class).map(endpoint -> endpoint.getServerVersion()).map(BitbucketServerVersion::valueOf).orElse(BitbucketServerVersion.getMinSupportedVersion());
    }

    public BitbucketServerEndpoint(@CheckForNull String displayName, @NonNull String serverURL) {
        this(displayName, serverURL, new ServerWebhookConfiguration(false, null, false, null));
    }

    @DataBoundConstructor
    public BitbucketServerEndpoint(@CheckForNull String displayName, @NonNull String serverURL, @NonNull BitbucketWebhookConfiguration webhook) {
        super(webhook);
        this.serverURL = Util.fixNull((String)URLUtils.normalizeURL(serverURL));
        this.displayName = StringUtils.isBlank((CharSequence)displayName) ? SCMName.fromUrl((String)this.serverURL, (String[])COMMON_PREFIX_HOSTNAMES) : displayName.trim();
    }

    @Override
    @NonNull
    public EndpointType getType() {
        return EndpointType.SERVER;
    }

    @NonNull
    public String getServerVersion() {
        if (this.serverVersion == null) {
            this.serverVersion = BitbucketServerVersion.getMinSupportedVersion();
        }
        return this.serverVersion.name();
    }

    @DataBoundSetter
    public void setServerVersion(@NonNull String serverVersion) {
        try {
            this.serverVersion = BitbucketServerVersion.valueOf(serverVersion);
        }
        catch (IllegalArgumentException e) {
            this.serverVersion = BitbucketServerVersion.getMinSupportedVersion();
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getServerURL() {
        return this.serverURL;
    }

    @Override
    @NonNull
    public String getRepositoryURL(@NonNull String repoOwner, @NonNull String repository) {
        UriTemplate template = UriTemplate.fromTemplate((String)(this.serverURL + "/{userOrProject}/{owner}/repos/{repo}")).set("repo", (Object)repository);
        return repoOwner.startsWith("~") ? template.set("userOrProject", (Object)"users").set("owner", (Object)repoOwner.substring(1)).expand() : template.set("userOrProject", (Object)"projects").set("owner", (Object)repoOwner).expand();
    }

    @Override
    protected Object readResolve() {
        if (this.serverVersion == null) {
            this.serverVersion = BitbucketServerVersion.getMinSupportedVersion();
        }
        return super.readResolve();
    }

    @Extension
    public static class DescriptorImpl
    extends BitbucketEndpointDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BitbucketServerEndpoint_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        @RequirePOST
        public ListBoxModel doFillServerVersionItems() {
            Jenkins.get().checkPermission(Jenkins.MANAGE);
            ListBoxModel items = new ListBoxModel();
            for (BitbucketServerVersion serverVersion : BitbucketServerVersion.values()) {
                items.add((ModelObject)serverVersion, serverVersion.name());
            }
            return items;
        }

        @RequirePOST
        public FormValidation doCheckServerURL(@QueryParameter String value) {
            Jenkins.get().checkPermission(Jenkins.MANAGE);
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)("Invalid URL: " + e.getMessage()));
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public Collection<? extends Descriptor<?>> getWebhookDescriptors() {
            Jenkins.get().checkPermission(Jenkins.MANAGE);
            return ExtensionList.lookup(BitbucketWebhookDescriptor.class).stream().filter(webhook -> webhook.isApplicable(EndpointType.SERVER)).toList();
        }
    }
}

