/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.avatars;

import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import java.util.Objects;
import jenkins.scm.api.metadata.AvatarMetadataAction;
import jenkins.scm.impl.avatars.AvatarCache;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BitbucketRepoAvatarMetadataAction
extends AvatarMetadataAction {
    private static final long serialVersionUID = 6159334180425135341L;
    private final String scm;
    private String avatarURL;

    public BitbucketRepoAvatarMetadataAction(@CheckForNull BitbucketRepository repo) {
        this("git");
        if (repo != null) {
            this.avatarURL = repo.getAvatar();
        }
    }

    @DataBoundConstructor
    public BitbucketRepoAvatarMetadataAction(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    public String getAvatarURL() {
        return this.avatarURL;
    }

    @DataBoundSetter
    public void setAvatarURL(String avatarURL) {
        this.avatarURL = Util.fixEmptyAndTrim((String)avatarURL);
    }

    public String getAvatarImageOf(String size) {
        if (this.avatarURL == null) {
            return super.getAvatarImageOf(size);
        }
        return AvatarCache.buildUrl((String)this.avatarURL, (String)size);
    }

    public String getAvatarIconClassName() {
        if (this.avatarURL != null) {
            return null;
        }
        if ("git".equals(this.scm)) {
            return "icon-bitbucket-repo-git";
        }
        return "icon-bitbucket-repo";
    }

    public String getAvatarDescription() {
        if ("git".equals(this.scm)) {
            return Messages.BitbucketRepoMetadataAction_IconDescription_Git();
        }
        return Messages.BitbucketRepoMetadataAction_IconDescription();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BitbucketRepoAvatarMetadataAction that = (BitbucketRepoAvatarMetadataAction)((Object)o);
        return Objects.equals(this.scm, that.scm) && Objects.equals(this.avatarURL, that.avatarURL);
    }

    public int hashCode() {
        return Objects.hash(this.scm, this.avatarURL);
    }
}

