/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticatedClient;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudPage;
import com.cloudbees.jenkins.plugins.bitbucket.client.Cache;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketCloudWebhook;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.client.ICheckedCallable;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud.CloudWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.util.BitbucketCredentialsUtils;
import com.damnhandy.uri.template.UriTemplate;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Strings;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

@Extension
public class CloudWebhookManager
extends AbstractWebhookManager<CloudWebhookConfiguration> {
    private static final String WEBHOOK_URL = "/2.0/repositories{/owner,repo}/hooks{/hook}{?page,pagelen}";
    private static final Logger logger = Logger.getLogger(CloudWebhookManager.class.getName());
    private static final Cache<String, List<BitbucketWebHook>> cachedRepositoryWebhooks = new Cache(3, TimeUnit.HOURS);
    private static final List<String> CLOUD_EVENTS = Collections.unmodifiableList(Arrays.asList(HookEventType.PUSH.getKey(), HookEventType.PULL_REQUEST_CREATED.getKey(), HookEventType.PULL_REQUEST_UPDATED.getKey(), HookEventType.PULL_REQUEST_MERGED.getKey(), HookEventType.PULL_REQUEST_DECLINED.getKey()));

    public static void clearCaches() {
        cachedRepositoryWebhooks.evictAll();
    }

    public static List<String> stats() {
        ArrayList<String> stats = new ArrayList<String>();
        stats.add("Repositories webhooks: " + cachedRepositoryWebhooks.stats().toString());
        return stats;
    }

    @Override
    public void apply(BitbucketWebhookConfiguration configuration) {
        super.apply(configuration);
        if (((CloudWebhookConfiguration)this.configuration).isEnableCache()) {
            cachedRepositoryWebhooks.setExpireDuration(((CloudWebhookConfiguration)this.configuration).getWebhooksCacheDuration(), TimeUnit.MINUTES);
        }
    }

    @Override
    @NonNull
    public Collection<BitbucketWebHook> read(@NonNull BitbucketAuthenticatedClient client) throws IOException {
        String endpointJenkinsRootURL = this.getEndpointJenkinsRootURL();
        String url = UriTemplate.fromTemplate((String)WEBHOOK_URL).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("pagelen", (Object)100).expand();
        ICheckedCallable request = () -> {
            ArrayList<BitbucketCloudWebhook> resources = new ArrayList<BitbucketCloudWebhook>();
            TypeReference<BitbucketCloudPage<BitbucketCloudWebhook>> type = new TypeReference<BitbucketCloudPage<BitbucketCloudWebhook>>(){};
            BitbucketCloudPage<BitbucketCloudWebhook> page = JsonParser.toJava(client.get(url), type);
            resources.addAll(page.getValues().stream().filter(hook -> hook.getUrl().startsWith(endpointJenkinsRootURL)).toList());
            while (!page.isLastPage()) {
                String response = client.get(page.getNext());
                page = JsonParser.toJava(response, type);
                resources.addAll(page.getValues().stream().filter(hook -> hook.getUrl().startsWith(endpointJenkinsRootURL)).toList());
            }
            return resources;
        };
        if (this.isCacheEnabled(client)) {
            try {
                String cacheKey = this.buildCacheKey(client);
                return cachedRepositoryWebhooks.get(cacheKey, request);
            }
            catch (ExecutionException e) {
                BitbucketRequestException bre = BitbucketApiUtils.unwrap(e);
                if (bre != null) {
                    throw bre;
                }
                throw new IOException(e);
            }
        }
        return request.call();
    }

    @NonNull
    private BitbucketCloudWebhook buildPayload() {
        BitbucketCloudWebhook hook = new BitbucketCloudWebhook();
        hook.setEvents(CLOUD_EVENTS);
        hook.setActive(true);
        hook.setDescription("Jenkins hook");
        hook.setUrl(this.callbackURL);
        hook.setSkipCertVerification(((CloudWebhookConfiguration)this.configuration).isSkipCertVerification());
        if (((CloudWebhookConfiguration)this.configuration).isEnableHookSignature()) {
            String signatureCredentialsId = ((CloudWebhookConfiguration)this.configuration).getHookSignatureCredentialsId();
            StringCredentials signatureSecret = BitbucketCredentialsUtils.lookupCredentials(Jenkins.get(), "https://bitbucket.org", signatureCredentialsId, StringCredentials.class);
            if (signatureSecret != null) {
                hook.setSecret(Secret.toString((Secret)signatureSecret.getSecret()));
            } else {
                throw new IllegalStateException("Credentials " + signatureCredentialsId + " not found registering new webhook");
            }
        }
        return hook;
    }

    private void register(@NonNull BitbucketCloudWebhook payload, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_URL).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).expand();
        client.post(url, JsonParser.toString(payload));
        if (this.isCacheEnabled(client)) {
            String cacheKey = this.buildCacheKey(client);
            cachedRepositoryWebhooks.evict(cacheKey);
        }
    }

    private boolean shouldUpdate(@NonNull BitbucketCloudWebhook current, @NonNull BitbucketCloudWebhook expected) {
        List<String> expectedEvents;
        List<String> events;
        boolean update = false;
        if (!Strings.CI.equals(current.getUrl(), expected.getUrl())) {
            current.setUrl(expected.getUrl());
            logger.info(() -> "Update webhook " + current.getUuid() + " callback URL");
            update = true;
        }
        if (!current.isActive()) {
            current.setActive(true);
            logger.info(() -> "Re-activate webhook " + current.getUuid());
            update = true;
        }
        if (current.isSkipCertVerification() != expected.isSkipCertVerification()) {
            current.setSkipCertVerification(expected.isSkipCertVerification());
            logger.info(() -> "Update skipCertVerification to " + expected.isSkipCertVerification());
            update = true;
        }
        if (!(events = current.getEvents()).containsAll(expectedEvents = expected.getEvents())) {
            TreeSet<String> newEvents = new TreeSet<String>(events);
            newEvents.addAll(expectedEvents);
            current.setEvents(new ArrayList<String>(newEvents));
            logger.info(() -> "Update webhook " + current.getUuid() + " events because was missing: " + CollectionUtils.subtract((Collection)expectedEvents, (Collection)events));
            update = true;
        }
        if (!Objects.equal((Object)current.getSecret(), (Object)expected.getSecret())) {
            current.setSecret(expected.getSecret());
            logger.info(() -> "Update webhook " + current.getUuid() + " signature secret");
            update = true;
        }
        return update;
    }

    private void update(@NonNull BitbucketCloudWebhook payload, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_URL).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("hook", (Object)payload.getUuid()).expand();
        client.put(url, JsonParser.toString(payload));
        if (this.isCacheEnabled(client)) {
            String cacheKey = this.buildCacheKey(client);
            cachedRepositoryWebhooks.evict(cacheKey);
        }
    }

    @Override
    public void remove(@NonNull String webhookId, @NonNull BitbucketAuthenticatedClient client) throws IOException {
        String url = UriTemplate.fromTemplate((String)WEBHOOK_URL).set("owner", (Object)client.getRepositoryOwner()).set("repo", (Object)client.getRepositoryName()).set("hook", (Object)webhookId).expand();
        client.delete(url);
    }

    @Override
    public void register(@NonNull BitbucketAuthenticatedClient client) throws IOException {
        BitbucketCloudWebhook existingHook = this.read(client).stream().findFirst().orElse(null);
        if (existingHook == null) {
            logger.log(Level.INFO, "Registering cloud hook for {0}/{1}", new Object[]{client.getRepositoryOwner(), client.getRepositoryName()});
            this.register(this.buildPayload(), client);
        } else if (this.shouldUpdate(existingHook, this.buildPayload())) {
            logger.log(Level.INFO, "Updating cloud hook for {0}/{1}", new Object[]{client.getRepositoryOwner(), client.getRepositoryName()});
            this.update(existingHook, client);
        }
    }
}

