/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.filesystem;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import jenkins.scm.api.SCMFile;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class BitbucketSCMFile
extends SCMFile {
    private final BitbucketApi api;
    private String ref;
    private final String hash;
    private boolean resolved;

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public BitbucketSCMFile(BitbucketApi api, String ref, String hash) {
        this.api = api;
        this.ref = ref;
        this.hash = hash;
        this.resolved = false;
    }

    public BitbucketSCMFile(BitbucketSCMFile parent, String name, @CheckForNull SCMFile.Type type, String hash) {
        super((SCMFile)parent, name);
        this.api = parent.api;
        this.ref = parent.ref;
        this.hash = hash;
        if (type != null) {
            this.type(type);
        }
        this.resolved = type != null;
    }

    public String getHash() {
        return this.hash;
    }

    @Restricted(value={NoExternalUse.class})
    public void setType(SCMFile.Type type) {
        this.type(type);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException, InterruptedException {
        if (this.isDirectory()) {
            return this.api.getDirectoryContent(this);
        }
        return Collections.emptyList();
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        if (this.isFile()) {
            return this.api.getFileContent(this);
        }
        throw new IOException("Cannot get raw content from a directory");
    }

    public long lastModified() throws IOException, InterruptedException {
        return 0L;
    }

    @NonNull
    protected SCMFile newChild(String name, boolean assumeIsDirectory) {
        return new BitbucketSCMFile(this, name, null, this.hash);
    }

    @NonNull
    public BitbucketSCMFile child(@NonNull String path, @NonNull SCMFile.Type type) {
        BitbucketSCMFile scmFile = (BitbucketSCMFile)super.child(path);
        scmFile.type(type);
        scmFile.resolved = true;
        return scmFile;
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        if (!this.resolved) {
            try {
                SCMFile metadata = this.api.getFile(this);
                this.type(metadata.getType());
            }
            catch (IOException e) {
                this.type(SCMFile.Type.NONEXISTENT);
            }
            this.resolved = true;
        }
        return this.getType();
    }
}

