/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api.endpoint;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.util.BitbucketCredentialsUtils;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Describable;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.Strings;

public interface BitbucketEndpoint
extends Describable<BitbucketEndpoint> {
    @CheckForNull
    public String getDisplayName();

    @NonNull
    public String getRepositoryURL(@NonNull String var1, @NonNull String var2);

    @NonNull
    public EndpointType getType();

    @NonNull
    public String getServerURL();

    @NonNull
    public BitbucketWebhookConfiguration getWebhook();

    @Deprecated(since="937.0.0", forRemoval=true)
    public boolean isManageHooks();

    @Deprecated(since="937.0.0", forRemoval=true)
    public void setManageHooks(boolean var1, @CheckForNull String var2);

    @Deprecated(since="937.0.0", forRemoval=true)
    @CheckForNull
    public String getCredentialsId();

    @Deprecated(since="937.0.0", forRemoval=true)
    @NonNull
    public String getEndpointJenkinsRootURL();

    @Deprecated(since="937.0.0", forRemoval=true)
    @CheckForNull
    default public StandardCredentials credentials() {
        String credentialsId = Util.fixEmptyAndTrim((String)this.getWebhook().getCredentialsId());
        if (credentialsId == null) {
            return null;
        }
        return BitbucketCredentialsUtils.lookupCredentials(Jenkins.get(), this.getServerURL(), credentialsId, StandardCredentials.class);
    }

    default public boolean isEquals(BitbucketEndpoint endpoint) {
        return Strings.CI.equals(this.getServerURL(), endpoint.getServerURL());
    }

    default public BitbucketEndpointDescriptor getDescriptor() {
        return (BitbucketEndpointDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }
}

