/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketDefaultBranch;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMBuilder;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketLink;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceRequest;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketBranch;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketHref;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketMirroredRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketMirroredRepositoryDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketProject;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRequestException;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketTeam;
import com.cloudbees.jenkins.plugins.bitbucket.api.HasPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.api.PullRequestBranchType;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.UserRoleInRepository;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketEndpointConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.avatars.BitbucketRepoAvatarMetadataAction;
import com.cloudbees.jenkins.plugins.bitbucket.impl.extension.BitbucketEnvVarExtension;
import com.cloudbees.jenkins.plugins.bitbucket.impl.extension.GitClientAuthenticatorExtension;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.DateUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.MirrorListSupplier;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerAPIClient;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import com.cloudbees.jenkins.plugins.bitbucket.trait.BranchDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.trait.ForkPullRequestDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.trait.OriginPullRequestDiscoveryTrait;
import com.cloudbees.jenkins.plugins.bitbucket.trait.SSHCheckoutTrait;
import com.cloudbees.jenkins.plugins.bitbucket.trait.ShowBitbucketAvatarTrait;
import com.cloudbees.jenkins.plugins.bitbucket.util.BitbucketCredentialsUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.util.FormFillFailure;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import jenkins.plugins.git.GitTagSCMHead;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.metadata.PrimaryInstanceMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.form.NamedArrayList;
import jenkins.scm.impl.trait.Discovery;
import jenkins.scm.impl.trait.Selection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.accmod.restrictions.ProtectedExternally;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class BitbucketSCMSource
extends SCMSource {
    private static final Logger LOGGER = Logger.getLogger(BitbucketSCMSource.class.getName());
    private static final String CLOUD_REPO_TEMPLATE = "{/owner,repo}";
    private static final String SERVER_REPO_TEMPLATE = "/projects{/owner}/repos{/repo}";
    private static int eventDelaySeconds = Math.min(300, Math.max(0, Integer.getInteger(BitbucketSCMSource.class.getName() + ".eventDelaySeconds", 5)));
    @NonNull
    private String serverUrl = "https://bitbucket.org";
    @CheckForNull
    private String credentialsId;
    @CheckForNull
    private String mirrorId;
    @NonNull
    private final String repoOwner;
    @NonNull
    private final String repository;
    @NonNull
    private List<SCMSourceTrait> traits;
    @CheckForNull
    private transient Map<String, String> pullRequestTitleCache;
    @CheckForNull
    private transient Map<String, ContributorMetadataAction> pullRequestContributorCache;
    @CheckForNull
    private transient List<BitbucketHref> primaryCloneLinks = null;
    @CheckForNull
    private transient List<BitbucketHref> mirrorCloneLinks = null;

    @DataBoundConstructor
    public BitbucketSCMSource(@NonNull String repoOwner, @NonNull String repository) {
        this.repoOwner = repoOwner;
        this.repository = repository;
        this.traits = new ArrayList<SCMSourceTrait>();
    }

    @Deprecated
    public BitbucketSCMSource(@CheckForNull String id, @NonNull String repoOwner, @NonNull String repository) {
        this(repoOwner, repository);
        this.setId(id);
        this.traits.add(new BranchDiscoveryTrait(true, true));
        this.traits.add(new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)));
        this.traits.add(new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustTeamForks()));
    }

    @CheckForNull
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(@CheckForNull String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public String getMirrorId() {
        return this.mirrorId;
    }

    @DataBoundSetter
    public void setMirrorId(String mirrorId) {
        this.mirrorId = Util.fixEmpty((String)mirrorId);
    }

    @NonNull
    public String getRepoOwner() {
        return this.repoOwner;
    }

    @NonNull
    public String getRepository() {
        return this.repository;
    }

    @NonNull
    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(@CheckForNull String serverURL) {
        this.serverUrl = serverURL == null ? BitbucketEndpointConfiguration.get().getDefaultEndpoint().getServerURL() : Util.fixNull((String)URLUtils.normalizeURL(serverURL));
    }

    @NonNull
    public List<SCMSourceTrait> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    @DataBoundSetter
    public void setTraits(@CheckForNull List<SCMSourceTrait> traits) {
        this.traits = new ArrayList<SCMSourceTrait>(Util.fixNull(traits));
    }

    public BitbucketApi buildBitbucketClient() {
        return this.buildBitbucketClient(this.repoOwner, this.repository);
    }

    public BitbucketApi buildBitbucketClient(PullRequestSCMHead head) {
        return this.buildBitbucketClient(head.getRepoOwner(), head.getRepository());
    }

    public BitbucketApi buildBitbucketClient(String repoOwner, String repository) {
        return BitbucketApiFactory.newInstance(this.getServerUrl(), this.authenticator(), repoOwner, null, repository);
    }

    public void afterSave() {
        try (BitbucketApi client = this.buildBitbucketClient();){
            this.gatherPrimaryCloneLinks(client);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not determine clone links of " + this.getRepoOwner() + "/" + this.getRepository() + " on " + this.getServerUrl() + " for " + this.getOwner() + " falling back to generated links", e);
        }
    }

    private void gatherPrimaryCloneLinks(@NonNull BitbucketApi apiClient) throws IOException {
        BitbucketRepository r = apiClient.getRepository();
        Map<String, List<BitbucketHref>> links = r.getLinks();
        if (links != null && links.containsKey("clone")) {
            this.setPrimaryCloneLinks(links.get("clone"));
        }
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        try (BitbucketSCMSourceRequest request = ((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(criteria, observer).withTraits(this.traits)).newRequest(this, listener);){
            StandardCredentials scanCredentials = this.credentials();
            if (scanCredentials == null) {
                listener.getLogger().format("Connecting to %s with no credentials, anonymous access%n", this.getServerUrl());
            } else {
                Optional.ofNullable(this.getOwner()).ifPresent(item -> CredentialsProvider.track((Item)item, (Credentials)scanCredentials));
                listener.getLogger().format("Connecting to %s using %s%n", this.getServerUrl(), CredentialsNameProvider.name((Credentials)scanCredentials));
            }
            this.gatherPrimaryCloneLinks(this.buildBitbucketClient());
            if (request.isFetchPRs() && event instanceof HasPullRequests) {
                HasPullRequests hasPrEvent = (HasPullRequests)event;
                request.setPullRequests(this.getBitbucketPullRequestsFromEvent(hasPrEvent, listener));
            }
            if (request.isFetchPRs() && !request.isComplete()) {
                this.retrievePullRequests(request);
            }
            if (request.isFetchBranches() && !request.isComplete()) {
                this.retrieveBranches(request);
            }
            if (request.isFetchTags() && !request.isComplete()) {
                this.retrieveTags(request);
            }
        }
    }

    private Iterable<BitbucketPullRequest> getBitbucketPullRequestsFromEvent(@NonNull HasPullRequests incomingPrEvent, @NonNull TaskListener listener) throws IOException, InterruptedException {
        HashSet<BitbucketPullRequest> initializedPRs = new HashSet<BitbucketPullRequest>();
        try (BitbucketApi bitBucket = this.buildBitbucketClient();){
            Iterable<BitbucketPullRequest> pullRequests = incomingPrEvent.getPullRequests(this);
            for (BitbucketPullRequest pr : pullRequests) {
                initializedPRs.add(bitBucket.getPullRequestById(Integer.parseInt(pr.getId())));
                listener.getLogger().format("Initialized PR: %s%n", pr.getLink());
            }
        }
        return initializedPRs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrievePullRequests(final BitbucketSCMSourceRequest request) throws IOException, InterruptedException {
        String fullName = this.repoOwner + "/" + this.repository;
        try (BitbucketApi originClient = this.buildBitbucketClient();){
            if (request.isSkipPublicPRs() && !originClient.isPrivate()) {
                request.listener().getLogger().printf("Skipping pull requests for %s (public repository)%n", fullName);
                return;
            }
        }
        request.listener().getLogger().printf("Looking up %s for pull requests%n", fullName);
        HashSet<String> livePRs = new HashSet<String>();
        int count = 0;
        Map<Boolean, Set<ChangeRequestCheckoutStrategy>> strategies = request.getPRStrategies();
        for (final BitbucketPullRequest pull : request.getPullRequests()) {
            class Skip
            extends IOException {
                Skip() {
                }
            }
            String originalBranchName = pull.getSource().getBranch().getName();
            request.listener().getLogger().printf("Checking PR-%s from %s and %s %s%n", pull.getId(), pull.getSource().getRepository().getFullName(), pull.getSource().getBranchType() == PullRequestBranchType.TAG ? "tag" : "branch", originalBranchName);
            boolean fork = !Strings.CI.equals(fullName, pull.getSource().getRepository().getFullName());
            String pullRepoOwner = pull.getSource().getRepository().getOwnerName();
            String pullRepository = pull.getSource().getRepository().getRepositoryName();
            BitbucketApi forkClient = fork && BitbucketApiUtils.isCloud(this.getServerUrl()) ? BitbucketApiFactory.newInstance(this.getServerUrl(), this.authenticator(), pullRepoOwner, null, pullRepository) : null;
            ++count;
            livePRs.add(pull.getId());
            this.getPullRequestTitleCache().put(pull.getId(), StringUtils.defaultString((String)pull.getTitle()));
            this.getPullRequestContributorCache().put(pull.getId(), new ContributorMetadataAction(pull.getAuthorIdentifier(), pull.getAuthorLogin(), pull.getAuthorEmail()));
            try {
                for (ChangeRequestCheckoutStrategy strategy : strategies.get(fork)) {
                    BitbucketSCMSourceRequest.BitbucketRevisionFactory<BitbucketCommit> revisionFactory;
                    SCMSourceRequest.ProbeLambda probeFactory;
                    SCMSourceRequest.IntermediateLambda intermediateFactory;
                    PullRequestSCMHead head;
                    String branchName = "PR-" + pull.getId();
                    if (strategies.get(fork).size() > 1) {
                        branchName = "PR-" + pull.getId() + "-" + strategy.name().toLowerCase(Locale.ENGLISH);
                    }
                    if (!request.process(head = new PullRequestSCMHead(branchName, pullRepoOwner, pullRepository, originalBranchName, pull, this.originOf(pullRepoOwner, pullRepository), strategy), intermediateFactory = () -> new BranchHeadCommit(pull.getSource().getBranch()), probeFactory = forkClient != null ? request.buildProbeLamda(forkClient) : request.defaultProbeLamda(), revisionFactory = new BitbucketSCMSourceRequest.BitbucketRevisionFactory<BitbucketCommit>(null){

                        @Override
                        public SCMRevision create(SCMHead head, BitbucketCommit sourceCommit) throws IOException, InterruptedException {
                            try {
                                BranchHeadCommit targetCommit = new BranchHeadCommit(pull.getDestination().getBranch());
                                return super.create(head, sourceCommit, targetCommit);
                            }
                            catch (BitbucketRequestException e) {
                                if (BitbucketApiUtils.isCloud(BitbucketSCMSource.this.getServerUrl()) && e.getHttpCode() == 403) {
                                    request.listener().getLogger().printf("Skipping %s because of %s%n", pull.getId(), HyperlinkNote.encodeTo((String)"https://bitbucket.org/site/master/issues/5814/reify-pull-requests-by-making-them-a-ref", (String)"a permission issue accessing pull requests from forks"));
                                    throw new Skip();
                                }
                                e.printStackTrace(request.listener().getLogger());
                                if (e.getHttpCode() == 403) {
                                    throw new Skip();
                                }
                                throw e;
                            }
                        }
                    }, new SCMSourceRequest.Witness[]{request.defaultWitness()})) continue;
                    request.listener().getLogger().format("%n  %d pull requests were processed (query completed)%n", count);
                    return;
                }
            }
            catch (Skip e) {
                request.listener().getLogger().println("Do not have permission to view PR from " + pull.getSource().getRepository().getFullName() + " and branch " + originalBranchName);
            }
            finally {
                if (forkClient == null) continue;
                forkClient.close();
            }
        }
        request.listener().getLogger().format("%n  %d pull requests were processed%n", count);
        this.getPullRequestTitleCache().keySet().retainAll(livePRs);
        this.getPullRequestContributorCache().keySet().retainAll(livePRs);
    }

    private void retrieveBranches(BitbucketSCMSourceRequest request) throws IOException, InterruptedException {
        String fullName = this.repoOwner + "/" + this.repository;
        request.listener().getLogger().println("Looking up " + fullName + " for branches");
        int count = 0;
        for (BitbucketBranch branch : request.getBranches()) {
            request.listener().getLogger().println("Checking branch " + branch.getName() + " from " + fullName);
            ++count;
            BranchSCMHead head = new BranchSCMHead(branch.getName());
            if (!request.process(head, () -> new BranchHeadCommit(branch))) continue;
            request.listener().getLogger().format("%n  %d branches were processed (query completed)%n", count);
            return;
        }
        request.listener().getLogger().format("%n  %d branches were processed%n", count);
    }

    private void retrieveTags(BitbucketSCMSourceRequest request) throws IOException, InterruptedException {
        String fullName = this.repoOwner + "/" + this.repository;
        request.listener().getLogger().println("Looking up " + fullName + " for tags");
        int count = 0;
        for (BitbucketBranch tag : request.getTags()) {
            request.listener().getLogger().println("Checking tag " + tag.getName() + " from " + fullName);
            ++count;
            BitbucketTagSCMHead head = new BitbucketTagSCMHead(tag.getName(), tag.getDateMillis());
            if (!request.process(head, tag::getRawNode)) continue;
            request.listener().getLogger().format("%n  %d tags were processed (query completed)%n", count);
            return;
        }
        request.listener().getLogger().format("%n  %d tags were processed%n", count);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SCMRevision retrieve(SCMHead head, TaskListener listener) throws IOException, InterruptedException {
        try (BitbucketApi client = this.buildBitbucketClient();){
            if (head instanceof PullRequestSCMHead) {
                PullRequestSCMRevision pullRequestSCMRevision;
                BitbucketCommit sourceRevision;
                BitbucketCommit targetRevision;
                PullRequestSCMHead prHead = (PullRequestSCMHead)head;
                if (BitbucketApiUtils.isCloud(client)) {
                    BitbucketBranch branch;
                    BitbucketBranch targetBranch = client.getBranch(prHead.getTarget().getName());
                    if (targetBranch == null) {
                        listener.getLogger().format("No branch found in %s/%s with name [%s]", this.repoOwner, this.repository, prHead.getTarget().getName());
                        SCMRevision sCMRevision = null;
                        return sCMRevision;
                    }
                    targetRevision = this.findCommit(targetBranch, listener);
                    if (targetRevision == null) {
                        listener.getLogger().format("No branch found in %s/%s with name [%s]", this.repoOwner, this.repository, prHead.getTarget().getName());
                        SCMRevision sCMRevision = null;
                        return sCMRevision;
                    }
                    if (head.getOrigin() == SCMHeadOrigin.DEFAULT) {
                        branch = client.getBranch(prHead.getBranchName());
                    } else {
                        try (BitbucketApi forkClient = this.buildBitbucketClient(prHead);){
                            branch = forkClient.getBranch(prHead.getBranchName());
                        }
                    }
                    if (branch == null) {
                        listener.getLogger().format("No branch found in %s/%s with name [%s]", this.repoOwner, this.repository, head.getName());
                        SCMRevision sCMRevision = null;
                        return sCMRevision;
                    }
                    sourceRevision = this.findCommit(branch, listener);
                } else {
                    BitbucketPullRequest pr;
                    try {
                        pr = client.getPullRequestById(Integer.parseInt(prHead.getId()));
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.log(Level.WARNING, "Cannot parse the PR id {0}", prHead.getId());
                        SCMRevision sCMRevision = null;
                        if (client == null) return sCMRevision;
                        client.close();
                        return sCMRevision;
                    }
                    targetRevision = this.findPRDestinationCommit(pr, listener);
                    if (targetRevision == null) {
                        listener.getLogger().format("No branch found in %s/%s with name [%s]", this.repoOwner, this.repository, prHead.getTarget().getName());
                        SCMRevision sCMRevision = null;
                        return sCMRevision;
                    }
                    sourceRevision = this.findPRSourceCommit(pr, listener);
                }
                if (sourceRevision == null) {
                    listener.getLogger().format("No revision found in %s/%s for PR-%s [%s]", prHead.getRepoOwner(), prHead.getRepository(), prHead.getId(), prHead.getBranchName());
                    pullRequestSCMRevision = null;
                    return pullRequestSCMRevision;
                }
                pullRequestSCMRevision = new PullRequestSCMRevision(prHead, (SCMRevision)new BitbucketGitSCMRevision(prHead.getTarget(), targetRevision), (SCMRevision)new BitbucketGitSCMRevision(prHead, sourceRevision));
                return pullRequestSCMRevision;
            }
            if (head instanceof BitbucketTagSCMHead) {
                BitbucketTagSCMHead tagHead = (BitbucketTagSCMHead)head;
                BitbucketBranch tag = client.getTag(tagHead.getName());
                if (tag == null) {
                    listener.getLogger().format("No tag found in %s/%s with name [%s]", this.repoOwner, this.repository, head.getName());
                    SCMRevision targetRevision = null;
                    return targetRevision;
                }
                BitbucketCommit revision = this.findCommit(tag, listener);
                if (revision == null) {
                    listener.getLogger().format("No revision found in %s/%s with name [%s]", this.repoOwner, this.repository, head.getName());
                    SCMRevision sCMRevision = null;
                    return sCMRevision;
                }
                BitbucketTagSCMRevision bitbucketTagSCMRevision = new BitbucketTagSCMRevision(tagHead, revision);
                return bitbucketTagSCMRevision;
            }
            BitbucketBranch branch = client.getBranch(head.getName());
            if (branch == null) {
                listener.getLogger().format("No branch found in %s/%s with name [%s]", this.repoOwner, this.repository, head.getName());
                SCMRevision revision = null;
                return revision;
            }
            BitbucketCommit revision = this.findCommit(branch, listener);
            if (revision == null) {
                listener.getLogger().format("No revision found in %s/%s with name [%s]", this.repoOwner, this.repository, head.getName());
                SCMRevision sCMRevision = null;
                return sCMRevision;
            }
            BitbucketGitSCMRevision bitbucketGitSCMRevision = new BitbucketGitSCMRevision(head, revision);
            return bitbucketGitSCMRevision;
        }
        catch (IOException e) {
            BitbucketRequestException bre = BitbucketApiUtils.unwrap(e);
            if (bre == null) throw e;
            SCMSourceOwner scmSourceOwner = this.getOwner();
            if (bre.getHttpCode() != 401) throw e;
            if (scmSourceOwner == null) throw e;
            LOGGER.log(Level.WARNING, "BitbucketRequestException: Authz error. Status: 401 for Item '{0}' using credentialId '{1}'", new Object[]{scmSourceOwner.getFullDisplayName(), this.getCredentialsId()});
            throw e;
        }
    }

    private BitbucketCommit findCommit(@NonNull BitbucketBranch branch, TaskListener listener) {
        String revision = branch.getRawNode();
        if (revision == null) {
            if ("https://bitbucket.org".equals(this.getServerUrl())) {
                listener.getLogger().format("Cannot resolve the hash of the revision in branch %s%n", branch.getName());
            } else {
                listener.getLogger().format("Cannot resolve the hash of the revision in branch %s. Perhaps you are using Bitbucket Server previous to 4.x%n", branch.getName());
            }
            return null;
        }
        return new BranchHeadCommit(branch);
    }

    private BitbucketCommit findPRSourceCommit(BitbucketPullRequest pr, TaskListener listener) {
        BitbucketBranch branch = pr.getSource().getBranch();
        String hash = branch.getRawNode();
        if (hash == null) {
            if ("https://bitbucket.org".equals(this.getServerUrl())) {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s%n", pr.getId());
            } else {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s. Perhaps you are using Bitbucket Server previous to 4.x%n", pr.getId());
            }
            return null;
        }
        return new BranchHeadCommit(branch);
    }

    private BitbucketCommit findPRDestinationCommit(BitbucketPullRequest pr, TaskListener listener) {
        BitbucketBranch branch = pr.getDestination().getBranch();
        String hash = branch.getRawNode();
        if (hash == null) {
            if ("https://bitbucket.org".equals(this.getServerUrl())) {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s%n", pr.getId());
            } else {
                listener.getLogger().format("Cannot resolve the hash of the revision in PR-%s. Perhaps you are using Bitbucket Server previous to 4.x%n", pr.getId());
            }
            return null;
        }
        return new BranchHeadCommit(branch);
    }

    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        this.initCloneLinks();
        SSHCheckoutTrait sshTrait = (SSHCheckoutTrait)SCMTrait.find(this.traits, SSHCheckoutTrait.class);
        String checkoutCredentialsId = sshTrait != null ? sshTrait.getCredentialsId() : this.credentialsId;
        BitbucketGitSCMBuilder scmBuilder = (BitbucketGitSCMBuilder)((BitbucketGitSCMBuilder)new BitbucketGitSCMBuilder(this, head, revision, checkoutCredentialsId).withExtension(new BitbucketEnvVarExtension(this.getRepoOwner(), this.getRepository(), this.getProjectKey(), this.getServerUrl()))).withCloneLinks(this.primaryCloneLinks, this.mirrorCloneLinks).withTraits(this.traits);
        String checkoutURL = scmBuilder.remote();
        String scmOwner = Optional.ofNullable(this.getOwner()).map(Item::getFullName).orElse(null);
        return ((BitbucketGitSCMBuilder)scmBuilder.withExtension(new GitClientAuthenticatorExtension(checkoutURL, this.serverUrl, scmOwner, sshTrait != null ? null : checkoutCredentialsId))).build();
    }

    @Restricted(value={ProtectedExternally.class})
    @CheckForNull
    protected String getProjectKey() {
        String projectKey = null;
        try {
            BitbucketProject project = this.buildBitbucketClient().getRepository().getProject();
            if (project != null) {
                projectKey = project.getKey();
            }
        }
        catch (IOException e) {
            LOGGER.severe("Failure getting the project key of repository " + this.getRepository() + " : " + e.getMessage());
        }
        return projectKey;
    }

    private void setPrimaryCloneLinks(List<BitbucketHref> links) {
        links.forEach(link -> {
            if (StringUtils.startsWithIgnoreCase((CharSequence)link.getName(), (CharSequence)"http")) {
                link.setHref(URLUtils.removeAuthority(link.getHref()));
            }
        });
        this.primaryCloneLinks = links;
    }

    @NonNull
    public SCMRevision getTrustedRevision(@NonNull SCMRevision revision, @NonNull TaskListener listener) throws IOException, InterruptedException {
        if (revision instanceof PullRequestSCMRevision) {
            PullRequestSCMRevision prRevision = (PullRequestSCMRevision)revision;
            PullRequestSCMHead head = (PullRequestSCMHead)revision.getHead();
            try (BitbucketSCMSourceRequest request = ((BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(this.traits)).newRequest(this, listener);){
                if (request.isTrusted(head)) {
                    SCMRevision sCMRevision = revision;
                    return sCMRevision;
                }
            }
            listener.getLogger().format("Loading trusted files from base branch %s at %s rather than %s%n", head.getTarget().getName(), prRevision.getTarget(), prRevision.getPull());
            return prRevision.getTarget();
        }
        return revision;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @CheckForNull
    StandardCredentials credentials() {
        return BitbucketCredentialsUtils.lookupCredentials((Item)this.getOwner(), this.getServerUrl(), this.getCredentialsId(), StandardCredentials.class);
    }

    @CheckForNull
    BitbucketAuthenticator authenticator() {
        return (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.getServerUrl()), (Credentials)this.credentials());
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<Action> result = new ArrayList<Action>();
        try (BitbucketApi client = this.buildBitbucketClient();){
            this.gatherPrimaryCloneLinks(client);
            BitbucketRepository repo = client.getRepository();
            result.add((Action)new BitbucketRepoAvatarMetadataAction(this.showAvatar() ? repo : null));
            String defaultBranch = client.getDefaultBranch();
            if (StringUtils.isNotBlank((CharSequence)defaultBranch)) {
                result.add((Action)new BitbucketDefaultBranch(this.repoOwner, this.repository, defaultBranch));
            }
            UriTemplate template = BitbucketApiUtils.isCloud(this.getServerUrl()) ? UriTemplate.fromTemplate((String)(this.getServerUrl() + CLOUD_REPO_TEMPLATE)) : UriTemplate.fromTemplate((String)(this.getServerUrl() + SERVER_REPO_TEMPLATE));
            String url = template.set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository).expand();
            result.add(new BitbucketLink("icon-bitbucket-repo", url));
            result.add((Action)new ObjectMetadataAction(repo.getRepositoryName(), null, url));
        }
        return result;
    }

    private boolean showAvatar() {
        return SCMTrait.find(this.traits, ShowBitbucketAvatarTrait.class) != null;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        PullRequestSCMHead prHead;
        UriTemplate template;
        ArrayList<Action> result = new ArrayList<Action>();
        String title = null;
        if (BitbucketApiUtils.isCloud(this.getServerUrl())) {
            String resourceId;
            String resourceName;
            if (head instanceof PullRequestSCMHead) {
                PullRequestSCMHead prHead2 = (PullRequestSCMHead)head;
                resourceName = "pull-requests";
                resourceId = prHead2.getId();
            } else if (head instanceof GitTagSCMHead) {
                resourceName = "commits";
                resourceId = head.getName();
            } else {
                resourceName = "branch";
                resourceId = head.getName();
            }
            template = UriTemplate.fromTemplate((String)(this.getServerUrl() + "{/owner,repo}/{resourceName}/{resourceId}")).set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository).set("resourceName", (Object)resourceName).set("resourceId", (Object)resourceId);
        } else if (head instanceof PullRequestSCMHead) {
            prHead = (PullRequestSCMHead)head;
            template = UriTemplate.fromTemplate((String)(this.getServerUrl() + "/projects{/owner}/repos{/repo}/pull-requests/{id}/overview")).set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository).set("id", (Object)prHead.getId());
        } else {
            template = UriTemplate.fromTemplate((String)(this.getServerUrl() + "/projects{/owner}/repos{/repo}/compare/commits{?sourceBranch}")).set("owner", (Object)this.repoOwner).set("repo", (Object)this.repository).set("sourceBranch", (Object)("refs/heads/" + head.getName()));
        }
        if (head instanceof PullRequestSCMHead) {
            prHead = (PullRequestSCMHead)head;
            title = this.getPullRequestTitleCache().get(prHead.getId());
            ContributorMetadataAction contributor = this.getPullRequestContributorCache().get(prHead.getId());
            if (contributor != null) {
                result.add((Action)contributor);
            }
        }
        String url = template.expand();
        result.add(new BitbucketLink("icon-bitbucket-branch", url));
        result.add((Action)new ObjectMetadataAction(title, null, url));
        SCMSourceOwner owner = this.getOwner();
        if (owner instanceof Actionable) {
            Actionable actionable = (Actionable)owner;
            for (BitbucketDefaultBranch p : actionable.getActions(BitbucketDefaultBranch.class)) {
                if (!Strings.CI.equals(this.getRepoOwner(), p.getRepoOwner()) || !Objects.equals(this.repository, p.getRepository()) || !Objects.equals(p.getDefaultBranch(), head.getName())) continue;
                result.add((Action)new PrimaryInstanceMetadataAction());
                break;
            }
        }
        return result;
    }

    @NonNull
    private synchronized Map<String, String> getPullRequestTitleCache() {
        if (this.pullRequestTitleCache == null) {
            this.pullRequestTitleCache = new ConcurrentHashMap<String, String>();
        }
        return this.pullRequestTitleCache;
    }

    @NonNull
    private synchronized Map<String, ContributorMetadataAction> getPullRequestContributorCache() {
        if (this.pullRequestContributorCache == null) {
            this.pullRequestContributorCache = new ConcurrentHashMap<String, ContributorMetadataAction>();
        }
        return this.pullRequestContributorCache;
    }

    @NonNull
    public SCMHeadOrigin originOf(@NonNull String repoOwner, @NonNull String repository) {
        if (this.repository.equalsIgnoreCase(repository)) {
            if (Strings.CI.equals(this.repoOwner, repoOwner)) {
                return SCMHeadOrigin.DEFAULT;
            }
            return new SCMHeadOrigin.Fork(repoOwner);
        }
        return new SCMHeadOrigin.Fork(repoOwner + "/" + repository);
    }

    public static int getEventDelaySeconds() {
        return eventDelaySeconds;
    }

    @Restricted(value={NoExternalUse.class})
    public static void setEventDelaySeconds(int eventDelaySeconds) {
        BitbucketSCMSource.eventDelaySeconds = Math.min(300, Math.max(0, eventDelaySeconds));
    }

    private void initCloneLinks() {
        BitbucketApi bitbucket;
        if (this.primaryCloneLinks == null) {
            bitbucket = this.buildBitbucketClient();
            this.initPrimaryCloneLinks(bitbucket);
            if (this.mirrorId != null && this.mirrorCloneLinks == null) {
                this.initMirrorCloneLinks((BitbucketServerAPIClient)bitbucket, this.mirrorId);
            }
        }
        if (this.mirrorId != null && this.mirrorCloneLinks == null) {
            bitbucket = this.buildBitbucketClient();
            this.initMirrorCloneLinks((BitbucketServerAPIClient)bitbucket, this.mirrorId);
        }
    }

    private void initMirrorCloneLinks(BitbucketServerAPIClient bitbucket, String mirrorIdLocal) {
        try {
            BitbucketServerRepository r = (BitbucketServerRepository)bitbucket.getRepository();
            List<BitbucketMirroredRepositoryDescriptor> mirrors = bitbucket.getMirrors(r.getId());
            BitbucketMirroredRepositoryDescriptor mirroredRepositoryDescriptor = mirrors.stream().filter(it -> mirrorIdLocal.equals(it.getMirrorServer().getId())).findFirst().orElseThrow(() -> new IllegalStateException("Could not find mirror descriptor for mirror id " + mirrorIdLocal));
            if (!mirroredRepositoryDescriptor.getMirrorServer().isEnabled()) {
                throw new IllegalStateException("Mirror is disabled for mirror id " + mirrorIdLocal);
            }
            Map<String, List<BitbucketHref>> mirrorDescriptorLinks = mirroredRepositoryDescriptor.getLinks();
            if (mirrorDescriptorLinks == null) {
                throw new IllegalStateException("There is no repository descriptor links for mirror id " + mirrorIdLocal);
            }
            List<BitbucketHref> self = mirrorDescriptorLinks.get("self");
            if (self == null || self.isEmpty()) {
                throw new IllegalStateException("There is no self-link for mirror id " + mirrorIdLocal);
            }
            String selfLink = self.get(0).getHref();
            BitbucketMirroredRepository mirroredRepository = bitbucket.getMirroredRepository(selfLink);
            if (!mirroredRepository.isAvailable()) {
                throw new IllegalStateException("Mirrored repository is not available for mirror id " + mirrorIdLocal);
            }
            Map<String, List<BitbucketHref>> mirroredRepositoryLinks = mirroredRepository.getLinks();
            if (mirroredRepositoryLinks == null) {
                throw new IllegalStateException("There is no mirrored repository links for mirror id " + mirrorIdLocal);
            }
            List<BitbucketHref> mirroredRepositoryCloneLinks = mirroredRepositoryLinks.get("clone");
            if (mirroredRepositoryCloneLinks == null) {
                throw new IllegalStateException("There is no mirrored repository clone links for mirror id " + mirrorIdLocal);
            }
            this.mirrorCloneLinks = mirroredRepositoryCloneLinks;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Could not determine mirror clone links of " + this.getRepoOwner() + "/" + this.getRepository() + " on " + this.getServerUrl() + " for " + this.getOwner() + " falling back to primary server", e);
        }
    }

    private void initPrimaryCloneLinks(BitbucketApi bitbucket) {
        try {
            BitbucketRepository r = bitbucket.getRepository();
            List<BitbucketHref> cloneLinks = r.getCloneLinks();
            if (cloneLinks.isEmpty()) {
                throw new IllegalStateException("There is no clone links");
            }
            this.setPrimaryCloneLinks(cloneLinks);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not determine clone links of " + this.getRepoOwner() + "/" + this.getRepository() + " on " + this.getServerUrl() + " for " + this.getOwner() + " falling back to generated links", e);
        }
    }

    @Deprecated(since="936.0.0", forRemoval=true)
    public boolean isCloud() {
        return BitbucketApiUtils.isCloud(this.serverUrl);
    }

    private static class BranchHeadCommit
    implements BitbucketCommit {
        private final BitbucketBranch branch;

        public BranchHeadCommit(@NonNull BitbucketBranch branch) {
            this.branch = branch;
        }

        @Override
        public String getAuthor() {
            return this.branch.getAuthor();
        }

        @Override
        public String getMessage() {
            return this.branch.getMessage();
        }

        @Override
        public String getDate() {
            return DateUtils.formatToISO(new Date(this.branch.getDateMillis()));
        }

        @Override
        public String getHash() {
            return this.branch.getRawNode();
        }

        @Override
        public long getDateMillis() {
            return this.branch.getDateMillis();
        }
    }

    @Symbol(value={"bitbucket"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public static final String ANONYMOUS = "ANONYMOUS";
        public static final String SAME = "SAME";

        public String getDisplayName() {
            return "Bitbucket";
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull SCMSourceOwner context, @QueryParameter String value, @QueryParameter(fixEmpty=true, value="serverUrl") String serverURL) {
            return BitbucketCredentialsUtils.checkCredentialsId(context, value, serverURL);
        }

        public static FormValidation doCheckServerUrl(@AncestorInPath SCMSourceOwner context, @QueryParameter String value) {
            if (context == null && !Jenkins.get().hasPermission(Jenkins.MANAGE) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.error((String)"Unauthorized to validate Server URL");
            }
            if (!BitbucketEndpointProvider.lookupEndpoint(value).isPresent()) {
                return FormValidation.error((String)("Unregistered Server: " + value));
            }
            return FormValidation.ok();
        }

        public boolean isServerUrlSelectable() {
            return !BitbucketEndpointProvider.all().isEmpty();
        }

        public ListBoxModel doFillServerUrlItems(@AncestorInPath SCMSourceOwner context) {
            Jenkins contextToCheck;
            Object object = contextToCheck = context == null ? Jenkins.get() : context;
            if (!contextToCheck.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            return BitbucketEndpointProvider.listEndpoints();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl) {
            return BitbucketCredentialsUtils.listCredentials((Item)context, serverUrl, null);
        }

        @RequirePOST
        public ListBoxModel doFillRepositoryItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String repoOwner) throws IOException {
            BitbucketApiUtils.BitbucketSupplier<ListBoxModel> listBoxModelSupplier = bitbucket -> {
                ListBoxModel result = new ListBoxModel();
                BitbucketTeam team = bitbucket.getTeam();
                List<? extends BitbucketRepository> repositories = bitbucket.getRepositories(team != null ? null : UserRoleInRepository.CONTRIBUTOR);
                if (repositories.isEmpty()) {
                    throw FormFillFailure.error((String)Messages.BitbucketSCMSource_NoMatchingOwner(repoOwner)).withSelectionCleared();
                }
                for (BitbucketRepository bitbucketRepository : repositories) {
                    result.add(bitbucketRepository.getRepositoryName());
                }
                return result;
            };
            return BitbucketApiUtils.getFromBitbucket(context, serverUrl, credentialsId, repoOwner, null, listBoxModelSupplier);
        }

        public ListBoxModel doFillMirrorIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String serverUrl, @QueryParameter String credentialsId, @QueryParameter String repoOwner, @QueryParameter String repository) throws FormFillFailure {
            return BitbucketApiUtils.getFromBitbucket(context, serverUrl, credentialsId, repoOwner, repository, MirrorListSupplier.INSTANCE);
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{new UncategorizedSCMHeadCategory(Messages._BitbucketSCMSource_UncategorizedSCMHeadCategory_DisplayName()), new ChangeRequestSCMHeadCategory(Messages._BitbucketSCMSource_ChangeRequestSCMHeadCategory_DisplayName()), new TagSCMHeadCategory(Messages._BitbucketSCMSource_TagSCMHeadCategory_DisplayName())};
        }

        public List<NamedArrayList<? extends SCMSourceTraitDescriptor>> getTraitsDescriptorLists() {
            ArrayList all = new ArrayList();
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, BitbucketSCMSourceContext.class, null));
            all.addAll(SCMSourceTrait._for((SCMSourceDescriptor)this, null, BitbucketGitSCMBuilder.class));
            HashSet<SCMSourceTraitDescriptor> dedup = new HashSet<SCMSourceTraitDescriptor>();
            Iterator iterator = all.iterator();
            while (iterator.hasNext()) {
                SCMSourceTraitDescriptor d = (SCMSourceTraitDescriptor)iterator.next();
                if (dedup.contains(d) || d instanceof GitBrowserSCMSourceTrait.DescriptorImpl) {
                    iterator.remove();
                    continue;
                }
                dedup.add(d);
            }
            ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>> result = new ArrayList<NamedArrayList<? extends SCMSourceTraitDescriptor>>();
            NamedArrayList.select(all, (String)"Within repository", (NamedArrayList.Predicate)NamedArrayList.anyOf((NamedArrayList.Predicate[])new NamedArrayList.Predicate[]{NamedArrayList.withAnnotation(Discovery.class), NamedArrayList.withAnnotation(Selection.class)}), (boolean)true, result);
            int insertionPoint = result.size();
            NamedArrayList.select(all, (String)"Git", it -> GitSCM.class.isAssignableFrom(it.getScmClass()), (boolean)true, result);
            NamedArrayList.select(all, (String)"General", null, (boolean)true, result, (int)insertionPoint);
            return result;
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Arrays.asList(new SCMSourceTrait[]{new BranchDiscoveryTrait(true, false), new OriginPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE)), new ForkPullRequestDiscoveryTrait(EnumSet.of(ChangeRequestCheckoutStrategy.MERGE), (SCMHeadAuthority<? super BitbucketSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision>)new ForkPullRequestDiscoveryTrait.TrustTeamForks())});
        }
    }
}

